/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;

public class DoodleText
extends DoodleRotatableItemBase {
    private final Paint mPaint = new Paint();
    private String mText;

    public DoodleText(IDoodle doodle, String text, float size, IDoodleColor color, float x, float y) {
        super(doodle, -doodle.getDoodleRotation(), x, y);
        this.setPen(DoodlePen.TEXT);
        this.mText = text;
        this.setSize(size);
        this.setColor(color);
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String text) {
        this.mText = text;
        this.resetBounds(this.getBounds());
        this.setPivotX(this.getLocation().x + (float)(this.getBounds().width() / 2));
        this.setPivotY(this.getLocation().y - (float)(this.getBounds().height() / 2));
    }

    @Override
    public void setSize(float size) {
        float oldPivotX = this.getPivotX();
        float oldPivotY = this.getPivotY();
        super.setSize(size);
        this.setPivotX(this.getLocation().x + (float)(this.getBounds().width() / 2));
        this.setPivotY(this.getLocation().y - (float)(this.getBounds().height() / 2));
        this.setLocation(this.getLocation().x - (this.getPivotX() - oldPivotX), this.getLocation().y - (this.getPivotY() - oldPivotY));
    }

    @Override
    public void resetBounds(Rect rect) {
        if (TextUtils.isEmpty((CharSequence)this.mText)) {
            return;
        }
        this.mPaint.setTextSize(this.getSize());
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.getTextBounds(this.mText, 0, this.mText.length(), rect);
    }

    @Override
    public void doDraw(Canvas canvas) {
        this.getColor().config(this, this.mPaint);
        this.mPaint.setTextSize(this.getSize());
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawText(this.mText, 0.0f, 0.0f, this.mPaint);
    }
}

