/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePath;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;

public enum DoodlePen implements IDoodlePen
{
    BRUSH,
    COPY,
    ERASER,
    TEXT,
    BITMAP;

    private CopyLocation mCopyLocation;
    private Matrix mMatrix;

    @Override
    public void config(IDoodleItem item, Paint paint) {
        DoodleItemBase doodleItem = (DoodleItemBase)item;
        if (doodleItem.getPen() == COPY) {
            float transX = 0.0f;
            float transY = 0.0f;
            float transXSpan = 0.0f;
            float transYSpan = 0.0f;
            CopyLocation copyLocation = ((DoodlePath)item).getCopyLocation();
            if (copyLocation != null) {
                transXSpan = copyLocation.getTouchStartX() - copyLocation.getCopyStartX();
                transYSpan = copyLocation.getTouchStartY() - copyLocation.getCopyStartY();
            }
            this.mMatrix.reset();
            this.mMatrix.postTranslate(-transX + transXSpan, -transY + transYSpan);
            if (item.getColor() instanceof DoodleColor) {
                ((DoodleColor)item.getColor()).setMatrix(this.mMatrix);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CopyLocation getCopyLocation() {
        if (this != COPY) {
            return null;
        }
        if (this.mCopyLocation == null) {
            DoodlePen doodlePen = this;
            synchronized (doodlePen) {
                if (this.mCopyLocation == null) {
                    this.mCopyLocation = new CopyLocation();
                    this.mMatrix = new Matrix();
                }
            }
        }
        return this.mCopyLocation;
    }

    @Override
    public IDoodlePen copy() {
        return this;
    }

    @Override
    public void drawHelpers(Canvas canvas, IDoodle doodle) {
        if (this == COPY && doodle instanceof DoodleView && !((DoodleView)doodle).isEditMode()) {
            this.mCopyLocation.drawItSelf(canvas, doodle.getSize());
        }
    }
}

