/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItem;

public class DoodleColor
implements IDoodleColor {
    private int mColor;
    private Bitmap mBitmap;
    private Type mType;
    private Matrix mMatrix;
    private Shader.TileMode mTileX = Shader.TileMode.MIRROR;
    private Shader.TileMode mTileY = Shader.TileMode.MIRROR;

    public DoodleColor(int color) {
        this.mType = Type.COLOR;
        this.mColor = color;
    }

    public DoodleColor(Bitmap bitmap) {
        this(bitmap, null);
    }

    public DoodleColor(Bitmap bitmap, Matrix matrix) {
        this(bitmap, matrix, Shader.TileMode.MIRROR, Shader.TileMode.MIRROR);
    }

    public DoodleColor(Bitmap bitmap, Matrix matrix, Shader.TileMode tileX, Shader.TileMode tileY) {
        this.mType = Type.BITMAP;
        this.mMatrix = matrix;
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
    }

    @Override
    public void config(IDoodleItem item, Paint paint) {
        DoodleItemBase doodleItem = (DoodleItemBase)item;
        if (this.mType == Type.COLOR) {
            paint.setColor(this.mColor);
        } else if (this.mType == Type.BITMAP) {
            BitmapShader shader = new BitmapShader(this.mBitmap, this.mTileX, this.mTileY);
            shader.setLocalMatrix(this.mMatrix);
            paint.setShader((Shader)shader);
        }
    }

    public void setColor(int color) {
        this.mType = Type.COLOR;
        this.mColor = color;
    }

    public void setColor(Bitmap bitmap) {
        this.mType = Type.BITMAP;
        this.mBitmap = bitmap;
    }

    public void setColor(Bitmap bitmap, Matrix matrix) {
        this.mType = Type.BITMAP;
        this.mMatrix = matrix;
        this.mBitmap = bitmap;
    }

    public void setColor(Bitmap bitmap, Matrix matrix, Shader.TileMode tileX, Shader.TileMode tileY) {
        this.mType = Type.BITMAP;
        this.mBitmap = bitmap;
        this.mMatrix = matrix;
        this.mTileX = tileX;
        this.mTileY = tileY;
    }

    public void setMatrix(Matrix matrix) {
        this.mMatrix = matrix;
    }

    public Matrix getMatrix() {
        return this.mMatrix;
    }

    public int getColor() {
        return this.mColor;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public Type getType() {
        return this.mType;
    }

    @Override
    public IDoodleColor copy() {
        DoodleColor color = null;
        color = this.mType == Type.COLOR ? new DoodleColor(this.mColor) : new DoodleColor(this.mBitmap);
        color.mTileX = this.mTileX;
        color.mTileY = this.mTileY;
        color.mMatrix = new Matrix(this.mMatrix);
        return color;
    }

    public static enum Type {
        COLOR,
        BITMAP;

    }
}

