/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleRotatableItemBase;
import cn.hzw.doodle.core.IDoodle;

public class DoodleBitmap
extends DoodleRotatableItemBase {
    private Bitmap mBitmap;
    private Rect mSrcRect = new Rect();
    private Rect mDstRect = new Rect();

    public DoodleBitmap(IDoodle doodle, Bitmap bitmap, float size, float x, float y) {
        super(doodle, -doodle.getDoodleRotation(), x, y);
        this.setPen(DoodlePen.BITMAP);
        this.setPivotX(x);
        this.setPivotY(y);
        this.mBitmap = bitmap;
        this.setSize(size);
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.resetBounds(this.getBounds());
        this.setPivotX(this.getLocation().x + (float)(this.getBounds().width() / 2));
        this.setPivotY(this.getLocation().y + (float)(this.getBounds().height() / 2));
    }

    @Override
    public void setSize(float size) {
        float oldPivotX = this.getPivotX();
        float oldPivotY = this.getPivotY();
        super.setSize(size);
        this.setPivotX(this.getLocation().x + (float)(this.getBounds().width() / 2));
        this.setPivotY(this.getLocation().y + (float)(this.getBounds().height() / 2));
        this.setLocation(this.getLocation().x - (this.getPivotX() - oldPivotX), this.getLocation().y - (this.getPivotY() - oldPivotY));
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public void resetBounds(Rect rect) {
        if (this.mBitmap == null) {
            return;
        }
        float size = this.getSize();
        rect.set(0, 0, (int)size, (int)(size * (float)this.mBitmap.getHeight() / (float)this.mBitmap.getWidth()));
        this.mSrcRect.set(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
        this.mDstRect.set(0, 0, (int)size, (int)(size * (float)this.mBitmap.getHeight()) / this.mBitmap.getWidth());
    }

    @Override
    public void doDraw(Canvas canvas) {
        canvas.drawBitmap(this.mBitmap, this.mSrcRect, this.mDstRect, null);
    }
}

