/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import cn.hzw.doodle.CopyLocation;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePaintAttrs;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.core.IDoodle;

public class DoodlePath
extends DoodleItemBase {
    private Path mPath;
    private PointF mSxy = new PointF();
    private PointF mDxy = new PointF();
    private Paint mPaint = new Paint();
    private CopyLocation mCopyLocation;

    public DoodlePath(IDoodle doodle) {
        super(doodle);
    }

    public DoodlePath(IDoodle doodle, DoodlePaintAttrs attrs) {
        super(doodle, attrs);
    }

    public void updateXY(float sx, float sy, float dx, float dy) {
        this.mSxy.set(sx, sy);
        this.mDxy.set(dx, dy);
    }

    public void updatePath(Path path) {
        this.mPath = path;
    }

    public void updateCopy(float touchStartX, float touchStartY, float copyStartX, float copyStartY) {
        if (this.mCopyLocation == null) {
            return;
        }
        this.mCopyLocation.setStartPosition(touchStartX, touchStartY, copyStartX, copyStartY);
    }

    public CopyLocation getCopyLocation() {
        return this.mCopyLocation;
    }

    public Path getPath() {
        return this.mPath;
    }

    public PointF getDxy() {
        return this.mDxy;
    }

    public PointF getSxy() {
        return this.mSxy;
    }

    public static DoodlePath toShape(IDoodle doodle, float sx, float sy, float dx, float dy) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.mSxy.set(sx, sy);
        path.mDxy.set(dx, dy);
        if (path.getPen() == DoodlePen.COPY && doodle instanceof DoodleView) {
            path.mCopyLocation = DoodlePen.COPY.getCopyLocation().copy();
        }
        return path;
    }

    public static DoodlePath toPath(IDoodle doodle, Path p) {
        DoodlePath path = new DoodlePath(doodle);
        path.setPen(doodle.getPen().copy());
        path.setShape(doodle.getShape().copy());
        path.setSize(doodle.getSize());
        path.setColor(doodle.getColor().copy());
        path.mPath = p;
        path.mCopyLocation = doodle instanceof DoodleView ? DoodlePen.COPY.getCopyLocation().copy() : null;
        return path;
    }

    @Override
    protected void doDraw(Canvas canvas) {
        this.mPaint.reset();
        this.mPaint.setStrokeWidth(this.getSize());
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setAntiAlias(true);
        this.getPen().config(this, this.mPaint);
        this.getColor().config(this, this.mPaint);
        this.getShape().draw(canvas, this, this.mPaint);
    }
}

