/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleItemBase;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.IDoodleListener;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleItem;
import cn.hzw.doodle.core.IDoodlePen;
import cn.hzw.doodle.core.IDoodleShape;
import cn.hzw.doodle.core.IDoodleTouchDetector;
import cn.hzw.doodle.util.DrawUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class DoodleView
extends FrameLayout
implements IDoodle {
    public static final float MAX_SCALE = 4.0f;
    public static final float MIN_SCALE = 0.25f;
    public static final int DEFAULT_SIZE = 6;
    public static final int ERROR_INIT = -1;
    public static final int ERROR_SAVE = -2;
    private IDoodleListener mDoodleListener;
    private Bitmap mBitmap;
    private Bitmap mDoodleBitmap;
    private Canvas mBitmapCanvas;
    private float mCenterScale;
    private int mCenterHeight;
    private int mCenterWidth;
    private float mCentreTranX;
    private float mCentreTranY;
    private float mRotateScale = 1.0f;
    private float mRotateTranX;
    private float mRotateTranY;
    private float mScale = 1.0f;
    private float mTransX = 0.0f;
    private float mTransY = 0.0f;
    private float mMinScale = 0.25f;
    private float mMaxScale = 4.0f;
    private Paint mPaint;
    private float mSize;
    private IDoodleColor mColor;
    private boolean isJustDrawOriginal;
    private boolean mIsDrawableOutside = false;
    private boolean mReady = false;
    private CopyOnWriteArrayList<IDoodleItem> mItemStack = new CopyOnWriteArrayList();
    private IDoodlePen mPen;
    private IDoodleShape mShape;
    private float mTouchX;
    private float mTouchY;
    private boolean mEnableZoomer = false;
    private float mLastZoomerY;
    private float mZoomerRadius;
    private Path mZoomerPath;
    private float mZoomerScale = 0.0f;
    private Paint mZooomerPaint;
    private int mZoomerHorizonX;
    private float mDoodleSizeUnit = 1.0f;
    private int mDoodleRotateDegree = 0;
    private IDoodleTouchDetector mDefaultTouchDetector;
    private Map<IDoodlePen, IDoodleTouchDetector> mTouchDetectorMap = new HashMap<IDoodlePen, IDoodleTouchDetector>();
    private DoodleViewInner mInner;
    private RectF mDoodleBound = new RectF();
    private PointF mTempPoint = new PointF();
    private Matrix mTouchEventMatrix = new Matrix();
    private View.OnTouchListener mOnTouchListener;

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener) {
        this(context, bitmap, listener, null);
    }

    public DoodleView(Context context, Bitmap bitmap, IDoodleListener listener, IDoodleTouchDetector defaultDetector) {
        super(context);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mBitmap = bitmap;
        this.mDoodleListener = listener;
        if (this.mDoodleListener == null) {
            throw new RuntimeException("IDoodleListener is null!!!");
        }
        if (this.mBitmap == null) {
            throw new RuntimeException("Bitmap is null!!!");
        }
        this.mScale = 1.0f;
        this.mColor = new DoodleColor(-65536);
        this.mPaint = new Paint();
        this.mPaint.setStrokeWidth(this.mSize);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPen = DoodlePen.BRUSH;
        this.mShape = DoodleShape.HAND_WRITE;
        this.mZooomerPaint = new Paint();
        this.mZooomerPaint.setColor(-1426063361);
        this.mZooomerPaint.setStyle(Paint.Style.STROKE);
        this.mZooomerPaint.setAntiAlias(true);
        this.mZooomerPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mZooomerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mZooomerPaint.setStrokeWidth((float)Util.dp2px((Context)this.getContext(), (float)10.0f));
        this.mDefaultTouchDetector = defaultDetector;
        this.mInner = new DoodleViewInner(context);
        this.addView(this.mInner);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initCanvas();
        this.initDoodleBitmap();
        if (!this.mReady) {
            this.mDoodleListener.onReady(this);
            this.mReady = true;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.mOnTouchListener != null && this.mOnTouchListener.onTouch((View)this, event)) {
            return true;
        }
        this.mTouchX = event.getX();
        this.mTouchY = event.getY();
        MotionEvent transformedEvent = MotionEvent.obtain((MotionEvent)event);
        this.mTouchEventMatrix.reset();
        this.mTouchEventMatrix.setRotate((float)(-this.mDoodleRotateDegree), (float)(this.mInner.getWidth() / 2), (float)(this.mInner.getHeight() / 2));
        transformedEvent.transform(this.mTouchEventMatrix);
        boolean handled = this.mInner.dispatchTouchEvent(transformedEvent);
        transformedEvent.recycle();
        return handled;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mOnTouchListener = l;
        super.setOnTouchListener(l);
    }

    private void initDoodleBitmap() {
        float nh;
        int w = this.mBitmap.getWidth();
        int h = this.mBitmap.getHeight();
        float nw = (float)w * 1.0f / (float)this.getWidth();
        if (nw > (nh = (float)h * 1.0f / (float)this.getHeight())) {
            this.mCenterScale = 1.0f / nw;
            this.mCenterWidth = this.getWidth();
            this.mCenterHeight = (int)((float)h * this.mCenterScale);
        } else {
            this.mCenterScale = 1.0f / nh;
            this.mCenterWidth = (int)((float)w * this.mCenterScale);
            this.mCenterHeight = this.getHeight();
        }
        this.mCentreTranX = (float)(this.getWidth() - this.mCenterWidth) / 2.0f;
        this.mCentreTranY = (float)(this.getHeight() - this.mCenterHeight) / 2.0f;
        this.mZoomerRadius = Math.min(this.getWidth(), this.getHeight()) / 4;
        this.mZoomerPath = new Path();
        this.mZoomerPath.addCircle(this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, Path.Direction.CCW);
        this.mZoomerHorizonX = (int)((float)(Math.min(this.getWidth(), this.getHeight()) / 2) - this.mZoomerRadius);
        this.mDoodleSizeUnit = (float)Util.dp2px((Context)this.getContext(), (float)1.0f) / this.mCenterScale;
        if (!this.mReady) {
            this.mSize = 6.0f * this.mDoodleSizeUnit;
        }
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mScale = 1.0f;
        this.refresh();
    }

    public RectF getDoodleBound() {
        float width = (float)this.mCenterWidth * this.mRotateScale * this.mScale;
        float height = (float)this.mCenterHeight * this.mRotateScale * this.mScale;
        if (this.mDoodleRotateDegree % 90 == 0) {
            if (this.mDoodleRotateDegree == 0) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(0.0f);
            } else if (this.mDoodleRotateDegree == 90) {
                this.mTempPoint.x = this.toTouchX(0.0f);
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
                float t = width;
                width = height;
                height = t;
            } else if (this.mDoodleRotateDegree == 180) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(this.mBitmap.getHeight());
            } else if (this.mDoodleRotateDegree == 270) {
                this.mTempPoint.x = this.toTouchX(this.mBitmap.getWidth());
                this.mTempPoint.y = this.toTouchY(0.0f);
                float t = width;
                width = height;
                height = t;
            }
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, this.mTempPoint.x, this.mTempPoint.y, this.mInner.getWidth() / 2, this.mInner.getHeight() / 2);
            this.mDoodleBound.set(this.mTempPoint.x, this.mTempPoint.y, this.mTempPoint.x + width, this.mTempPoint.y + height);
        } else {
            float ltX = this.toTouchX(0.0f);
            float ltY = this.toTouchY(0.0f);
            float rbX = this.toTouchX(this.mBitmap.getWidth());
            float rbY = this.toTouchY(this.mBitmap.getHeight());
            float lbX = this.toTouchX(0.0f);
            float lbY = this.toTouchY(this.mBitmap.getHeight());
            float rtX = this.toTouchX(this.mBitmap.getWidth());
            float rtY = this.toTouchY(0.0f);
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, ltX, ltY, this.mInner.getWidth() / 2, this.mInner.getHeight() / 2);
            ltX = this.mTempPoint.x;
            ltY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rbX, rbY, this.mInner.getWidth() / 2, this.mInner.getHeight() / 2);
            rbX = this.mTempPoint.x;
            rbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, lbX, lbY, this.mInner.getWidth() / 2, this.mInner.getHeight() / 2);
            lbX = this.mTempPoint.x;
            lbY = this.mTempPoint.y;
            DrawUtil.rotatePoint(this.mTempPoint, this.mDoodleRotateDegree, rtX, rtY, this.mInner.getWidth() / 2, this.mInner.getHeight() / 2);
            rtX = this.mTempPoint.x;
            rtY = this.mTempPoint.y;
            this.mDoodleBound.left = Math.min(Math.min(ltX, rbX), Math.min(lbX, rtX));
            this.mDoodleBound.top = Math.min(Math.min(ltY, rbY), Math.min(lbY, rtY));
            this.mDoodleBound.right = Math.max(Math.max(ltX, rbX), Math.max(lbX, rtX));
            this.mDoodleBound.bottom = Math.max(Math.max(ltY, rbY), Math.max(lbY, rtY));
        }
        return this.mDoodleBound;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mBitmap.isRecycled() || this.mDoodleBitmap.isRecycled()) {
            return;
        }
        canvas.save();
        canvas.rotate((float)this.mDoodleRotateDegree, (float)(this.mInner.getWidth() / 2), (float)(this.mInner.getHeight() / 2));
        this.mInner.draw(canvas);
        canvas.restore();
        if (this.mEnableZoomer && this.mZoomerScale > 0.0f) {
            canvas.save();
            if (this.mTouchY <= this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = (float)this.getHeight() - this.mZoomerRadius * 2.0f;
            } else if (this.mTouchY >= (float)this.getHeight() - this.mZoomerRadius * 2.0f) {
                this.mLastZoomerY = 0.0f;
            }
            canvas.translate((float)this.mZoomerHorizonX, this.mLastZoomerY);
            canvas.clipPath(this.mZoomerPath);
            canvas.drawColor(-16777216);
            canvas.save();
            float scale = this.mZoomerScale / this.mScale;
            canvas.scale(scale, scale);
            canvas.translate(-this.mTouchX + this.mZoomerRadius / scale, -this.mTouchY + this.mZoomerRadius / scale);
            canvas.rotate((float)this.mDoodleRotateDegree, (float)(this.mInner.getWidth() / 2), (float)(this.mInner.getHeight() / 2));
            this.mInner.draw(canvas);
            canvas.restore();
            DrawUtil.drawCircle(canvas, this.mZoomerRadius, this.mZoomerRadius, this.mZoomerRadius, this.mZooomerPaint);
            canvas.restore();
        }
    }

    private void doDraw(Canvas canvas) {
        float left = this.getAllTranX();
        float top = this.getAllTranY();
        canvas.translate(left, top);
        float scale = this.getAllScale();
        canvas.scale(scale, scale);
        if (this.isJustDrawOriginal) {
            canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
            return;
        }
        canvas.drawBitmap(this.mDoodleBitmap, 0.0f, 0.0f, null);
        boolean canvasClipped = false;
        canvas.save();
        if (!this.mIsDrawableOutside) {
            canvasClipped = true;
            canvas.clipRect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
        }
        for (IDoodleItem item : this.mItemStack) {
            if (item instanceof DoodleItemBase) {
                if (((DoodleItemBase)item).isDrawOptimize()) continue;
                if (!item.isNeedClipOutside()) {
                    if (canvasClipped) {
                        canvas.restore();
                    }
                    ((DoodleItemBase)item).drawBefore(canvas);
                    item.draw(canvas);
                    ((DoodleItemBase)item).drawAfter(canvas);
                    if (!canvasClipped) continue;
                    canvas.save();
                    canvas.clipRect(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
                    continue;
                }
                ((DoodleItemBase)item).drawBefore(canvas);
                item.draw(canvas);
                ((DoodleItemBase)item).drawAfter(canvas);
                continue;
            }
            item.draw(canvas);
        }
        canvas.restore();
        this.mPen.drawHelpers(canvas, this);
    }

    public float getAllScale() {
        return this.mCenterScale * this.mRotateScale * this.mScale;
    }

    public float getAllTranX() {
        return this.mCentreTranX + this.mRotateTranX + this.mTransX;
    }

    public float getAllTranY() {
        return this.mCentreTranY + this.mRotateTranY + this.mTransY;
    }

    public final float toX(float touchX) {
        return (touchX - this.getAllTranX()) / this.getAllScale();
    }

    public final float toY(float touchY) {
        return (touchY - this.getAllTranY()) / this.getAllScale();
    }

    public final float toTouchX(float x) {
        return x * this.getAllScale() + this.getAllTranX();
    }

    public final float toTouchY(float y) {
        return y * this.getAllScale() + this.getAllTranY();
    }

    public final float toTransX(float touchX, float doodleX) {
        return -doodleX * this.getAllScale() + touchX - this.mCentreTranX - this.mRotateTranX;
    }

    public final float toTransY(float touchY, float doodleY) {
        return -doodleY * this.getAllScale() + touchY - this.mCentreTranY - this.mRotateTranY;
    }

    private void initCanvas() {
        if (this.mDoodleBitmap != null) {
            this.mDoodleBitmap.recycle();
        }
        this.mDoodleBitmap = this.mBitmap.copy(Bitmap.Config.RGB_565, true);
        this.mBitmapCanvas = new Canvas(this.mDoodleBitmap);
    }

    public void bindTouchDetector(IDoodlePen pen, IDoodleTouchDetector detector) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.put(pen, detector);
    }

    public IDoodleTouchDetector getDefaultTouchDetector(IDoodlePen pen) {
        return this.mTouchDetectorMap.get(pen);
    }

    public void removeTouchDetector(IDoodlePen pen) {
        if (pen == null) {
            return;
        }
        this.mTouchDetectorMap.remove(pen);
    }

    public void setDefaultTouchDetector(IDoodleTouchDetector touchGestureDetector) {
        this.mDefaultTouchDetector = touchGestureDetector;
    }

    public IDoodleTouchDetector getDefaultTouchDetector() {
        return this.mDefaultTouchDetector;
    }

    public void refreshForce() {
        this.initCanvas();
        for (IDoodleItem item : this.mItemStack) {
            if (item instanceof DoodleItemBase) {
                if (!((DoodleItemBase)item).isDrawOptimize()) continue;
                item.draw(this.mBitmapCanvas);
                continue;
            }
            item.draw(this.mBitmapCanvas);
        }
        this.refresh();
    }

    public void refresh(IDoodleItem item) {
        if (!this.mItemStack.contains(item)) {
            throw new RuntimeException("doodle doesn't include the item");
        }
        if (((DoodleItemBase)item).isDrawOptimize()) {
            item.draw(this.mBitmapCanvas);
        }
        this.refresh();
    }

    @Override
    public void refresh() {
        this.invalidate();
    }

    @Override
    public int getDoodleRotation() {
        return this.mDoodleRotateDegree;
    }

    @Override
    public void setDoodleRotation(int degree) {
        this.mDoodleRotateDegree = degree;
        this.mDoodleRotateDegree %= 360;
        this.mInner.setPivotX(this.mInner.getWidth() / 2);
        this.mInner.setPivotY(this.mInner.getHeight() / 2);
        this.mInner.setRotation(this.mDoodleRotateDegree);
        RectF rectF = this.getDoodleBound();
        int w = (int)(rectF.width() / this.getAllScale());
        int h = (int)(rectF.height() / this.getAllScale());
        float nw = (float)w * 1.0f / (float)this.getWidth();
        float nh = (float)h * 1.0f / (float)this.getHeight();
        float scale = nw > nh ? 1.0f / nw : 1.0f / nh;
        int pivotX = this.mBitmap.getWidth() / 2;
        int pivotY = this.mBitmap.getHeight() / 2;
        this.mTransY = 0.0f;
        this.mTransX = 0.0f;
        this.mRotateTranY = 0.0f;
        this.mRotateTranX = 0.0f;
        this.mScale = 1.0f;
        this.mRotateScale = 1.0f;
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mRotateScale = scale / this.mCenterScale;
        float tx = this.toTransX(touchX, pivotX);
        float ty = this.toTransY(touchY, pivotY);
        this.mRotateTranX = tx;
        this.mRotateTranY = ty;
        this.refresh();
    }

    @Override
    public void save() {
        for (IDoodleItem item : this.mItemStack) {
            if (!(item instanceof DoodleItemBase) || ((DoodleItemBase)item).isDrawOptimize()) continue;
            item.draw(this.mBitmapCanvas);
        }
        this.mDoodleBitmap = ImageUtils.rotate((Bitmap)this.mDoodleBitmap, (int)this.mDoodleRotateDegree, (boolean)true);
        this.mDoodleListener.onSaved(this, this.mDoodleBitmap, new Runnable(){

            @Override
            public void run() {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    DoodleView.this.refreshForce();
                } else {
                    DoodleView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            DoodleView.this.refreshForce();
                        }
                    });
                }
            }
        });
    }

    @Override
    public void clear() {
        int size = this.mItemStack.size();
        this.mItemStack.clear();
        this.refreshForce();
    }

    @Override
    public boolean undo(int step) {
        if (this.mItemStack.size() > 0) {
            step = Math.min(this.mItemStack.size(), step);
            IDoodleItem item = this.mItemStack.get(this.mItemStack.size() - step);
            this.removeItem(item);
            return true;
        }
        return false;
    }

    @Override
    public boolean undo() {
        return this.undo(1);
    }

    @Override
    public void setShowOriginal(boolean justDrawOriginal) {
        this.isJustDrawOriginal = justDrawOriginal;
        this.refresh();
    }

    @Override
    public boolean isShowOriginal() {
        return this.isJustDrawOriginal;
    }

    @Override
    public void setColor(IDoodleColor color) {
        this.mColor = color;
        this.refresh();
    }

    @Override
    public IDoodleColor getColor() {
        return this.mColor;
    }

    @Override
    public void setDoodleScale(float scale, float pivotX, float pivotY) {
        if (scale < this.mMinScale) {
            scale = this.mMinScale;
        } else if (scale > this.mMaxScale) {
            scale = this.mMaxScale;
        }
        float touchX = this.toTouchX(pivotX);
        float touchY = this.toTouchY(pivotY);
        this.mScale = scale;
        this.mTransX = this.toTransX(touchX, pivotX);
        this.mTransY = this.toTransY(touchY, pivotY);
        this.refresh();
    }

    @Override
    public float getDoodleScale() {
        return this.mScale;
    }

    @Override
    public void setPen(IDoodlePen pen) {
        if (pen == null) {
            throw new RuntimeException("Pen can't be null");
        }
        IDoodlePen old = this.mPen;
        this.mPen = pen;
        this.refresh();
    }

    @Override
    public IDoodlePen getPen() {
        return this.mPen;
    }

    @Override
    public void setShape(IDoodleShape shape) {
        if (shape == null) {
            throw new RuntimeException("Shape can't be null");
        }
        this.mShape = shape;
        this.refresh();
    }

    @Override
    public IDoodleShape getShape() {
        return this.mShape;
    }

    @Override
    public void setDoodleTranslation(float transX, float transY) {
        this.mTransX = transX;
        this.mTransY = transY;
        this.refresh();
    }

    @Override
    public void setDoodleTranslationX(float transX) {
        this.mTransX = transX;
        this.refresh();
    }

    @Override
    public float getDoodleTranslationX() {
        return this.mTransX;
    }

    @Override
    public void setDoodleTranslationY(float transY) {
        this.mTransY = transY;
        this.refresh();
    }

    @Override
    public float getDoodleTranslationY() {
        return this.mTransY;
    }

    @Override
    public void setSize(float paintSize) {
        this.mSize = paintSize;
        this.refresh();
    }

    @Override
    public float getSize() {
        return this.mSize;
    }

    @Override
    public void setIsDrawableOutside(boolean isDrawableOutside) {
        this.mIsDrawableOutside = isDrawableOutside;
    }

    @Override
    public boolean isDrawableOutside() {
        return this.mIsDrawableOutside;
    }

    @Override
    public void setZoomerScale(float scale) {
        this.mZoomerScale = scale;
        this.refresh();
    }

    @Override
    public float getZoomerScale() {
        return this.mZoomerScale;
    }

    public void enableZoomer(boolean enable) {
        this.mEnableZoomer = enable;
    }

    public boolean isEnableZoomer() {
        return this.mEnableZoomer;
    }

    @Override
    public void topItem(IDoodleItem item) {
        this.mItemStack.remove(item);
        this.mItemStack.add(item);
        this.refresh();
    }

    @Override
    public void bottomItem(IDoodleItem item) {
        this.mItemStack.remove(item);
        this.mItemStack.add(0, item);
        this.refresh();
    }

    @Override
    public void setDoodleMinScale(float minScale) {
        this.mMinScale = minScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMinScale() {
        return this.mMinScale;
    }

    @Override
    public void setDoodleMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
        this.setDoodleScale(this.mScale, 0.0f, 0.0f);
    }

    @Override
    public float getDoodleMaxScale() {
        return this.mMaxScale;
    }

    @Override
    public float getUnitSize() {
        return this.mDoodleSizeUnit;
    }

    @Override
    public void addItem(IDoodleItem doodleItem) {
        if (this != doodleItem.getDoodle()) {
            throw new RuntimeException("the object Doodle is illegal");
        }
        if (this.mItemStack.contains(doodleItem)) {
            throw new RuntimeException("the item has been added");
        }
        this.mItemStack.add(doodleItem);
        doodleItem.onAdd();
        if (((DoodleItemBase)doodleItem).isDrawOptimize()) {
            doodleItem.draw(this.mBitmapCanvas);
        }
        this.refresh();
    }

    @Override
    public void removeItem(IDoodleItem doodleItem) {
        if (!this.mItemStack.remove(doodleItem)) {
            return;
        }
        doodleItem.onRemove();
        if (doodleItem instanceof DoodleItemBase && ((DoodleItemBase)doodleItem).isDrawOptimize()) {
            this.refreshForce();
        }
        this.refresh();
    }

    @Override
    public List<IDoodleItem> getAllItem() {
        return this.mItemStack;
    }

    @Override
    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    @Override
    public Bitmap getDoodleBitmap() {
        return this.mDoodleBitmap;
    }

    public int getCenterWidth() {
        return this.mCenterWidth;
    }

    public int getCenterHeight() {
        return this.mCenterHeight;
    }

    public float getCenterScale() {
        return this.mCenterScale;
    }

    public float getCentreTranX() {
        return this.mCentreTranX;
    }

    public float getCentreTranY() {
        return this.mCentreTranY;
    }

    public float getRotateScale() {
        return this.mRotateScale;
    }

    public float getRotateTranX() {
        return this.mRotateTranX;
    }

    public float getRotateTranY() {
        return this.mRotateTranY;
    }

    private class DoodleViewInner
    extends View {
        public DoodleViewInner(Context context) {
            super(context);
            if (Build.VERSION.SDK_INT >= 11) {
                this.setLayerType(1, null);
            }
        }

        public boolean onTouchEvent(MotionEvent event) {
            IDoodleTouchDetector detector = (IDoodleTouchDetector)DoodleView.this.mTouchDetectorMap.get(DoodleView.this.mPen);
            if (detector != null) {
                return detector.onTouchEvent(event);
            }
            if (DoodleView.this.mDefaultTouchDetector != null) {
                return DoodleView.this.mDefaultTouchDetector.onTouchEvent(event);
            }
            return super.onTouchEvent(event);
        }

        protected void onDraw(Canvas canvas) {
            canvas.save();
            DoodleView.this.doDraw(canvas);
            canvas.restore();
        }
    }
}

