/*
 * Decompiled with CFR 0.152.
 */
package cn.hzw.doodle;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import cn.forward.androids.TouchGestureDetector;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.LogUtil;
import cn.forward.androids.utils.StatusBarUtil;
import cn.forward.androids.utils.Util;
import cn.hzw.doodle.DoodleBitmap;
import cn.hzw.doodle.DoodleColor;
import cn.hzw.doodle.DoodleOnTouchGestureListener;
import cn.hzw.doodle.DoodleParams;
import cn.hzw.doodle.DoodlePen;
import cn.hzw.doodle.DoodleShape;
import cn.hzw.doodle.DoodleText;
import cn.hzw.doodle.DoodleTouchDetector;
import cn.hzw.doodle.DoodleView;
import cn.hzw.doodle.IDoodleListener;
import cn.hzw.doodle.R;
import cn.hzw.doodle.core.IDoodle;
import cn.hzw.doodle.core.IDoodleColor;
import cn.hzw.doodle.core.IDoodleSelectableItem;
import cn.hzw.doodle.dialog.ColorPickerDialog;
import cn.hzw.doodle.dialog.DialogController;
import cn.hzw.doodle.imagepicker.ImageSelectorView;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class DoodleActivity
extends Activity {
    public static final String TAG = "Doodle";
    public static final int DEFAULT_COPY_SIZE = 20;
    public static final int DEFAULT_TEXT_SIZE = 17;
    public static final int DEFAULT_BITMAP_SIZE = 80;
    public static final int RESULT_ERROR = -111;
    public static final String KEY_PARAMS = "key_doodle_params";
    public static final String KEY_IMAGE_PATH = "key_image_path";
    private String mImagePath;
    private FrameLayout mFrameLayout;
    private IDoodle mDoodle;
    private DoodleView mDoodleView;
    private View.OnClickListener mOnClickListener;
    private SeekBar mPaintSizeBar;
    private TextView mPaintSizeView;
    private View mBtnColor;
    private View mBtnColorContainer;
    private View mBtnHidePanel;
    private View mSettingsPanel;
    private View mShapeModeContainer;
    private View mSelectedTextEditContainer;
    private View mColorContainer;
    private AlphaAnimation mViewShowAnimation;
    private AlphaAnimation mViewHideAnimation;
    private DoodleParams mDoodleParams;
    private Runnable mHideDelayRunnable;
    private Runnable mShowDelayRunnable;
    private DoodleOnTouchGestureListener mTouchGestureListener;

    public static void startActivityForResult(Activity activity, DoodleParams params, int requestCode) {
        Intent intent = new Intent((Context)activity, DoodleActivity.class);
        intent.putExtra(KEY_PARAMS, (Parcelable)params);
        activity.startActivityForResult(intent, requestCode);
    }

    @Deprecated
    public static void startActivityForResult(Activity activity, String imagePath, String savePath, boolean isDir, int requestCode) {
        DoodleParams params = new DoodleParams();
        params.mImagePath = imagePath;
        params.mSavePath = savePath;
        params.mSavePathIsDir = isDir;
        DoodleActivity.startActivityForResult(activity, params, requestCode);
    }

    @Deprecated
    public static void startActivityForResult(Activity activity, String imagePath, int requestCode) {
        DoodleParams params = new DoodleParams();
        params.mImagePath = imagePath;
        DoodleActivity.startActivityForResult(activity, params, requestCode);
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_PARAMS, (Parcelable)this.mDoodleParams);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState, PersistableBundle persistentState) {
        super.onRestoreInstanceState(savedInstanceState, persistentState);
        this.mDoodleParams = (DoodleParams)savedInstanceState.getParcelable(KEY_PARAMS);
    }

    public void onCreate(Bundle savedInstanceState) {
        Bitmap bitmap;
        super.onCreate(savedInstanceState);
        StatusBarUtil.setStatusBarTranslucent((Activity)this, (boolean)true, (boolean)false);
        if (this.mDoodleParams == null) {
            this.mDoodleParams = (DoodleParams)this.getIntent().getExtras().getParcelable(KEY_PARAMS);
        }
        if (this.mDoodleParams == null) {
            LogUtil.e((String)"TAG", (String)"mDoodleParams is null!");
            this.finish();
            return;
        }
        this.mImagePath = this.mDoodleParams.mImagePath;
        if (this.mImagePath == null) {
            LogUtil.e((String)"TAG", (String)"mImagePath is null!");
            this.finish();
            return;
        }
        LogUtil.d((String)"TAG", (String)this.mImagePath);
        if (this.mDoodleParams.mIsFullScreen) {
            this.getWindow().setFlags(1024, 1024);
        }
        if ((bitmap = ImageUtils.createBitmapFromPath((String)this.mImagePath, (Context)this)) == null) {
            LogUtil.e((String)"TAG", (String)"bitmap is null!");
            this.finish();
            return;
        }
        this.requestWindowFeature(1);
        this.setContentView(R.layout.doodle_layout);
        this.mFrameLayout = (FrameLayout)this.findViewById(R.id.doodle_container);
        this.mDoodleView = new DoodleView((Context)this, bitmap, new IDoodleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaved(IDoodle doodle, Bitmap bitmap, Runnable callback) {
                File doodleFile = null;
                File file = null;
                String savePath = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mSavePath;
                boolean isDir = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mSavePathIsDir;
                if (TextUtils.isEmpty((CharSequence)savePath)) {
                    File dcimFile = new File(Environment.getExternalStorageDirectory(), "DCIM");
                    doodleFile = new File(dcimFile, DoodleActivity.TAG);
                    file = new File(doodleFile, System.currentTimeMillis() + ".jpg");
                } else if (isDir) {
                    doodleFile = new File(savePath);
                    file = new File(doodleFile, System.currentTimeMillis() + ".jpg");
                } else {
                    file = new File(savePath);
                    doodleFile = file.getParentFile();
                }
                doodleFile.mkdirs();
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(file);
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 95, (OutputStream)outputStream);
                    ImageUtils.addImage((ContentResolver)DoodleActivity.this.getContentResolver(), (String)file.getAbsolutePath());
                    Intent intent = new Intent();
                    intent.putExtra(DoodleActivity.KEY_IMAGE_PATH, file.getAbsolutePath());
                    DoodleActivity.this.setResult(-1, intent);
                    DoodleActivity.this.finish();
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        this.onError(-2, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(outputStream);
                        throw throwable;
                    }
                    Util.closeQuietly((Closeable)outputStream);
                }
                Util.closeQuietly((Closeable)outputStream);
            }

            public void onError(int i, String msg) {
                DoodleActivity.this.setResult(-111);
                DoodleActivity.this.finish();
            }

            @Override
            public void onReady(IDoodle doodle) {
                float size;
                float f = size = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintUnitSize > 0.0f ? ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintUnitSize * DoodleActivity.this.mDoodle.getUnitSize() : 0.0f;
                if (size <= 0.0f) {
                    size = ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintPixelSize > 0.0f ? ((DoodleActivity)DoodleActivity.this).mDoodleParams.mPaintPixelSize : DoodleActivity.this.mDoodle.getSize();
                }
                DoodleActivity.this.mDoodle.setSize(size);
                DoodleActivity.this.mPaintSizeBar.setProgress((int)(DoodleActivity.this.mDoodle.getSize() + 0.5f));
                DoodleActivity.this.mPaintSizeBar.setMax(Math.min(DoodleActivity.this.mDoodleView.getWidth(), DoodleActivity.this.mDoodleView.getHeight()));
                DoodleActivity.this.mPaintSizeView.setText((CharSequence)("" + DoodleActivity.this.mPaintSizeBar.getProgress()));
                DoodleActivity.this.findViewById(R.id.btn_pen_hand).performClick();
                DoodleActivity.this.findViewById(R.id.btn_hand_write).performClick();
                if (((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale <= 0.0f) {
                    DoodleActivity.this.findViewById(R.id.btn_zoomer).setVisibility(8);
                }
            }
        }, null);
        this.mDoodle = this.mDoodleView;
        this.mTouchGestureListener = new DoodleOnTouchGestureListener(this.mDoodleView, new DoodleOnTouchGestureListener.ISelectionListener(){

            @Override
            public void onSelectedItem(IDoodle doodle, IDoodleSelectableItem selectableItem, boolean selected) {
                if (selected) {
                    DoodleColor color = null;
                    if (selectableItem.getColor() instanceof DoodleColor) {
                        color = (DoodleColor)selectableItem.getColor();
                    }
                    if (color != null) {
                        if (color.getType() == DoodleColor.Type.BITMAP) {
                            DoodleActivity.this.mBtnColor.setBackgroundDrawable((Drawable)new BitmapDrawable(color.getBitmap()));
                        } else {
                            DoodleActivity.this.mBtnColor.setBackgroundColor(color.getColor());
                        }
                    }
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(selectableItem.getSize() + 0.5f));
                    DoodleActivity.this.mSelectedTextEditContainer.setVisibility(0);
                } else {
                    DoodleColor color = null;
                    if (DoodleActivity.this.mDoodle.getColor() instanceof DoodleColor) {
                        color = (DoodleColor)DoodleActivity.this.mDoodle.getColor();
                    }
                    if (color != null) {
                        if (color.getType() == DoodleColor.Type.BITMAP) {
                            DoodleActivity.this.mBtnColor.setBackgroundDrawable((Drawable)new BitmapDrawable(color.getBitmap()));
                        } else {
                            DoodleActivity.this.mBtnColor.setBackgroundColor(color.getColor());
                        }
                    }
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(DoodleActivity.this.mDoodle.getSize() + 0.5f));
                    DoodleActivity.this.mSelectedTextEditContainer.setVisibility(8);
                }
            }

            @Override
            public void onCreateSelectableItem(IDoodle doodle, float x, float y) {
                if (DoodleActivity.this.mDoodle.getPen() == DoodlePen.TEXT) {
                    DoodleActivity.this.createDoodleText(null, x, y);
                } else if (DoodleActivity.this.mDoodle.getPen() == DoodlePen.BITMAP) {
                    DoodleActivity.this.createDoodleBitmap(null, x, y);
                }
            }
        });
        DoodleTouchDetector detector = new DoodleTouchDetector(this.getApplicationContext(), (TouchGestureDetector.IOnTouchGestureListener)this.mTouchGestureListener);
        this.mDoodleView.setDefaultTouchDetector(detector);
        this.mDoodle.setIsDrawableOutside(this.mDoodleParams.mIsDrawableOutside);
        this.mFrameLayout.addView((View)this.mDoodleView, -1, -1);
        this.mOnClickListener = new DoodleOnClickListener();
        this.mDoodle.setDoodleMinScale(this.mDoodleParams.mMinScale);
        this.mDoodle.setDoodleMaxScale(this.mDoodleParams.mMaxScale);
        this.initView();
    }

    private void createDoodleText(final DoodleText doodleText, final float x, final float y) {
        if (this.isFinishing()) {
            return;
        }
        DialogController.showInputTextDialog(this, doodleText == null ? null : doodleText.getText(), new View.OnClickListener(){

            public void onClick(View v) {
                String text = (v.getTag() + "").trim();
                if (TextUtils.isEmpty((CharSequence)text)) {
                    return;
                }
                if (doodleText == null) {
                    DoodleText item = new DoodleText(DoodleActivity.this.mDoodle, text, DoodleActivity.this.mDoodle.getSize(), DoodleActivity.this.mDoodle.getColor().copy(), x, y);
                    DoodleActivity.this.mDoodle.addItem(item);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(item);
                } else {
                    doodleText.setText(text);
                }
                DoodleActivity.this.mDoodle.refresh();
            }
        }, null);
        if (doodleText == null) {
            this.mSettingsPanel.removeCallbacks(this.mHideDelayRunnable);
        }
    }

    private void createDoodleBitmap(final DoodleBitmap doodleBitmap, final float x, final float y) {
        DialogController.showSelectImageDialog(this, new ImageSelectorView.ImageSelectorListener(){

            @Override
            public void onCancel() {
            }

            @Override
            public void onEnter(List<String> pathList) {
                Bitmap bitmap = ImageUtils.createBitmapFromPath((String)pathList.get(0), (int)(DoodleActivity.this.mDoodleView.getWidth() / 4), (int)(DoodleActivity.this.mDoodleView.getHeight() / 4));
                if (doodleBitmap == null) {
                    DoodleBitmap item = new DoodleBitmap(DoodleActivity.this.mDoodle, bitmap, DoodleActivity.this.mDoodle.getSize(), x, y);
                    DoodleActivity.this.mDoodle.addItem(item);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(item);
                } else {
                    doodleBitmap.setBitmap(bitmap);
                }
                DoodleActivity.this.mDoodle.refresh();
            }
        });
    }

    private void initView() {
        this.findViewById(R.id.btn_pen_hand).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_pen_copy).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_pen_eraser).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_pen_text).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_pen_bitmap).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_hand_write).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_arrow).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_line).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_holl_circle).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_fill_circle).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_holl_rect).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_fill_rect).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_clear).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_zoomer).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_undo).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.btn_undo).setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                DoodleActivity.this.findViewById(R.id.btn_clear).performClick();
                return true;
            }
        });
        this.findViewById(R.id.doodle_selectable_edit).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_selectable_remove).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_selectable_top).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_selectable_bottom).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_btn_rotate).setOnClickListener(this.mOnClickListener);
        this.mShapeModeContainer = this.findViewById(R.id.bar_shape_mode);
        this.mSelectedTextEditContainer = this.findViewById(R.id.doodle_selectable_edit_container);
        this.mBtnHidePanel = this.findViewById(R.id.doodle_btn_hide_panel);
        this.mBtnHidePanel.setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_btn_finish).setOnClickListener(this.mOnClickListener);
        this.findViewById(R.id.doodle_btn_back).setOnClickListener(this.mOnClickListener);
        this.mBtnColor = this.findViewById(R.id.btn_set_color);
        this.mBtnColorContainer = this.findViewById(R.id.btn_set_color_container);
        this.mBtnColor.setOnClickListener(this.mOnClickListener);
        this.mSettingsPanel = this.findViewById(R.id.doodle_panel);
        this.mColorContainer = this.findViewById(R.id.doodle_color_container);
        DoodleColor color = null;
        if (this.mDoodle.getColor() instanceof DoodleColor) {
            color = (DoodleColor)this.mDoodle.getColor();
        }
        if (color != null) {
            if (color.getType() == DoodleColor.Type.COLOR) {
                this.mBtnColor.setBackgroundColor(color.getColor());
            } else if (color.getType() == DoodleColor.Type.BITMAP) {
                this.mBtnColor.setBackgroundDrawable((Drawable)new BitmapDrawable(color.getBitmap()));
            }
        }
        this.mPaintSizeBar = (SeekBar)this.findViewById(R.id.paint_size);
        this.mPaintSizeView = (TextView)this.findViewById(R.id.paint_size_text);
        this.mPaintSizeBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (progress == 0) {
                    DoodleActivity.this.mPaintSizeBar.setProgress(1);
                    return;
                }
                DoodleActivity.this.mPaintSizeView.setText((CharSequence)("" + progress));
                DoodleActivity.this.mDoodle.setSize(progress);
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null) {
                    DoodleActivity.this.mTouchGestureListener.getSelectedItem().setSize(progress);
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.mDoodleView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (!DoodleActivity.this.mBtnHidePanel.isSelected() && ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay > 0L) {
                    switch (event.getAction() & 0xFF) {
                        case 0: {
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mHideDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mShowDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.postDelayed(DoodleActivity.this.mHideDelayRunnable, ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay);
                            break;
                        }
                        case 1: 
                        case 3: {
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mHideDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mShowDelayRunnable);
                            DoodleActivity.this.mSettingsPanel.postDelayed(DoodleActivity.this.mShowDelayRunnable, ((DoodleActivity)DoodleActivity.this).mDoodleParams.mChangePanelVisibilityDelay);
                        }
                    }
                }
                return false;
            }
        });
        this.findViewById(R.id.doodle_txt_title).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        v.setPressed(true);
                        DoodleActivity.this.mDoodle.setShowOriginal(true);
                        break;
                    }
                    case 1: 
                    case 3: {
                        v.setPressed(false);
                        DoodleActivity.this.mDoodle.setShowOriginal(false);
                    }
                }
                return true;
            }
        });
        this.mViewShowAnimation = new AlphaAnimation(0.0f, 1.0f);
        this.mViewShowAnimation.setDuration(150L);
        this.mViewHideAnimation = new AlphaAnimation(1.0f, 0.0f);
        this.mViewHideAnimation.setDuration(150L);
        this.mHideDelayRunnable = new Runnable(){

            @Override
            public void run() {
                DoodleActivity.this.hideView(DoodleActivity.this.mSettingsPanel);
            }
        };
        this.mShowDelayRunnable = new Runnable(){

            @Override
            public void run() {
                DoodleActivity.this.showView(DoodleActivity.this.mSettingsPanel);
            }
        };
    }

    public void onBackPressed() {
        this.findViewById(R.id.doodle_btn_back).performClick();
    }

    private void showView(View view) {
        if (view.getVisibility() == 0) {
            return;
        }
        view.clearAnimation();
        view.startAnimation((Animation)this.mViewShowAnimation);
        view.setVisibility(0);
    }

    private void hideView(View view) {
        if (view.getVisibility() != 0) {
            return;
        }
        view.clearAnimation();
        view.startAnimation((Animation)this.mViewHideAnimation);
        view.setVisibility(8);
    }

    private class DoodleOnClickListener
    implements View.OnClickListener {
        private View mLastPenView;
        private View mLastShapeView;
        private boolean mDone = false;
        private ValueAnimator mRotateAnimator;

        private DoodleOnClickListener() {
        }

        public void onClick(View v) {
            Drawable colorBg;
            this.mDone = false;
            if (v.getId() == R.id.btn_pen_hand) {
                if (DoodleActivity.this.mDoodle.getPen() != DoodlePen.BRUSH) {
                    DoodleActivity.this.mBtnColorContainer.setVisibility(0);
                    DoodleActivity.this.mShapeModeContainer.setVisibility(0);
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                    DoodleActivity.this.mDoodle.setPen(DoodlePen.BRUSH);
                    colorBg = DoodleActivity.this.mBtnColor.getBackground();
                    if (colorBg instanceof ColorDrawable) {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((ColorDrawable)colorBg).getColor()));
                    } else {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((BitmapDrawable)colorBg).getBitmap()));
                    }
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(6.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_pen_copy) {
                if (DoodleActivity.this.mDoodle.getPen() != DoodlePen.COPY) {
                    DoodleActivity.this.mBtnColorContainer.setVisibility(8);
                    DoodleActivity.this.mShapeModeContainer.setVisibility(0);
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                    DoodleActivity.this.mDoodle.setPen(DoodlePen.COPY);
                    DoodleActivity.this.mDoodle.setColor(new DoodleColor(DoodleActivity.this.mDoodle.getBitmap()));
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(20.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_pen_eraser) {
                if (DoodleActivity.this.mDoodle.getPen() != DoodlePen.ERASER) {
                    DoodleActivity.this.mBtnColorContainer.setVisibility(8);
                    DoodleActivity.this.mShapeModeContainer.setVisibility(0);
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                    DoodleActivity.this.mDoodle.setPen(DoodlePen.ERASER);
                    DoodleActivity.this.mDoodle.setColor(new DoodleColor(DoodleActivity.this.mDoodle.getBitmap()));
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(6.0f * DoodleActivity.this.mDoodle.getUnitSize()));
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_pen_text) {
                if (DoodleActivity.this.mDoodle.getPen() != DoodlePen.TEXT) {
                    DoodleActivity.this.mBtnColorContainer.setVisibility(0);
                    DoodleActivity.this.mShapeModeContainer.setVisibility(8);
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                    DoodleActivity.this.mDoodle.setPen(DoodlePen.TEXT);
                    colorBg = DoodleActivity.this.mBtnColor.getBackground();
                    if (colorBg instanceof ColorDrawable) {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((ColorDrawable)colorBg).getColor()));
                    } else {
                        DoodleActivity.this.mDoodle.setColor(new DoodleColor(((BitmapDrawable)colorBg).getBitmap()));
                    }
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(17.0f * DoodleActivity.this.mDoodle.getUnitSize() + 0.5f));
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_pen_bitmap) {
                if (DoodleActivity.this.mDoodle.getPen() != DoodlePen.BITMAP) {
                    DoodleActivity.this.mBtnColorContainer.setVisibility(8);
                    DoodleActivity.this.mShapeModeContainer.setVisibility(8);
                    DoodleActivity.this.mColorContainer.setVisibility(0);
                    DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                    DoodleActivity.this.mDoodle.setPen(DoodlePen.BITMAP);
                    DoodleActivity.this.mPaintSizeBar.setProgress((int)(80.0f * DoodleActivity.this.mDoodle.getUnitSize() + 0.5f));
                }
                this.mDone = true;
            }
            if (this.mDone) {
                if (this.mLastPenView != null) {
                    this.mLastPenView.setSelected(false);
                }
                v.setSelected(true);
                this.mLastPenView = v;
                return;
            }
            if (v.getId() == R.id.btn_clear) {
                if (DoodleParams.getDialogInterceptor() == null || !DoodleParams.getDialogInterceptor().onShow(DoodleActivity.this, DoodleActivity.this.mDoodle, DoodleParams.DialogType.CLEAR_ALL)) {
                    DialogController.showEnterCancelDialog(DoodleActivity.this, DoodleActivity.this.getString(R.string.doodle_clear_screen), DoodleActivity.this.getString(R.string.doodle_cant_undo_after_clearing), new View.OnClickListener(){

                        public void onClick(View v) {
                            DoodleActivity.this.mDoodle.clear();
                            DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                        }
                    }, null);
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_undo) {
                DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                DoodleActivity.this.mDoodle.undo();
                this.mDone = true;
            } else if (v.getId() == R.id.btn_zoomer) {
                v.setSelected(!v.isSelected());
                if (v.isSelected()) {
                    DoodleActivity.this.mDoodle.setZoomerScale(((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale);
                    Toast.makeText((Context)DoodleActivity.this, (CharSequence)("x" + ((DoodleActivity)DoodleActivity.this).mDoodleParams.mZoomerScale), (int)0).show();
                } else {
                    DoodleActivity.this.mDoodle.setZoomerScale(0.0f);
                }
                this.mDone = true;
            } else if (v.getId() == R.id.btn_set_color) {
                DoodleColor color = null;
                if (DoodleActivity.this.mDoodle.getColor() instanceof DoodleColor) {
                    color = (DoodleColor)DoodleActivity.this.mDoodle.getColor();
                }
                if (!(color == null || DoodleParams.getDialogInterceptor() != null && DoodleParams.getDialogInterceptor().onShow(DoodleActivity.this, DoodleActivity.this.mDoodle, DoodleParams.DialogType.COLOR_PICKER))) {
                    boolean fullScreen = (DoodleActivity.this.getWindow().getAttributes().flags & 0x400) != 0;
                    int themeId = fullScreen ? 0x1030011 : 0x1030010;
                    new ColorPickerDialog((Context)DoodleActivity.this, color.getColor(), "\u753b\u7b14\u989c\u8272", new ColorPickerDialog.OnColorChangedListener(){

                        @Override
                        public void colorChanged(int color) {
                            IDoodleColor c;
                            DoodleActivity.this.mBtnColor.setBackgroundColor(color);
                            DoodleActivity.this.mDoodle.setColor(new DoodleColor(color));
                            if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null && (c = DoodleActivity.this.mTouchGestureListener.getSelectedItem().getColor()) instanceof DoodleColor) {
                                ((DoodleColor)c).setColor(color);
                            }
                        }

                        @Override
                        public void colorChanged(Drawable color) {
                            IDoodleColor c;
                            DoodleActivity.this.mBtnColor.setBackgroundDrawable(color);
                            Bitmap bitmap = ImageUtils.getBitmapFromDrawable((Drawable)color);
                            DoodleActivity.this.mDoodle.setColor(new DoodleColor(bitmap));
                            if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() != null && (c = DoodleActivity.this.mTouchGestureListener.getSelectedItem().getColor()) instanceof DoodleColor) {
                                ((DoodleColor)c).setColor(bitmap);
                            }
                        }
                    }, themeId).show();
                }
                this.mDone = true;
            }
            if (this.mDone) {
                return;
            }
            if (v.getId() == R.id.doodle_btn_hide_panel) {
                DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mHideDelayRunnable);
                DoodleActivity.this.mSettingsPanel.removeCallbacks(DoodleActivity.this.mShowDelayRunnable);
                v.setSelected(!v.isSelected());
                if (!DoodleActivity.this.mBtnHidePanel.isSelected()) {
                    DoodleActivity.this.showView(DoodleActivity.this.mSettingsPanel);
                } else {
                    DoodleActivity.this.hideView(DoodleActivity.this.mSettingsPanel);
                }
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_btn_finish) {
                DoodleActivity.this.mDoodle.save();
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_btn_back) {
                if (DoodleActivity.this.mDoodle.getAllItem() == null || DoodleActivity.this.mDoodle.getAllItem().size() == 0) {
                    DoodleActivity.this.finish();
                    return;
                }
                if (DoodleParams.getDialogInterceptor() == null || !DoodleParams.getDialogInterceptor().onShow(DoodleActivity.this, DoodleActivity.this.mDoodle, DoodleParams.DialogType.SAVE)) {
                    DialogController.showEnterCancelDialog(DoodleActivity.this, DoodleActivity.this.getString(R.string.doodle_saving_picture), null, new View.OnClickListener(){

                        public void onClick(View v) {
                            DoodleActivity.this.mDoodle.save();
                        }
                    }, new View.OnClickListener(){

                        public void onClick(View v) {
                            DoodleActivity.this.finish();
                        }
                    });
                }
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_btn_rotate) {
                if (this.mRotateAnimator == null) {
                    this.mRotateAnimator = new ValueAnimator();
                    this.mRotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            int value = (Integer)animation.getAnimatedValue();
                            DoodleActivity.this.mDoodle.setDoodleRotation(value);
                        }
                    });
                    this.mRotateAnimator.setDuration(250L);
                }
                if (this.mRotateAnimator.isRunning()) {
                    return;
                }
                this.mRotateAnimator.setIntValues(new int[]{DoodleActivity.this.mDoodle.getDoodleRotation(), DoodleActivity.this.mDoodle.getDoodleRotation() + 90});
                this.mRotateAnimator.start();
                this.mDone = true;
            }
            if (this.mDone) {
                return;
            }
            if (v.getId() == R.id.doodle_selectable_edit) {
                if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() instanceof DoodleText) {
                    DoodleActivity.this.createDoodleText((DoodleText)DoodleActivity.this.mTouchGestureListener.getSelectedItem(), -1.0f, -1.0f);
                } else if (DoodleActivity.this.mTouchGestureListener.getSelectedItem() instanceof DoodleBitmap) {
                    DoodleActivity.this.createDoodleBitmap((DoodleBitmap)DoodleActivity.this.mTouchGestureListener.getSelectedItem(), -1.0f, -1.0f);
                }
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_selectable_remove) {
                DoodleActivity.this.mDoodle.removeItem(DoodleActivity.this.mTouchGestureListener.getSelectedItem());
                DoodleActivity.this.mTouchGestureListener.setSelectedItem(null);
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_selectable_top) {
                DoodleActivity.this.mDoodle.topItem(DoodleActivity.this.mTouchGestureListener.getSelectedItem());
                this.mDone = true;
            } else if (v.getId() == R.id.doodle_selectable_bottom) {
                DoodleActivity.this.mDoodle.bottomItem(DoodleActivity.this.mTouchGestureListener.getSelectedItem());
                this.mDone = true;
            }
            if (this.mDone) {
                return;
            }
            if (v.getId() == R.id.btn_hand_write) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.HAND_WRITE);
            } else if (v.getId() == R.id.btn_arrow) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.ARROW);
            } else if (v.getId() == R.id.btn_line) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.LINE);
            } else if (v.getId() == R.id.btn_holl_circle) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.HOLLOW_CIRCLE);
            } else if (v.getId() == R.id.btn_fill_circle) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.FILL_CIRCLE);
            } else if (v.getId() == R.id.btn_holl_rect) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.HOLLOW_RECT);
            } else if (v.getId() == R.id.btn_fill_rect) {
                DoodleActivity.this.mDoodle.setShape(DoodleShape.FILL_RECT);
            }
            if (this.mLastShapeView != null) {
                this.mLastShapeView.setSelected(false);
            }
            v.setSelected(true);
            this.mLastShapeView = v;
        }
    }
}

