/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import cn.forward.androids.R;

public class SelectorAttrs {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;

    public static void obtainsAttrs(Context context, View view, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Selector);
        GradientDrawable gradientDrawable = new GradientDrawable();
        GradientDrawable gradientDrawablePressed = new GradientDrawable();
        if (a.hasValue(R.styleable.Selector_sel_background)) {
            int backgroundBorderPressed;
            int backgroundPressed;
            int backgroundCorners;
            int backgroundBorder;
            int background = a.getColor(R.styleable.Selector_sel_background, -1);
            gradientDrawable.setColor(background);
            gradientDrawablePressed.setColor(background);
            int shape = a.getInt(R.styleable.Selector_sel_background_shape, 0);
            if (shape == 2) {
                gradientDrawable.setShape(2);
                gradientDrawablePressed.setShape(2);
            } else if (shape == 1) {
                gradientDrawable.setShape(1);
                gradientDrawablePressed.setShape(1);
            } else if (shape == 3) {
                gradientDrawable.setShape(3);
                gradientDrawablePressed.setShape(3);
            } else {
                gradientDrawable.setShape(0);
                gradientDrawablePressed.setShape(0);
            }
            int backgroundBorderWidth = a.getDimensionPixelOffset(R.styleable.Selector_sel_background_border_width, -1);
            if (backgroundBorderWidth != -1) {
                gradientDrawable.setStroke(backgroundBorderWidth, background);
                gradientDrawablePressed.setStroke(backgroundBorderWidth, background);
            }
            if ((backgroundBorder = a.getColor(R.styleable.Selector_sel_background_border_color, -1)) != -1) {
                gradientDrawable.setStroke(backgroundBorderWidth, backgroundBorder);
                gradientDrawablePressed.setStroke(backgroundBorderWidth, backgroundBorder);
            }
            if ((backgroundCorners = a.getDimensionPixelOffset(R.styleable.Selector_sel_background_corners, -1)) != -1) {
                int radius = backgroundCorners;
                gradientDrawable.setCornerRadius((float)backgroundCorners);
                gradientDrawablePressed.setCornerRadius((float)backgroundCorners);
                int topLeftRadius = a.getDimensionPixelSize(R.styleable.Selector_sel_background_corner_topLeft, radius);
                int topRightRadius = a.getDimensionPixelSize(R.styleable.Selector_sel_background_corner_topRight, radius);
                int bottomLeftRadius = a.getDimensionPixelSize(R.styleable.Selector_sel_background_corner_bottomLeft, radius);
                int bottomRightRadius = a.getDimensionPixelSize(R.styleable.Selector_sel_background_corner_bottomRight, radius);
                if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
                    gradientDrawable.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
                    gradientDrawablePressed.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
                }
            }
            if ((backgroundPressed = a.getColor(R.styleable.Selector_sel_background_pressed, -1)) != -1) {
                gradientDrawablePressed.setColor(backgroundPressed);
            }
            if ((backgroundBorderPressed = a.getColor(R.styleable.Selector_sel_background_border_pressed, -1)) != -1) {
                gradientDrawablePressed.setStroke(backgroundBorderWidth, backgroundBorderPressed);
            }
            StateListDrawable stateListDrawable = new StateListDrawable();
            stateListDrawable.addState(new int[]{16842910, 16842919}, (Drawable)gradientDrawablePressed);
            stateListDrawable.addState(new int[0], (Drawable)gradientDrawable);
            view.setBackgroundDrawable((Drawable)stateListDrawable);
        }
        a.recycle();
    }
}

