/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.util.AttributeSet;
import android.widget.ImageView;
import cn.forward.androids.R;

public class MaskImageView
extends ImageView {
    public static final int MASK_LEVEL_BACKGROUND = 1;
    public static final int MASK_LEVEL_FOREGROUND = 2;
    private boolean mIsIgnoreAlpha = true;
    private boolean mIsShowMaskOnClick = true;
    private int mShadeColor = 0xFFFFFF;
    private int mMaskLevel = 2;
    ColorMatrix mColorMatrix = new ColorMatrix();
    ColorFilter mColorFilter;

    public MaskImageView(Context context) {
        this(context, null);
    }

    public MaskImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaskImageView);
        this.mIsIgnoreAlpha = a.getBoolean(R.styleable.MaskImageView_miv_is_ignore_alpha, this.mIsIgnoreAlpha);
        this.mIsShowMaskOnClick = a.getBoolean(R.styleable.MaskImageView_miv_is_show_mask_on_click, this.mIsShowMaskOnClick);
        this.mShadeColor = a.getColor(R.styleable.MaskImageView_miv_mask_color, this.mShadeColor);
        this.mMaskLevel = a.getInt(R.styleable.MaskImageView_miv_mask_level, this.mMaskLevel);
        float r = (float)Color.alpha((int)this.mShadeColor) / 255.0f;
        r -= (1.0f - r) * 0.15f;
        float rr = (1.0f - r) * 1.15f;
        this.setColorMatrix(new float[]{rr, 0.0f, 0.0f, 0.0f, (float)Color.red((int)this.mShadeColor) * r, 0.0f, rr, 0.0f, 0.0f, (float)Color.green((int)this.mShadeColor) * r, 0.0f, 0.0f, rr, 0.0f, (float)Color.blue((int)this.mShadeColor) * r, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        a.recycle();
    }

    private void setColorMatrix(float[] matrix) {
        this.mColorMatrix.set(matrix);
        this.mColorFilter = new ColorMatrixColorFilter(this.mColorMatrix);
    }

    private void setDrawableColorFilter(ColorFilter colorFilter) {
        if (this.mMaskLevel == 1) {
            if (this.getBackground() != null) {
                this.getBackground().mutate();
                this.getBackground().setColorFilter(colorFilter);
                this.getBackground().invalidateSelf();
            }
        } else if (this.mMaskLevel == 2 && this.getDrawable() != null) {
            this.getDrawable().mutate();
            this.getDrawable().setColorFilter(colorFilter);
            this.getDrawable().invalidateSelf();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIsIgnoreAlpha) {
            if (this.mIsShowMaskOnClick && this.isPressed()) {
                this.setDrawableColorFilter(this.mColorFilter);
            } else {
                this.setDrawableColorFilter(null);
            }
            super.onDraw(canvas);
        } else {
            this.setDrawableColorFilter(null);
            if (this.mMaskLevel == 1) {
                if (this.mIsShowMaskOnClick && this.isPressed()) {
                    canvas.drawColor(this.mShadeColor);
                }
                super.onDraw(canvas);
            } else {
                super.onDraw(canvas);
                if (this.mIsShowMaskOnClick && this.isPressed()) {
                    canvas.drawColor(this.mShadeColor);
                }
            }
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public boolean isIsIgnoreAlpha() {
        return this.mIsIgnoreAlpha;
    }

    public void setIsIgnoreAlpha(boolean mIsIgnoreAlpha) {
        this.mIsIgnoreAlpha = mIsIgnoreAlpha;
        this.invalidate();
    }

    public boolean isIsShowMaskOnClick() {
        return this.mIsShowMaskOnClick;
    }

    public void setIsShowMaskOnClick(boolean mIsShowMaskOnClick) {
        this.mIsShowMaskOnClick = mIsShowMaskOnClick;
        this.invalidate();
    }

    public int getShadeColor() {
        return this.mShadeColor;
    }

    public void setShadeColor(int mShadeColor) {
        this.mShadeColor = mShadeColor;
        float r = (float)Color.alpha((int)mShadeColor) / 255.0f;
        r -= (1.0f - r) * 0.15f;
        float rr = (1.0f - r) * 1.15f;
        this.setColorMatrix(new float[]{rr, 0.0f, 0.0f, 0.0f, (float)Color.red((int)mShadeColor) * r, 0.0f, rr, 0.0f, 0.0f, (float)Color.green((int)mShadeColor) * r, 0.0f, 0.0f, rr, 0.0f, (float)Color.blue((int)mShadeColor) * r, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        this.invalidate();
    }

    public int getMaskLevel() {
        return this.mMaskLevel;
    }

    public void setMaskLevel(int mMaskLevel) {
        this.mMaskLevel = mMaskLevel;
        this.invalidate();
    }
}

