/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import cn.forward.androids.views.ScrollPickerView;
import java.util.List;

public class BitmapScrollPicker
extends ScrollPickerView<Bitmap> {
    public static final int DRAW_MODE_FULL = 1;
    public static final int DRAW_MODE_CENTER = 2;
    public static final int DRAW_MODE_SPECIFIED_SIZE = 3;
    private int mMeasureWidth;
    private int mMeasureHeight;
    private Rect mRect1 = new Rect();
    private Rect mRect2 = new Rect();
    private Rect mSpecifiedSizeRect = new Rect();
    private int mDrawMode = 2;
    private int mSpecifiedSizeWidth = -1;
    private int mSpecifiedSizeHeight = -1;

    public BitmapScrollPicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BitmapScrollPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mMeasureWidth = this.getMeasuredWidth();
        this.mMeasureHeight = this.getMeasuredHeight();
        this.mRect1.left = 0;
        this.mRect1.top = 0;
        int size = Math.min(this.mMeasureWidth, this.getItemHeight());
        if (this.mDrawMode == 1) {
            this.mRect2.left = 0;
            this.mRect2.right = this.mMeasureWidth;
        } else if (this.mDrawMode == 3) {
            if (this.mSpecifiedSizeWidth == -1) {
                this.mSpecifiedSizeWidth = this.mMeasureWidth;
                this.mSpecifiedSizeHeight = this.mMeasureHeight;
            }
            this.setDrawModeSpecifiedSize(this.mSpecifiedSizeWidth, this.mSpecifiedSizeHeight);
        } else {
            this.mRect2.left = this.mMeasureWidth / 2 - size / 2;
            this.mRect2.right = this.mMeasureWidth / 2 + size / 2;
        }
    }

    @Override
    public void drawItem(Canvas canvas, List<Bitmap> data, int position, int relative, float moveLength, float top) {
        int itemHeight = this.getItemHeight();
        Bitmap bitmap = data.get(position);
        this.mRect1.right = bitmap.getWidth();
        this.mRect1.bottom = bitmap.getHeight();
        int span = 0;
        if (this.mDrawMode == 1) {
            span = 0;
            this.mRect2.top = (int)top + span;
            this.mRect2.bottom = (int)(top + (float)itemHeight - (float)span);
            canvas.drawBitmap(bitmap, this.mRect1, this.mRect2, null);
        } else if (this.mDrawMode == 3) {
            span = (itemHeight - this.mSpecifiedSizeHeight) / 2;
            this.mSpecifiedSizeRect.top = (int)top + span;
            this.mSpecifiedSizeRect.bottom = (int)top + span + this.mSpecifiedSizeHeight;
            canvas.drawBitmap(bitmap, this.mRect1, this.mSpecifiedSizeRect, null);
        } else {
            span = (itemHeight - bitmap.getHeight()) / 2;
            if (span < 0) {
                span = 0;
            }
            this.mRect2.top = (int)top + span;
            this.mRect2.bottom = (int)(top + (float)itemHeight - (float)span);
            canvas.drawBitmap(bitmap, this.mRect1, this.mRect2, null);
        }
    }

    public void setDrawMode(int mode) {
        int size = Math.min(this.mMeasureWidth, this.getItemHeight());
        this.mDrawMode = mode;
        if (this.mDrawMode == 1) {
            this.mRect2.left = 0;
            this.mRect2.right = this.mMeasureWidth;
        } else if (this.mDrawMode != 3) {
            this.mRect2.left = this.mMeasureWidth / 2 - size / 2;
            this.mRect2.right = this.mMeasureWidth / 2 + size / 2;
        }
        this.invalidate();
    }

    public void setDrawModeSpecifiedSize(int width, int height) {
        this.mSpecifiedSizeRect.left = (this.mMeasureWidth - width) / 2;
        this.mSpecifiedSizeRect.right = (this.mMeasureWidth - width) / 2 + width;
        this.mSpecifiedSizeWidth = width;
        this.mSpecifiedSizeHeight = height;
    }

    public int getDrawMode() {
        return this.mDrawMode;
    }
}

