/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.Image;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import cn.forward.androids.Image.AsyncDrawable;
import cn.forward.androids.Image.ImageCache;
import cn.forward.androids.Image.ImageLoader;
import cn.forward.androids.Image.ImageLoaderConfig;
import cn.forward.androids.SimpleAsyncTask;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.utils.LogUtil;
import cn.forward.androids.utils.Util;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;

public class LocalImagerLoader
implements ImageLoader {
    private Context mContext;

    public LocalImagerLoader(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @Override
    public boolean load(View view, String path, ImageLoaderConfig config, ImageLoader.ImageLoaderListener loaderListener) {
        ImageLoadTask task;
        Bitmap bitmap;
        String key;
        if (config == null) {
            throw new RuntimeException("ImageLoaderConfig is null!");
        }
        if (!path.startsWith("/") && !path.startsWith("assets/")) {
            return false;
        }
        int[] size = ImageUtils.optimizeMaxSizeByView(view, config.getMaxWidth(), config.getMaxHeight());
        int width = size[0];
        int height = size[1];
        String string = key = config.isNeedCache() ? config.getCacheKeyGenerator().generateCacheKey(size, path, config) : null;
        if (config.isNeedCache() && (bitmap = config.getImageCache().getBitmapMemoryCache(key)) != null) {
            if (loaderListener != null) {
                loaderListener.onLoadStarted(path, config);
            }
            if (view != null) {
                config.getImageSetter().setImage(view, bitmap);
            }
            if (loaderListener != null) {
                loaderListener.onLoadCompleted(path, config, bitmap);
            }
            return true;
        }
        if (view != null) {
            if (LocalImagerLoader.cancelUselessImageLoadTask(view, path, config) == null) {
                task = new ImageLoadTask(this.mContext, view, path, width, height, config, key, loaderListener);
                config.getImageSetter().setImage(view, new AsyncDrawable(config.getLoadingDrawable(), task));
                task.executePriority(config.getPriority(), new String[0]);
            } else if (loaderListener != null) {
                loaderListener.onLoadFailed(path, config, -1);
            }
        } else {
            task = new ImageLoadTask(this.mContext, null, path, width, height, config, key, loaderListener);
            task.executePriority(config.getPriority(), new String[0]);
        }
        return true;
    }

    @Override
    public boolean load(String path, ImageLoaderConfig config, ImageLoader.ImageLoaderListener loaderListener) {
        return this.load(null, path, config, loaderListener);
    }

    public static Bitmap getBitmapFromDisk(FileDescriptor fileDescriptor, int maxWidth, int maxHeight, ImageCache imageCache, String key, Bitmap.CompressFormat format) {
        Bitmap bitmap = null;
        if (imageCache != null && (bitmap = imageCache.getBitmapDiskCache(key)) != null) {
            return bitmap;
        }
        BitmapFactory.Options options = null;
        try {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            int h = options.outHeight;
            int w = options.outWidth;
            options.inSampleSize = ImageUtils.computeBitmapSimple(w * h, maxWidth * maxHeight * 2);
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inInputShareable = true;
            options.inPurgeable = true;
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        }
        catch (Throwable e) {
            LogUtil.i("get bitmap error");
            return null;
        }
        if (imageCache != null && bitmap != null) {
            imageCache.saveBitmapDiskCache(bitmap, key, format);
        }
        return bitmap;
    }

    private static ImageLoadTask cancelUselessImageLoadTask(View view, String key, ImageLoaderConfig config) {
        ImageLoadTask oldLoadTask = LocalImagerLoader.getLoadTaskFromContainer(view, config.getImageSetter());
        if (oldLoadTask != null) {
            String oldKey = oldLoadTask.getKey();
            if (!TextUtils.isEmpty((CharSequence)oldKey) && oldKey.equals(key)) {
                return oldLoadTask;
            }
            oldLoadTask.cancel(true);
            return null;
        }
        return null;
    }

    private static ImageLoadTask getLoadTaskFromContainer(View view, ImageLoaderConfig.ImageSetter setter) {
        AsyncDrawable asyncDrawable;
        SimpleAsyncTask task;
        Drawable drawable;
        if (view != null && (drawable = setter.getDrawable(view)) instanceof AsyncDrawable && (task = (asyncDrawable = (AsyncDrawable)drawable).getBitmapWorkerTask()) instanceof ImageLoadTask) {
            return (ImageLoadTask)task;
        }
        return null;
    }

    private static class ImageLoadTask
    extends SimpleAsyncTask<String, Object, Bitmap> {
        private static final int PROGRESS_LOAD_STARTED = 0;
        private static final int PROGRESS_LOADING = 1;
        private Context mContext;
        private WeakReference<View> mViewRef;
        private String mPath;
        private int mMaxWidth;
        private int mMaxHeight;
        private ImageLoaderConfig mConfig;
        private String mKey;
        private ImageLoader.ImageLoaderListener mLoaderListener;

        public ImageLoadTask(Context context, View view, String path, int maxWidth, int maxHeight, ImageLoaderConfig config, String key, ImageLoader.ImageLoaderListener loaderListener) {
            this.mContext = context.getApplicationContext();
            this.mViewRef = view == null ? null : new WeakReference<View>(view);
            this.mPath = path;
            this.mMaxWidth = maxWidth;
            this.mMaxHeight = maxHeight;
            this.mConfig = config;
            this.mKey = key;
            this.mLoaderListener = loaderListener;
        }

        private boolean abort() {
            if (this.mViewRef != null) {
                if (this.mViewRef.get() == null || this.isCancelled()) {
                    return true;
                }
                ImageLoadTask oldLoadTask = LocalImagerLoader.getLoadTaskFromContainer((View)this.mViewRef.get(), this.mConfig.getImageSetter());
                if (this != oldLoadTask) {
                    return true;
                }
            } else if (this.isCancelled()) {
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Bitmap doInBackground(String ... params) {
            if (this.abort()) {
                return null;
            }
            try {
                Bitmap bitmap;
                Bitmap bm;
                FileInputStream fileInputStream;
                block14: {
                    this.start();
                    fileInputStream = null;
                    if (this.mPath.startsWith("/")) {
                        fileInputStream = new FileInputStream(this.mPath);
                    } else if (this.mPath.startsWith("assets/")) {
                        AssetFileDescriptor assetFileDescriptor = this.mContext.getAssets().openFd(this.mPath.substring(7, this.mPath.length()));
                        fileInputStream = assetFileDescriptor.createInputStream();
                    }
                    bm = LocalImagerLoader.getBitmapFromDisk(fileInputStream.getFD(), this.mConfig.isLoadOriginal() ? 0 : this.mMaxWidth, this.mConfig.isLoadOriginal() ? 0 : this.mMaxHeight, this.mConfig.isNeedCache() ? this.mConfig.getImageCache() : null, this.mKey, this.mPath.toLowerCase().endsWith(".png") ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG);
                    if (!this.abort()) break block14;
                    Bitmap bitmap2 = null;
                    Util.closeQuietly(fileInputStream);
                    return bitmap2;
                }
                try {
                    if (bm != null) {
                        if (this.mConfig.isAutoRotate()) {
                            bm = ImageUtils.rotateBitmapByExif(bm, this.mPath, true);
                        }
                        if (this.mConfig.isNeedCache()) {
                            this.mConfig.getImageCache().saveBitmapMemoryCache(bm, this.mKey);
                        }
                    }
                    bitmap = bm;
                }
                catch (Throwable e) {
                    try {
                        LogUtil.e("open file failed:" + this.mPath);
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly(fileInputStream);
                        throw throwable;
                    }
                    Util.closeQuietly(fileInputStream);
                    return null;
                }
                Util.closeQuietly(fileInputStream);
                return bitmap;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return null;
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            if (this.abort()) {
                if (this.mLoaderListener != null) {
                    this.mLoaderListener.onLoadFailed(this.mPath, this.mConfig, -2);
                }
                return;
            }
            if (this.mViewRef != null) {
                View view = (View)this.mViewRef.get();
                if (view != null) {
                    if (bitmap != null) {
                        this.mConfig.getImageSetter().setImage(view, bitmap);
                        if (this.mLoaderListener != null) {
                            this.mLoaderListener.onLoadCompleted(this.mPath, this.mConfig, bitmap);
                        }
                    } else {
                        this.mConfig.getImageSetter().setImage(view, this.mConfig.getLoadFailedDrawable());
                        if (this.mLoaderListener != null) {
                            this.mLoaderListener.onLoadFailed(this.mPath, this.mConfig, -3);
                        }
                    }
                } else if (this.mLoaderListener != null) {
                    this.mLoaderListener.onLoadFailed(this.mPath, this.mConfig, -2);
                }
            } else if (bitmap != null) {
                if (this.mLoaderListener != null) {
                    this.mLoaderListener.onLoadCompleted(this.mPath, this.mConfig, bitmap);
                }
            } else if (this.mLoaderListener != null) {
                this.mLoaderListener.onLoadFailed(this.mPath, this.mConfig, -3);
            }
        }

        private void start() {
            this.publishProgress(0);
        }

        public void updateProgress(long total, long current) {
            this.publishProgress(1, total, current);
        }

        @Override
        protected void onProgressUpdate(Object ... values) {
            if (this.mLoaderListener == null) {
                return;
            }
            switch ((Integer)values[0]) {
                case 0: {
                    this.mLoaderListener.onLoadStarted(this.mPath, this.mConfig);
                    break;
                }
                case 1: {
                    if (values.length != 3) {
                        return;
                    }
                    this.mLoaderListener.onLoading(this.mPath, this.mConfig, (Long)values[1], (Long)values[2]);
                    break;
                }
            }
        }

        public View getView() {
            return (View)this.mViewRef.get();
        }

        public String getPath() {
            return this.mPath;
        }

        public int getMaxWidth() {
            return this.mMaxWidth;
        }

        public int getMaxHeight() {
            return this.mMaxHeight;
        }

        public ImageLoaderConfig getConfig() {
            return this.mConfig;
        }

        public String getKey() {
            return this.mKey;
        }
    }
}

