/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import cn.forward.androids.R;
import cn.forward.androids.utils.ImageUtils;
import cn.forward.androids.views.SelectorAttrs;

public class ShapeImageView
extends ImageView {
    public static int SHAPE_REC = 1;
    public static int SHAPE_CIRCLE = 2;
    public static int SHAPE_OVAL = 3;
    private float mBorderSize = 0.0f;
    private int mBorderColor = -1;
    private int mShape = SHAPE_REC;
    private float mRoundRadius = 0.0f;
    private float mRoundRadiusLeftTop;
    private float mRoundRadiusLeftBottom;
    private float mRoundRadiusRightTop;
    private float mRoundRadiusRightBottom;
    private Paint mBorderPaint = new Paint(1);
    private RectF mViewRect = new RectF();
    private RectF mBorderRect = new RectF();
    private final Matrix mShaderMatrix = new Matrix();
    private Paint mBitmapPaint = new Paint();
    private BitmapShader mBitmapShader;
    private Bitmap mBitmap;
    private Path mPath = new Path();

    public ShapeImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setStrokeWidth(this.mBorderSize);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setAntiAlias(true);
        this.mBitmapPaint.setAntiAlias(true);
        super.setScaleType(ImageView.ScaleType.CENTER_CROP);
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.mBitmap = ImageUtils.getBitmapFromDrawable(this.getDrawable());
        this.setupBitmapShader();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.mBitmap = ImageUtils.getBitmapFromDrawable(drawable);
        this.setupBitmapShader();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType != ImageView.ScaleType.CENTER_CROP) {
            throw new IllegalArgumentException(String.format("ScaleType %s not supported.", scaleType));
        }
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShapeImageView);
        this.mShape = a.getInt(R.styleable.ShapeImageView_siv_shape, this.mShape);
        this.mRoundRadius = a.getDimension(R.styleable.ShapeImageView_siv_round_radius, this.mRoundRadius);
        this.mBorderSize = a.getDimension(R.styleable.ShapeImageView_siv_border_size, this.mBorderSize);
        this.mBorderColor = a.getColor(R.styleable.ShapeImageView_siv_border_color, this.mBorderColor);
        this.mRoundRadiusLeftBottom = a.getDimension(R.styleable.ShapeImageView_siv_round_radius_leftBottom, this.mRoundRadius);
        this.mRoundRadiusLeftTop = a.getDimension(R.styleable.ShapeImageView_siv_round_radius_leftTop, this.mRoundRadius);
        this.mRoundRadiusRightBottom = a.getDimension(R.styleable.ShapeImageView_siv_round_radius_rightBottom, this.mRoundRadius);
        this.mRoundRadiusRightTop = a.getDimension(R.styleable.ShapeImageView_siv_round_radius_rightTop, this.mRoundRadius);
        a.recycle();
        SelectorAttrs.obtainsAttrs(this.getContext(), (View)this, attrs);
    }

    public void onDraw(Canvas canvas) {
        if (this.mBitmap != null) {
            if (this.mShape == SHAPE_CIRCLE) {
                canvas.drawCircle(this.mViewRect.right / 2.0f, this.mViewRect.bottom / 2.0f, Math.min(this.mViewRect.right, this.mViewRect.bottom) / 2.0f, this.mBitmapPaint);
            } else if (this.mShape == SHAPE_OVAL) {
                canvas.drawOval(this.mViewRect, this.mBitmapPaint);
            } else {
                this.mPath.reset();
                this.mPath.addRoundRect(this.mViewRect, new float[]{this.mRoundRadiusLeftTop, this.mRoundRadiusLeftTop, this.mRoundRadiusRightTop, this.mRoundRadiusRightTop, this.mRoundRadiusRightBottom, this.mRoundRadiusRightBottom, this.mRoundRadiusLeftBottom, this.mRoundRadiusLeftBottom}, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBitmapPaint);
            }
        }
        if (this.mBorderSize > 0.0f) {
            if (this.mShape == SHAPE_CIRCLE) {
                canvas.drawCircle(this.mViewRect.right / 2.0f, this.mViewRect.bottom / 2.0f, Math.min(this.mViewRect.right, this.mViewRect.bottom) / 2.0f - this.mBorderSize / 2.0f, this.mBorderPaint);
            } else if (this.mShape == SHAPE_OVAL) {
                canvas.drawOval(this.mBorderRect, this.mBorderPaint);
            } else {
                this.mPath.reset();
                this.mPath.addRoundRect(this.mBorderRect, new float[]{this.mRoundRadiusLeftTop, this.mRoundRadiusLeftTop, this.mRoundRadiusRightTop, this.mRoundRadiusRightTop, this.mRoundRadiusRightBottom, this.mRoundRadiusRightBottom, this.mRoundRadiusLeftBottom, this.mRoundRadiusLeftBottom}, Path.Direction.CW);
                canvas.drawPath(this.mPath, this.mBorderPaint);
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initRect();
        this.setupBitmapShader();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    private void setupBitmapShader() {
        if (this.mBitmapPaint == null) {
            return;
        }
        if (this.mBitmap == null) {
            this.invalidate();
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        this.mShaderMatrix.set(null);
        float scale = Math.max((float)this.getWidth() * 1.0f / (float)this.mBitmap.getWidth(), (float)this.getHeight() * 1.0f / (float)this.mBitmap.getHeight());
        float dx = ((float)this.getWidth() - (float)this.mBitmap.getWidth() * scale) / 2.0f;
        float dy = ((float)this.getHeight() - (float)this.mBitmap.getHeight() * scale) / 2.0f;
        this.mShaderMatrix.setScale(scale, scale);
        this.mShaderMatrix.postTranslate(dx, dy);
        this.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
        this.invalidate();
    }

    private void initRect() {
        this.mViewRect.top = 0.0f;
        this.mViewRect.left = 0.0f;
        this.mViewRect.right = this.getWidth();
        this.mViewRect.bottom = this.getHeight();
        this.mBorderRect.top = this.mBorderSize / 2.0f;
        this.mBorderRect.left = this.mBorderSize / 2.0f;
        this.mBorderRect.right = (float)this.getWidth() - this.mBorderSize / 2.0f;
        this.mBorderRect.bottom = (float)this.getHeight() - this.mBorderSize / 2.0f;
    }

    public int getShape() {
        return this.mShape;
    }

    public void setShape(int shape) {
        this.mShape = shape;
    }

    public float getBorderSize() {
        return this.mBorderSize;
    }

    public void setBorderSize(int mBorderSize) {
        this.mBorderSize = mBorderSize;
        this.mBorderPaint.setStrokeWidth((float)mBorderSize);
        this.initRect();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int mBorderColor) {
        this.mBorderColor = mBorderColor;
        this.mBorderPaint.setColor(mBorderColor);
        this.invalidate();
    }

    public float getRoundRadius() {
        return this.mRoundRadius;
    }

    public void setRoundRadius(float mRoundRadius) {
        this.mRoundRadius = mRoundRadius;
        this.invalidate();
    }

    public void setRoundRadiis(float roundRadiusLeftBottom, float roundRadiusLeftTop, float roundRadiusRightBottom, float roundRadiusRightTop) {
        this.mRoundRadiusLeftBottom = roundRadiusLeftBottom;
        this.mRoundRadiusLeftTop = roundRadiusLeftTop;
        this.mRoundRadiusRightBottom = roundRadiusRightBottom;
        this.mRoundRadiusRightTop = roundRadiusRightTop;
        this.invalidate();
    }

    public float[] getRoundRadiis() {
        return new float[]{this.mRoundRadiusLeftBottom, this.mRoundRadiusLeftTop, this.mRoundRadiusRightBottom, this.mRoundRadiusRightTop};
    }
}

