/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import cn.forward.androids.R;
import cn.forward.androids.views.SelectorAttrs;
import cn.forward.androids.views.ViewPaddingAttrs;

public class MaskImageView
extends ImageView {
    public static final int MASK_LEVEL_BACKGROUND = 1;
    public static final int MASK_LEVEL_FOREGROUND = 2;
    private boolean mIsIgnoreAlpha = true;
    private boolean mIsShowMaskOnClick = true;
    private int mMaskColor = 0xFFFFFF;
    private float mPressedAlpha = 1.0f;
    private int mMaskLevel = 2;
    private ColorMatrix mColorMatrix = new ColorMatrix();
    private ColorFilter mColorFilter;
    private ColorFilter mLastColorFilter;

    public MaskImageView(Context context) {
        this(context, null);
    }

    public MaskImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MaskImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaskImageView);
        this.mIsIgnoreAlpha = a.getBoolean(R.styleable.MaskImageView_miv_is_ignore_alpha, this.mIsIgnoreAlpha);
        this.mIsShowMaskOnClick = a.getBoolean(R.styleable.MaskImageView_miv_is_show_mask_on_click, this.mIsShowMaskOnClick);
        this.mMaskColor = a.getColor(R.styleable.MaskImageView_miv_mask_color, this.mMaskColor);
        this.mMaskLevel = a.getInt(R.styleable.MaskImageView_miv_mask_level, this.mMaskLevel);
        this.mPressedAlpha = a.getFloat(R.styleable.MaskImageView_miv_pressed_alpha, this.mPressedAlpha);
        this.setMaskColor(this.mMaskColor);
        a.recycle();
        SelectorAttrs.obtainsAttrs(this.getContext(), (View)this, attrs);
        ViewPaddingAttrs.obtainsAttrs(this.getContext(), (View)this, attrs);
    }

    private void setColorMatrix(float[] matrix) {
        this.mColorMatrix.set(matrix);
        this.mColorFilter = new ColorMatrixColorFilter(this.mColorMatrix);
    }

    private void setDrawableColorFilter(ColorFilter colorFilter) {
        if (this.mMaskLevel == 1) {
            if (this.getBackground() != null) {
                if (this.mLastColorFilter == colorFilter) {
                    return;
                }
                this.getBackground().mutate();
                this.getBackground().setColorFilter(colorFilter);
            }
        } else if (this.mMaskLevel == 2 && this.getDrawable() != null) {
            if (this.mLastColorFilter == colorFilter) {
                return;
            }
            this.getDrawable().mutate();
            this.getDrawable().setColorFilter(colorFilter);
        }
        this.mLastColorFilter = colorFilter;
    }

    public void draw(Canvas canvas) {
        if (this.mIsIgnoreAlpha) {
            if (this.mIsShowMaskOnClick && this.isPressed()) {
                this.setDrawableColorFilter(this.mColorFilter);
            } else {
                this.setDrawableColorFilter(null);
            }
        }
        super.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.mIsIgnoreAlpha) {
            this.setDrawableColorFilter(null);
            if (this.mMaskLevel == 1) {
                if (this.mIsShowMaskOnClick && this.isPressed()) {
                    canvas.drawColor(this.mMaskColor);
                }
                super.onDraw(canvas);
            } else {
                super.onDraw(canvas);
                if (this.mIsShowMaskOnClick && this.isPressed()) {
                    canvas.drawColor(this.mMaskColor);
                }
            }
        } else {
            super.onDraw(canvas);
        }
    }

    public void setPressed(boolean pressed) {
        super.setPressed(pressed);
        if (pressed) {
            this.setAlpha(this.mPressedAlpha);
        } else {
            this.setAlpha(1.0f);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public boolean isIsIgnoreAlpha() {
        return this.mIsIgnoreAlpha;
    }

    public void setIsIgnoreAlpha(boolean mIsIgnoreAlpha) {
        this.mIsIgnoreAlpha = mIsIgnoreAlpha;
        this.invalidate();
    }

    public boolean isIsShowMaskOnClick() {
        return this.mIsShowMaskOnClick;
    }

    public void setIsShowMaskOnClick(boolean isShowMaskOnClick) {
        this.mIsShowMaskOnClick = isShowMaskOnClick;
        this.invalidate();
    }

    public int getShadeColor() {
        return this.getMaskColor();
    }

    public void setShadeColor(int shadeColor) {
        this.setMaskColor(shadeColor);
    }

    public int getMaskColor() {
        return this.mMaskColor;
    }

    public void setMaskColor(int maskColor) {
        this.mMaskColor = maskColor;
        float r = (float)Color.alpha((int)maskColor) / 255.0f;
        r -= (1.0f - r) * 0.15f;
        float rr = (1.0f - r) * 1.15f;
        this.setColorMatrix(new float[]{rr, 0.0f, 0.0f, 0.0f, (float)Color.red((int)maskColor) * r, 0.0f, rr, 0.0f, 0.0f, (float)Color.green((int)maskColor) * r, 0.0f, 0.0f, rr, 0.0f, (float)Color.blue((int)maskColor) * r, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        this.invalidate();
    }

    public int getMaskLevel() {
        return this.mMaskLevel;
    }

    public void setMaskLevel(int maskLevel) {
        this.mMaskLevel = maskLevel;
        this.invalidate();
    }

    public void setPressedAlpha(float pressedAlpha) {
        this.mPressedAlpha = pressedAlpha;
        this.invalidate();
    }
}

