/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.utils;

import android.graphics.Point;
import android.support.v4.widget.TextViewCompat;
import android.text.Layout;
import android.text.SpannableString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class EllipsizeUtils {
    public static final int HIGHLIGHT_FIRST = 0;
    public static final int HIGHLIGHT_LAST = 1;
    public static final int HIGHLIGHT_ALL = 2;
    private static final String ELLIPSIS_NORMAL = "\u2026";

    public static SpannableString highlight(String content, String keyword, int color, int fromIndex, int highlightType, boolean ignoreCase) {
        String compareKeyword;
        SpannableString ss = new SpannableString((CharSequence)content);
        if (fromIndex >= content.length() || TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)keyword)) {
            return ss;
        }
        fromIndex = Math.max(0, fromIndex);
        String compareContent = ignoreCase ? content.toLowerCase(Locale.ENGLISH) : content;
        String string = compareKeyword = ignoreCase ? keyword.toLowerCase(Locale.ENGLISH) : keyword;
        if (highlightType == 1 || highlightType == 0) {
            int index = -1;
            if (highlightType == 1) {
                index = compareContent.lastIndexOf(compareKeyword);
                if (index < fromIndex) {
                    index = -1;
                }
            } else {
                index = compareContent.indexOf(compareKeyword, fromIndex);
            }
            if (index > -1) {
                ss.setSpan((Object)new ForegroundColorSpan(color), index, index + keyword.length(), 33);
            }
        } else {
            int index = compareContent.indexOf(compareKeyword, fromIndex);
            while (index >= 0) {
                ss.setSpan((Object)new ForegroundColorSpan(color), index, index + keyword.length(), 33);
                index = compareContent.indexOf(compareKeyword, index + keyword.length());
            }
        }
        return ss;
    }

    public static void ellipsizeByKeyword(TextView textView, String content, String keyword, boolean ignoreCase) {
        if (TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)keyword)) {
            textView.setText(null);
            return;
        }
        if (textView.getWidth() <= 0) {
            new EllipseListener(textView, content, keyword, ignoreCase);
        } else {
            EllipsizeUtils.ellipsizeByKeywordInner(textView, content, keyword, ignoreCase);
        }
    }

    public static void ellipsizeAndHighlight(TextView textView, String content, String keyword, int highlightColor, boolean highlightAll, boolean ignoreCase) {
        if (TextUtils.isEmpty((CharSequence)content) || TextUtils.isEmpty((CharSequence)keyword)) {
            textView.setText(null);
            return;
        }
        if (textView.getWidth() <= 0) {
            new EllipseListener(textView, content, keyword, highlightColor, highlightAll, ignoreCase);
        } else {
            EllipsizeUtils.ellipsizeByKeywordInner(textView, content, keyword, ignoreCase);
            int type = 2;
            if (!highlightAll) {
                type = textView.getEllipsize() == TextUtils.TruncateAt.START ? 1 : 0;
            }
            SpannableString s = EllipsizeUtils.highlight(textView.getText().toString(), keyword, highlightColor, 0, type, ignoreCase);
            textView.setText((CharSequence)s);
        }
    }

    private static void ellipsizeByKeywordInner(TextView textView, String content, String keyword, boolean ignoreCase) {
        String compareKeyword;
        TextPaint paint = textView.getPaint();
        if (paint == null) {
            textView.setText(null);
            return;
        }
        String compareContent = ignoreCase ? content.toLowerCase(Locale.ENGLISH) : content;
        int keywordStart = compareContent.indexOf(compareKeyword = ignoreCase ? keyword.toLowerCase(Locale.ENGLISH) : keyword);
        if (keywordStart < 0) {
            textView.setText(null);
            return;
        }
        int maxLine = TextViewCompat.getMaxLines((TextView)textView);
        if (maxLine <= 0) {
            textView.setText((CharSequence)content);
            return;
        }
        int availableWidth = textView.getWidth() - textView.getPaddingLeft() - textView.getPaddingRight();
        if (maxLine < 2) {
            int availableCount = 0;
            String newCharSeq = TextUtils.ellipsize((CharSequence)compareContent, (TextPaint)paint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
            availableCount = newCharSeq.length();
            if (newCharSeq.contains(compareKeyword)) {
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView.setText((CharSequence)content);
                return;
            }
            newCharSeq = TextUtils.ellipsize((CharSequence)compareContent, (TextPaint)paint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.START).toString();
            availableCount = Math.max(newCharSeq.length(), availableCount);
            if (newCharSeq.contains(compareKeyword)) {
                textView.setEllipsize(TextUtils.TruncateAt.START);
                textView.setText((CharSequence)content);
                return;
            }
            if (availableCount <= keyword.length()) {
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView.setText((CharSequence)(ELLIPSIS_NORMAL + keyword));
                return;
            }
            textView.setEllipsize(TextUtils.TruncateAt.END);
            int start = keywordStart - (availableCount - keyword.length()) / 2;
            String text = ELLIPSIS_NORMAL + content.substring(start >= 0 ? start : 0);
            newCharSeq = TextUtils.ellipsize((CharSequence)text, (TextPaint)paint, (float)availableWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
            if (newCharSeq.contains(compareKeyword)) {
                textView.setText((CharSequence)text);
            } else {
                textView.setText((CharSequence)(ELLIPSIS_NORMAL + content.substring(keywordStart)));
            }
        } else {
            List<Point> linesStart = EllipsizeUtils.getLineStartAndEnd(textView.getPaint(), compareContent, availableWidth);
            int keywordLineStart = EllipsizeUtils.getKeywordLine(keywordStart, linesStart);
            int keywordLineEnd = EllipsizeUtils.getKeywordLine(keywordStart + compareKeyword.length() + 1, linesStart);
            if (keywordLineEnd - keywordLineStart < maxLine) {
                int endLine = Math.min(keywordLineStart + maxLine / 2, linesStart.size() - 1);
                int startLine = Math.max(endLine - (maxLine - 1) + maxLine % 2, 0);
                textView.setEllipsize(TextUtils.TruncateAt.END);
                if (startLine == 0) {
                    textView.setText((CharSequence)content);
                } else {
                    int start = linesStart.get((int)startLine).x;
                    textView.setText((CharSequence)(ELLIPSIS_NORMAL + content.substring(start)));
                }
            } else {
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView.setText((CharSequence)(ELLIPSIS_NORMAL + content.substring(keywordStart)));
            }
        }
    }

    private static int getKeywordLine(int keywordStart, List<Point> linesStart) {
        for (int i = 0; i < linesStart.size(); ++i) {
            if (keywordStart >= linesStart.get((int)i).y) continue;
            return i;
        }
        return 0;
    }

    private static List<Point> getLineStartAndEnd(TextPaint tp, CharSequence cs, int lineWidth) {
        StaticLayout layout = new StaticLayout(cs, tp, lineWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        int count = layout.getLineCount();
        ArrayList<Point> list = new ArrayList<Point>();
        for (int i = 0; i < count; ++i) {
            list.add(new Point(layout.getLineStart(i), layout.getLineEnd(i)));
        }
        return list;
    }

    public static void ellipsize(TextView textView, String content) {
        TextUtils.TruncateAt ellipsize = textView.getEllipsize();
        if (ellipsize != TextUtils.TruncateAt.START && ellipsize != TextUtils.TruncateAt.MIDDLE) {
            textView.setText((CharSequence)content);
            return;
        }
        int maxLine = TextViewCompat.getMaxLines((TextView)textView);
        int availableWidth = textView.getWidth() - textView.getPaddingLeft() - textView.getPaddingRight();
        if (maxLine < 2) {
            textView.setText((CharSequence)content);
        } else {
            List<Point> linesStart = EllipsizeUtils.getLineStartAndEnd(textView.getPaint(), content, availableWidth);
            if (linesStart.size() <= maxLine) {
                textView.setText((CharSequence)content);
                return;
            }
            if (ellipsize == TextUtils.TruncateAt.START) {
                int start = linesStart.get((int)(linesStart.size() - maxLine)).x;
                start = Math.max(start + ELLIPSIS_NORMAL.length(), 0);
                String substring = content.substring(start);
                while (EllipsizeUtils.getLayout(textView.getPaint(), ELLIPSIS_NORMAL + substring, availableWidth).getLineCount() > maxLine) {
                    int firstSpace = substring.indexOf(32);
                    if (firstSpace == -1) {
                        substring = substring.substring(1);
                        continue;
                    }
                    substring = substring.substring(firstSpace + 1);
                }
                textView.setText((CharSequence)(ELLIPSIS_NORMAL + substring));
            } else {
                int middleLineStart = (maxLine - 1) / 2;
                Point point = linesStart.get(middleLineStart);
                int startEllipsize = point.y - ELLIPSIS_NORMAL.length();
                String substringStart = content.substring(0, startEllipsize);
                int middleLineEnd = linesStart.size() - (maxLine - (maxLine - 1) / 2 - 1);
                Point pointEnd = linesStart.get(middleLineEnd);
                String substringEnd = content.substring(pointEnd.x);
                while (EllipsizeUtils.getLayout(textView.getPaint(), substringStart + ELLIPSIS_NORMAL + substringEnd, availableWidth).getLineCount() > maxLine) {
                    int firstSpace = substringEnd.indexOf(32);
                    if (firstSpace == -1) {
                        substringEnd = substringEnd.substring(1);
                        continue;
                    }
                    substringEnd = substringEnd.substring(firstSpace + 1);
                }
                textView.setText((CharSequence)(substringStart + ELLIPSIS_NORMAL + substringEnd));
            }
        }
    }

    private static Layout getLayout(TextPaint tp, CharSequence cs, int lineWidth) {
        StaticLayout layout = new StaticLayout(cs, tp, lineWidth, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        return layout;
    }

    private static class EllipseListener
    implements ViewTreeObserver.OnPreDrawListener {
        final TextView textView;
        final String content;
        final String keyword;
        final int highlightColor;
        final boolean highlightAll;
        final boolean ignoreCase;
        boolean needHighlight;

        public EllipseListener(TextView tv, String content, String keyword, boolean ignoreCase) {
            this(tv, content, keyword, 0, false, ignoreCase);
            this.needHighlight = false;
        }

        public EllipseListener(TextView tv, String content, String keyword, int highlightColor, boolean highlightAll, boolean ignoreCase) {
            this.textView = tv;
            this.content = content;
            this.keyword = keyword;
            this.highlightColor = highlightColor;
            this.highlightAll = highlightAll;
            this.ignoreCase = ignoreCase;
            this.needHighlight = true;
            tv.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }

        public boolean onPreDraw() {
            this.textView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            EllipsizeUtils.ellipsizeByKeywordInner(this.textView, this.content, this.keyword, this.ignoreCase);
            if (!this.needHighlight) {
                return true;
            }
            int type = 2;
            if (!this.highlightAll) {
                type = this.textView.getEllipsize() == TextUtils.TruncateAt.START ? 1 : 0;
            }
            SpannableString s = EllipsizeUtils.highlight(this.textView.getText().toString(), this.keyword, this.highlightColor, 0, type, this.ignoreCase);
            this.textView.setText((CharSequence)s);
            return true;
        }
    }
}

