/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class EasyAdapter<VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<SelectionViewHolder<VH>> {
    private Context context;
    private int maxSelectionCount;
    private Mode mode;
    private int singleSelectedPosition = 0;
    private OnItemClickedListener onItemClickedListener = null;
    private OnItemLongClickedListener onItemLongClickedListener = null;
    private OnSingleSelectListener onSingleSelectListener = null;
    private OnMultiSelectListener onMultiSelectListener = null;
    private OnModeChangedListener onModeChangedListener = null;
    private LinkedHashSet<Integer> selectedSet = new LinkedHashSet();

    public abstract VH whenCreateViewHolder(ViewGroup var1, int var2);

    public abstract void whenBindViewHolder(VH var1, int var2);

    public EasyAdapter(Context context, Mode mode, int maxSelectionCount) {
        this.context = context;
        this.mode = mode;
        this.maxSelectionCount = maxSelectionCount;
    }

    public EasyAdapter(Context context) {
        this(context, Mode.CLICK, -1);
    }

    public void setMaxSelectionCount(int maxSelectionCount) {
        this.maxSelectionCount = maxSelectionCount;
        if (maxSelectionCount > 0 && this.selectedSet.size() > maxSelectionCount) {
            this.selectedSet.clear();
        }
        this.notifyDataSetChanged();
    }

    public int getMaxSelectionCount() {
        return this.maxSelectionCount;
    }

    public void setMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        Mode old = this.mode;
        this.mode = mode;
        if (this.onModeChangedListener != null) {
            this.onModeChangedListener.onModeChanged(old, mode);
        }
        this.notifyDataSetChanged();
    }

    public void setSingleSelectedPosition(int singleSelectedPosition) {
        if (this.singleSelectedPosition == singleSelectedPosition) {
            return;
        }
        this.singleSelectedPosition = singleSelectedPosition;
        if (this.onSingleSelectListener != null) {
            this.onSingleSelectListener.onSelected(singleSelectedPosition);
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickedListener(OnItemClickedListener onItemClickedListener) {
        this.onItemClickedListener = onItemClickedListener;
    }

    public OnItemClickedListener getOnItemClickedListener() {
        return this.onItemClickedListener;
    }

    public void setOnItemLongClickedListener(OnItemLongClickedListener onItemLongClickedListener) {
        this.onItemLongClickedListener = onItemLongClickedListener;
    }

    public OnItemLongClickedListener getOnItemLongClickedListener() {
        return this.onItemLongClickedListener;
    }

    public void setOnSingleSelectListener(OnSingleSelectListener onSingleSelectListener) {
        this.onSingleSelectListener = onSingleSelectListener;
    }

    public int getSingleSelectedPosition() {
        return this.singleSelectedPosition;
    }

    public void setOnMultiSelectListener(OnMultiSelectListener onMultiSelectListener) {
        this.onMultiSelectListener = onMultiSelectListener;
    }

    public OnMultiSelectListener getOnMultiSelectListener() {
        return this.onMultiSelectListener;
    }

    public void setOnModeChangedListener(OnModeChangedListener onModeChangedListener) {
        this.onModeChangedListener = onModeChangedListener;
    }

    public OnModeChangedListener getOnModeChangedListener() {
        return this.onModeChangedListener;
    }

    public SelectionViewHolder<VH> onCreateViewHolder(ViewGroup parent, int viewType) {
        VH vh = this.whenCreateViewHolder(parent, viewType);
        final SelectionViewHolder<VH> viewHolder = new SelectionViewHolder<VH>(vh);
        viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = viewHolder.getAdapterPosition();
                if (EasyAdapter.this.mode == Mode.CLICK) {
                    if (EasyAdapter.this.onItemClickedListener != null) {
                        EasyAdapter.this.onItemClickedListener.onClicked(pos);
                    }
                } else if (EasyAdapter.this.mode == Mode.SINGLE_SELECT) {
                    EasyAdapter.this.singleSelectedPosition = pos;
                    if (EasyAdapter.this.onSingleSelectListener != null) {
                        EasyAdapter.this.onSingleSelectListener.onSelected(EasyAdapter.this.singleSelectedPosition);
                    }
                    EasyAdapter.this.notifyDataSetChanged();
                } else if (EasyAdapter.this.mode == Mode.MULTI_SELECT) {
                    if (EasyAdapter.this.maxSelectionCount > 0 && EasyAdapter.this.selectedSet.size() >= EasyAdapter.this.maxSelectionCount && !EasyAdapter.this.selectedSet.contains(pos)) {
                        if (EasyAdapter.this.onMultiSelectListener != null) {
                            EasyAdapter.this.onMultiSelectListener.onOutOfMax(pos);
                        }
                        return;
                    }
                    boolean isSelected = EasyAdapter.this.selectedSet.contains(pos);
                    if (isSelected) {
                        EasyAdapter.this.selectedSet.remove(pos);
                    } else {
                        EasyAdapter.this.selectedSet.add(pos);
                    }
                    if (EasyAdapter.this.onMultiSelectListener != null) {
                        EasyAdapter.this.onMultiSelectListener.onSelected(pos, !isSelected);
                    }
                    EasyAdapter.this.notifyDataSetChanged();
                }
            }
        });
        viewHolder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                int pos = viewHolder.getAdapterPosition();
                if (EasyAdapter.this.onItemLongClickedListener != null) {
                    return EasyAdapter.this.onItemLongClickedListener.onLongClicked(pos);
                }
                return false;
            }
        });
        return viewHolder;
    }

    public void onBindViewHolder(SelectionViewHolder<VH> holder, int position) {
        this.whenBindViewHolder(holder.viewHolder, position);
        switch (this.mode) {
            case CLICK: {
                holder.itemView.setSelected(false);
                break;
            }
            case SINGLE_SELECT: {
                holder.itemView.setSelected(this.singleSelectedPosition == position);
                break;
            }
            case MULTI_SELECT: {
                holder.itemView.setSelected(this.selectedSet.contains(position));
            }
        }
    }

    public void selectAll() {
        if (this.maxSelectionCount > 0) {
            return;
        }
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.selectedSet.add(i);
        }
        if (this.onMultiSelectListener != null) {
            this.onMultiSelectListener.onSelected(SelectionMode.SELECT_ALL, new LinkedHashSet<Integer>(this.selectedSet));
        }
        this.notifyDataSetChanged();
    }

    public void unselectAll() {
        this.selectedSet.clear();
        if (this.onMultiSelectListener != null) {
            this.onMultiSelectListener.onSelected(SelectionMode.UNSELECT_ALL, new LinkedHashSet<Integer>(this.selectedSet));
        }
        this.notifyDataSetChanged();
    }

    public void reverseSelected() {
        if (this.maxSelectionCount > 0) {
            return;
        }
        HashSet<Integer> set = new HashSet<Integer>(this.selectedSet);
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.selectedSet.add(i);
        }
        this.selectedSet.removeAll(set);
        if (this.onMultiSelectListener != null) {
            this.onMultiSelectListener.onSelected(SelectionMode.REVERSE_SELECTED, new LinkedHashSet<Integer>(this.selectedSet));
        }
        this.notifyDataSetChanged();
    }

    public void select(int ... position) {
        if (this.mode == Mode.SINGLE_SELECT) {
            this.singleSelectedPosition = position[0];
            if (this.onSingleSelectListener != null) {
                this.onSingleSelectListener.onSelected(this.singleSelectedPosition);
            }
        } else {
            for (int p : position) {
                if (p >= this.getItemCount() || this.selectedSet.contains(p)) continue;
                if (this.onMultiSelectListener != null) {
                    if (this.maxSelectionCount > 0 && this.selectedSet.size() >= this.maxSelectionCount) {
                        this.onMultiSelectListener.onOutOfMax(p);
                        continue;
                    }
                    this.selectedSet.add(p);
                    this.onMultiSelectListener.onSelected(p, false);
                    continue;
                }
                if (this.maxSelectionCount >= 1 && this.selectedSet.size() >= this.maxSelectionCount) continue;
                this.selectedSet.add(p);
            }
            this.notifyDataSetChanged();
        }
    }

    public void unselect(int ... position) {
        for (int p : position) {
            if (p >= this.getItemCount() || !this.selectedSet.contains(p)) continue;
            if (this.onMultiSelectListener != null) {
                this.selectedSet.remove(p);
                this.onMultiSelectListener.onSelected(p, false);
                continue;
            }
            this.selectedSet.remove(p);
        }
        this.notifyDataSetChanged();
    }

    public boolean isSelected(int position) {
        return this.selectedSet.contains(position);
    }

    public Set<Integer> getSelectedSet() {
        return new LinkedHashSet<Integer>(this.selectedSet);
    }

    public static interface OnModeChangedListener {
        public void onModeChanged(Mode var1, Mode var2);
    }

    public static interface OnMultiSelectListener {
        public void onSelected(int var1, boolean var2);

        public void onSelected(SelectionMode var1, Set<Integer> var2);

        public void onOutOfMax(int var1);
    }

    public static enum SelectionMode {
        SELECT_ALL,
        UNSELECT_ALL,
        REVERSE_SELECTED;

    }

    public static interface OnSingleSelectListener {
        public void onSelected(int var1);
    }

    public static interface OnItemLongClickedListener {
        public boolean onLongClicked(int var1);
    }

    public static interface OnItemClickedListener {
        public void onClicked(int var1);
    }

    private static class SelectionItemView
    extends FrameLayout {
        public SelectionItemView(RecyclerView.ViewHolder viewHolder) {
            super(viewHolder.itemView.getContext());
            this.addView(viewHolder.itemView);
        }
    }

    static class SelectionViewHolder<VH extends RecyclerView.ViewHolder>
    extends RecyclerView.ViewHolder {
        VH viewHolder;

        public SelectionViewHolder(VH viewHolder) {
            super((View)new SelectionItemView((RecyclerView.ViewHolder)viewHolder));
            this.viewHolder = viewHolder;
        }
    }

    public static enum Mode {
        CLICK,
        SINGLE_SELECT,
        MULTI_SELECT;

    }
}

