/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import cn.forward.androids.R;
import cn.forward.androids.views.SelectorAttrs;

public class STextView
extends TextView {
    public STextView(Context context) {
        this(context, null);
    }

    public STextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public STextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.STextView);
        int defaultColor = this.getTextColors().getDefaultColor();
        int textColorSelected = a.getColor(R.styleable.STextView_stv_text_color_selected, defaultColor);
        int textColorPressed = a.getColor(R.styleable.STextView_stv_text_color_pressed, a.getColor(R.styleable.STextView_mtv_text_color_pressed, defaultColor));
        int textColorDisable = a.getColor(R.styleable.STextView_stv_text_color_disable, a.getColor(R.styleable.STextView_mtv_text_color_disable, defaultColor));
        this.setTextColor(this.createColorStateList(textColorPressed, textColorSelected, textColorDisable, defaultColor));
        a.recycle();
        SelectorAttrs.obtainsAttrs(this.getContext(), (View)this, attrs);
    }

    private ColorStateList createColorStateList(int pressed, int selected, int unable, int normal) {
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842910, 16842919}, {16842910, 0x10100A1}, {-16842910}, new int[0]}, new int[]{pressed, selected, unable, normal});
        return colorStateList;
    }
}

