/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.ListView;

public class DragListView
extends ListView {
    private int mLastPosition;
    private int mCurrentPosition;
    private int mAutoScrollUpY;
    private int mAutoScrollDownY;
    private int mLastX;
    private int mLastY;
    private int mDownX;
    private int mDownY;
    private int mDragViewOffset;
    private DragItemListener mDragItemListener;
    private boolean mHasStart = false;
    private Bitmap mBitmap;
    private View mItemView;
    private int mTouchSlop;
    private long mLastScrollTime;
    private boolean mScrolling = false;
    private Runnable mScrollRunnable;
    private float mMoveY;

    public DragListView(Context context) {
        this(context, null);
    }

    public DragListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DragListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.mScrollRunnable = new Runnable(){

            @Override
            public void run() {
                DragListView.this.mScrolling = false;
                if (DragListView.this.mBitmap != null) {
                    DragListView.this.mLastScrollTime = System.currentTimeMillis();
                    DragListView.this.onMove((int)DragListView.this.mMoveY);
                    DragListView.this.invalidate();
                }
            }
        };
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 1: 
            case 3: 
            case 4: {
                if (this.mBitmap == null) break;
                this.mLastX = (int)ev.getX();
                this.mLastY = (int)ev.getY();
                this.stopDrag();
                this.invalidate();
                return true;
            }
            case 2: {
                int moveY;
                if (this.mBitmap == null) break;
                if (!this.mHasStart) {
                    this.mDragItemListener.startDrag(this.mCurrentPosition, this.mItemView);
                    this.mHasStart = true;
                }
                if ((moveY = (int)ev.getY()) < 0) {
                    moveY = 0;
                } else if (moveY > this.getHeight()) {
                    moveY = this.getHeight();
                }
                this.mMoveY = moveY;
                this.onMove(moveY);
                this.mLastY = moveY;
                this.mLastX = (int)ev.getX();
                this.invalidate();
                return true;
            }
            case 0: {
                this.stopDrag();
                this.mDownX = (int)ev.getX();
                this.mDownY = (int)ev.getY();
                int temp = this.pointToPosition(this.mDownX, this.mDownY);
                if (temp == -1) {
                    return super.dispatchTouchEvent(ev);
                }
                this.mLastPosition = this.mCurrentPosition = temp;
                ViewGroup itemView = (ViewGroup)this.getChildAt(this.mCurrentPosition - this.getFirstVisiblePosition());
                if (itemView == null || this.mDragItemListener == null || !this.mDragItemListener.canDrag((View)itemView, this.mDownX, this.mDownY)) break;
                this.mDragViewOffset = this.mDownY - itemView.getTop();
                this.mDragItemListener.beforeDrawingCache((View)itemView);
                itemView.setDrawingCacheEnabled(true);
                this.mBitmap = Bitmap.createBitmap((Bitmap)itemView.getDrawingCache());
                itemView.setDrawingCacheEnabled(false);
                Bitmap afterBitmap = this.mDragItemListener.afterDrawingCache((View)itemView, this.mBitmap);
                this.mBitmap = afterBitmap != null ? afterBitmap : this.mBitmap;
                this.mHasStart = false;
                this.mLastY = this.mDownY;
                this.mLastX = this.mDownX;
                this.mItemView = itemView;
                this.invalidate();
                return true;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            canvas.drawBitmap(this.mBitmap, 0.0f, (float)(this.mLastY - this.mDragViewOffset), null);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mAutoScrollUpY = this.dp2px(this.getContext(), 80.0f);
        this.mAutoScrollDownY = h - this.mAutoScrollUpY;
    }

    public void onMove(int moveY) {
        int endPos = this.pointToPosition(this.getWidth() / 2, moveY);
        if (endPos == -1) {
            this.checkScroller(moveY);
            return;
        }
        int mask = this.mLastPosition > endPos ? -1 : 1;
        int i = this.mLastPosition;
        while (mask > 0 ? i <= endPos : i >= endPos) {
            int index = i - this.getFirstVisiblePosition();
            if (index < this.getChildCount() && index >= 0) {
                int y = this.getChildAt(index).getTop();
                int tempPosition = this.pointToPosition(0, y);
                if (tempPosition != -1) {
                    this.mCurrentPosition = tempPosition;
                }
                if (y < this.getChildAt(0).getTop()) {
                    this.mCurrentPosition = 0;
                } else if (y > this.getChildAt(this.getChildCount() - 1).getBottom()) {
                    this.mCurrentPosition = this.getAdapter().getCount() - 1;
                }
                this.checkExchange(y);
            }
            i += mask;
        }
        this.checkScroller(moveY);
    }

    public void checkScroller(int y) {
        View view;
        int offset = 0;
        if (y < this.mAutoScrollUpY) {
            if (y <= this.mDownY - this.mTouchSlop) {
                offset = this.dp2px(this.getContext(), 6.0f);
            }
        } else if (y > this.mAutoScrollDownY && y >= this.mDownY + this.mTouchSlop) {
            offset = -this.dp2px(this.getContext(), 6.0f);
        }
        if (offset != 0 && (view = this.getChildAt(this.mCurrentPosition - this.getFirstVisiblePosition())) != null) {
            this.setSelectionFromTop(this.mCurrentPosition, view.getTop() + offset);
            if (!this.mScrolling) {
                this.mScrolling = true;
                long passed = System.currentTimeMillis() - this.mLastScrollTime;
                this.postDelayed(this.mScrollRunnable, passed > 15L ? 15L : 15L - passed);
            }
        }
    }

    public void stopDrag() {
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
            if (this.mDragItemListener != null) {
                this.mDragItemListener.onRelease(this.mCurrentPosition, this.mItemView, this.mLastY - this.mDragViewOffset, this.mLastX, this.mLastY);
            }
        }
        if (this.mItemView != null) {
            this.mItemView = null;
        }
        this.mScrolling = false;
        this.removeCallbacks(this.mScrollRunnable);
    }

    private void checkExchange(int y) {
        if (this.mCurrentPosition != this.mLastPosition && this.mDragItemListener != null && this.mDragItemListener.canExchange(this.mLastPosition, this.mCurrentPosition)) {
            View lastView = this.mItemView;
            this.mItemView = this.getChildAt(this.mCurrentPosition - this.getFirstVisiblePosition());
            this.mDragItemListener.onExchange(this.mLastPosition, this.mCurrentPosition, lastView, this.mItemView);
            this.mLastPosition = this.mCurrentPosition;
        }
    }

    public void setDragItemListener(DragItemListener listener) {
        this.mDragItemListener = listener;
    }

    public DragItemListener getDragListener() {
        return this.mDragItemListener;
    }

    public int dp2px(Context context, float dp) {
        return (int)(context.getResources().getDisplayMetrics().density * dp + 0.5f);
    }

    public static abstract class SimpleAnimationDragItemListener
    implements DragItemListener {
        @Override
        public void onRelease(int positon, View itemView, int itemViewY, int releaseX, int releaseY) {
            itemView.setVisibility(0);
            if (itemView != null && Math.abs(itemViewY - itemView.getTop()) > itemView.getHeight() / 5) {
                AlphaAnimation animation = new AlphaAnimation(0.5f, 1.0f);
                animation.setDuration(150L);
                itemView.clearAnimation();
                itemView.startAnimation((Animation)animation);
            }
        }

        @Override
        public void startDrag(int position, View itemView) {
            if (itemView != null) {
                itemView.setVisibility(4);
            }
        }

        @Override
        public void onExchange(int srcPosition, int position, View srcItemView, View itemView) {
            if (srcItemView != null) {
                int height = srcPosition > position ? -srcItemView.getHeight() : srcItemView.getHeight();
                TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)height, 0.0f);
                animation.setDuration(200L);
                srcItemView.clearAnimation();
                srcItemView.startAnimation((Animation)animation);
                srcItemView.setVisibility(0);
            }
            if (itemView != null) {
                itemView.setVisibility(4);
            }
        }
    }

    public static interface DragItemListener {
        public boolean canExchange(int var1, int var2);

        public void onExchange(int var1, int var2, View var3, View var4);

        public void onRelease(int var1, View var2, int var3, int var4, int var5);

        public boolean canDrag(View var1, int var2, int var3);

        public void startDrag(int var1, View var2);

        public void beforeDrawingCache(View var1);

        public Bitmap afterDrawingCache(View var1, Bitmap var2);
    }
}

