/*
 * Decompiled with CFR 0.152.
 */
package cn.forward.androids.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import cn.forward.androids.R;

public class SelectorAttrs {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;

    public static void obtainsAttrs(Context context, View view, AttributeSet attrs) {
        Drawable drawable;
        int backgroundBorderWidth;
        int backgroundCorners;
        int shape;
        Drawable bitmapDrawable = view.getBackground();
        if (bitmapDrawable instanceof StateListDrawable) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21 && bitmapDrawable instanceof RippleDrawable) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View);
        if (bitmapDrawable instanceof ColorDrawable) {
            bitmapDrawable = null;
        }
        GradientDrawable colorShapeDrawable = null;
        GradientDrawable colorShapeDrawablePressed = null;
        GradientDrawable colorShapeDrawableSelected = null;
        Drawable bitmapDrawablePressed = null;
        Drawable bitmapDrawableSelected = null;
        if (a.hasValue(R.styleable.View_sel_background_pressed) || a.hasValue(R.styleable.View_sel_background_border_pressed)) {
            bitmapDrawablePressed = a.getDrawable(R.styleable.View_sel_background_pressed);
            if (bitmapDrawablePressed instanceof ColorDrawable) {
                bitmapDrawablePressed = null;
            }
            if (bitmapDrawablePressed == null) {
                colorShapeDrawablePressed = new GradientDrawable();
            }
        }
        if (a.hasValue(R.styleable.View_sel_background_selected) || a.hasValue(R.styleable.View_sel_background_border_selected)) {
            bitmapDrawableSelected = a.getDrawable(R.styleable.View_sel_background_selected);
            if (bitmapDrawableSelected instanceof ColorDrawable) {
                bitmapDrawableSelected = null;
            }
            if (bitmapDrawableSelected == null) {
                colorShapeDrawableSelected = new GradientDrawable();
            }
        }
        int background = 0;
        if (bitmapDrawable == null) {
            Drawable bg = view.getBackground();
            if (bg == null && a.hasValue(R.styleable.View_sel_background)) {
                bg = a.getDrawable(R.styleable.View_sel_background);
            }
            colorShapeDrawable = new GradientDrawable();
            if (bg instanceof ColorDrawable) {
                background = ((ColorDrawable)bg).getColor();
                colorShapeDrawable.setColor(background);
            }
        }
        if (colorShapeDrawablePressed != null) {
            colorShapeDrawablePressed.setColor(background);
        }
        if (colorShapeDrawableSelected != null) {
            colorShapeDrawableSelected.setColor(background);
        }
        if ((shape = a.getInt(R.styleable.View_sel_background_shape, 0)) == 2) {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setShape(2);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setShape(2);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setShape(2);
            }
        } else if (shape == 1) {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setShape(1);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setShape(1);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setShape(1);
            }
        } else if (shape == 3) {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setShape(3);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setShape(3);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setShape(3);
            }
        } else {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setShape(0);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setShape(0);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setShape(0);
            }
        }
        int radius = backgroundCorners = a.getDimensionPixelOffset(R.styleable.View_sel_background_corners, 0);
        if (colorShapeDrawable != null) {
            colorShapeDrawable.setCornerRadius((float)backgroundCorners);
        }
        if (colorShapeDrawablePressed != null) {
            colorShapeDrawablePressed.setCornerRadius((float)backgroundCorners);
        }
        if (colorShapeDrawableSelected != null) {
            colorShapeDrawableSelected.setCornerRadius((float)backgroundCorners);
        }
        int topLeftRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_corner_topLeft, radius);
        int topRightRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_corner_topRight, radius);
        int bottomLeftRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_corner_bottomLeft, radius);
        int bottomRightRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_corner_bottomRight, radius);
        if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
            }
        }
        if ((backgroundBorderWidth = a.getDimensionPixelOffset(R.styleable.View_sel_background_border_width, -1)) != -1) {
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setStroke(backgroundBorderWidth, 0);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setStroke(backgroundBorderWidth, 0);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setStroke(backgroundBorderWidth, 0);
            }
        }
        if (a.hasValue(R.styleable.View_sel_background_border_color)) {
            int backgroundBorder = a.getColor(R.styleable.View_sel_background_border_color, -1);
            if (colorShapeDrawable != null) {
                colorShapeDrawable.setStroke(backgroundBorderWidth, backgroundBorder);
            }
            if (colorShapeDrawablePressed != null) {
                colorShapeDrawablePressed.setStroke(backgroundBorderWidth, backgroundBorder);
            }
            if (colorShapeDrawableSelected != null) {
                colorShapeDrawableSelected.setStroke(backgroundBorderWidth, backgroundBorder);
            }
        }
        if (colorShapeDrawablePressed != null && a.hasValue(R.styleable.View_sel_background_pressed)) {
            int backgroundPressed = a.getColor(R.styleable.View_sel_background_pressed, 0);
            colorShapeDrawablePressed.setColor(backgroundPressed);
        }
        if (colorShapeDrawablePressed != null && a.hasValue(R.styleable.View_sel_background_border_pressed)) {
            int backgroundBorderPressed = a.getColor(R.styleable.View_sel_background_border_pressed, -1);
            colorShapeDrawablePressed.setStroke(backgroundBorderWidth, backgroundBorderPressed);
        }
        if (colorShapeDrawableSelected != null && a.hasValue(R.styleable.View_sel_background_selected)) {
            int backgroundSelected = a.getColor(R.styleable.View_sel_background_selected, -1);
            colorShapeDrawableSelected.setColor(backgroundSelected);
        }
        if (colorShapeDrawableSelected != null && a.hasValue(R.styleable.View_sel_background_border_selected)) {
            int backgroundBorderSelected = a.getColor(R.styleable.View_sel_background_border_selected, -1);
            colorShapeDrawableSelected.setStroke(backgroundBorderWidth, backgroundBorderSelected);
        }
        StateListDrawable stateListDrawable = new StateListDrawable();
        if (Build.VERSION.SDK_INT < 21 && a.hasValue(R.styleable.View_sel_background_ripple)) {
            drawable = null;
            if (a.hasValue(R.styleable.View_sel_background_ripple_mask)) {
                drawable = a.getDrawable(R.styleable.View_sel_background_ripple_mask);
                if (drawable instanceof ColorDrawable) {
                    drawable = new GradientDrawable();
                    SelectorAttrs.parseRippleMaskShape((GradientDrawable)drawable, a);
                    ((GradientDrawable)drawable).setColor(a.getColor(R.styleable.View_sel_background_ripple, 0));
                } else {
                    drawable = a.getDrawable(R.styleable.View_sel_background_ripple);
                }
            } else {
                drawable = a.getDrawable(R.styleable.View_sel_background_ripple);
            }
            if (colorShapeDrawablePressed != null || bitmapDrawablePressed != null) {
                drawable = new LayerDrawable(new Drawable[]{bitmapDrawablePressed != null ? bitmapDrawablePressed : colorShapeDrawablePressed, drawable});
            } else if (bitmapDrawable != null || colorShapeDrawable != null) {
                drawable = new LayerDrawable(new Drawable[]{bitmapDrawable != null ? bitmapDrawable : colorShapeDrawable, drawable});
            }
            stateListDrawable.addState(new int[]{16842910, 16842919}, drawable);
        } else if (colorShapeDrawablePressed != null || bitmapDrawablePressed != null) {
            drawable = bitmapDrawablePressed != null ? bitmapDrawablePressed : colorShapeDrawablePressed;
            stateListDrawable.addState(new int[]{16842910, 16842919}, drawable);
        }
        if (colorShapeDrawableSelected != null || bitmapDrawableSelected != null) {
            drawable = bitmapDrawableSelected != null ? bitmapDrawableSelected : colorShapeDrawableSelected;
            stateListDrawable.addState(new int[]{16842910, 0x10100A1}, drawable);
        }
        stateListDrawable.addState(new int[]{}, (Drawable)(bitmapDrawable != null ? bitmapDrawable : colorShapeDrawable));
        boolean hasRipple = SelectorAttrs.parseRipple(view, a, (Drawable)(colorShapeDrawable != null || bitmapDrawable != null || colorShapeDrawablePressed != null || bitmapDrawablePressed != null ? stateListDrawable : null));
        if (!hasRipple) {
            view.setBackgroundDrawable((Drawable)stateListDrawable);
        }
        a.recycle();
    }

    private static boolean parseRipple(View view, TypedArray a, Drawable content) {
        boolean hasRipple = false;
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.View_sel_background_ripple)) {
            hasRipple = true;
            GradientDrawable maskShapeDrawable = null;
            Drawable maskBitmapDrawable = null;
            if (a.hasValue(R.styleable.View_sel_background_ripple_mask)) {
                maskBitmapDrawable = a.getDrawable(R.styleable.View_sel_background_ripple_mask);
                if (maskBitmapDrawable instanceof ColorDrawable) {
                    maskBitmapDrawable = null;
                }
                if (maskBitmapDrawable == null) {
                    maskShapeDrawable = new GradientDrawable();
                    SelectorAttrs.parseRippleMaskShape(maskShapeDrawable, a);
                }
            }
            RippleDrawable rippleDrawable = new RippleDrawable(a.getColorStateList(R.styleable.View_sel_background_ripple), content, (Drawable)(maskBitmapDrawable != null ? maskBitmapDrawable : maskShapeDrawable));
            view.setBackgroundDrawable((Drawable)rippleDrawable);
        }
        return hasRipple;
    }

    private static void parseRippleMaskShape(GradientDrawable maskShapeDrawable, TypedArray a) {
        int backgroundCorners;
        maskShapeDrawable.setColor(a.getColor(R.styleable.View_sel_background_ripple_mask, 0));
        int shape = a.getInt(R.styleable.View_sel_background_ripple_mask_shape, 0);
        if (shape == 2) {
            maskShapeDrawable.setShape(2);
        } else if (shape == 1) {
            maskShapeDrawable.setShape(1);
        } else if (shape == 3) {
            maskShapeDrawable.setShape(3);
        } else {
            maskShapeDrawable.setShape(0);
        }
        int radius = backgroundCorners = a.getDimensionPixelOffset(R.styleable.View_sel_background_ripple_mask_corners, 0);
        maskShapeDrawable.setCornerRadius((float)backgroundCorners);
        int topLeftRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_ripple_mask_corner_topLeft, radius);
        int topRightRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_ripple_mask_corner_topRight, radius);
        int bottomLeftRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_ripple_mask_corner_bottomLeft, radius);
        int bottomRightRadius = a.getDimensionPixelSize(R.styleable.View_sel_background_ripple_mask_corner_bottomRight, radius);
        if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
            maskShapeDrawable.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        }
    }
}

