/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.operator;

import com.gitee.starblues.factory.process.pipe.PluginInfoContainers;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import com.gitee.starblues.integration.operator.PluginOperator;
import com.gitee.starblues.integration.operator.module.PluginInfo;
import com.gitee.starblues.realize.UnRegistryValidator;
import com.gitee.starblues.utils.SpringBeanUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pf4j.PluginWrapper;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public class PluginOperatorWrapper
implements PluginOperator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PluginOperator pluginOperator;
    private final IntegrationConfiguration integrationConfiguration;

    public PluginOperatorWrapper(PluginOperator pluginOperator, IntegrationConfiguration integrationConfiguration) {
        this.pluginOperator = pluginOperator;
        this.integrationConfiguration = integrationConfiguration;
    }

    @Override
    public boolean initPlugins(PluginInitializerListener pluginInitializerListener) throws Exception {
        return this.pluginOperator.initPlugins(pluginInitializerListener);
    }

    @Override
    public boolean verify(Path jarPath) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.verify(jarPath);
    }

    @Override
    public PluginInfo install(Path jarPath) throws Exception {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.install(jarPath);
    }

    @Override
    public PluginInfo load(Path jarPath) throws Exception {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.install(jarPath);
    }

    @Override
    public PluginInfo load(MultipartFile pluginFile) throws Exception {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.load(pluginFile);
    }

    @Override
    public boolean unload(String pluginId, boolean isBackup) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.unload(pluginId, isBackup);
    }

    @Override
    public boolean uninstall(String pluginId, boolean isBackup) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        this.checkIsUnRegistry(pluginId);
        return this.pluginOperator.uninstall(pluginId, isBackup);
    }

    @Override
    public boolean start(String pluginId) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.start(pluginId);
    }

    @Override
    public boolean stop(String pluginId) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        this.checkIsUnRegistry(pluginId);
        return this.pluginOperator.stop(pluginId);
    }

    @Override
    public PluginInfo uploadPluginAndStart(MultipartFile pluginFile) throws Exception {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.uploadPluginAndStart(pluginFile);
    }

    @Override
    public boolean installConfigFile(Path configFilePath) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.installConfigFile(configFilePath);
    }

    @Override
    public boolean uploadConfigFile(MultipartFile configFile) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.uploadConfigFile(configFile);
    }

    @Override
    public boolean backupPlugin(Path backDirPath, String sign) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.backupPlugin(backDirPath, sign);
    }

    @Override
    public boolean backupPlugin(String pluginId, String sign) throws Exception {
        if (this.isDisable()) {
            return false;
        }
        return this.pluginOperator.backupPlugin(pluginId, sign);
    }

    @Override
    public List<PluginInfo> getPluginInfo() {
        if (this.isDisable()) {
            return Collections.emptyList();
        }
        return this.pluginOperator.getPluginInfo();
    }

    @Override
    public PluginInfo getPluginInfo(String pluginId) {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.getPluginInfo(pluginId);
    }

    @Override
    public Set<String> getPluginFilePaths() throws Exception {
        if (this.isDisable()) {
            return Collections.emptySet();
        }
        return this.pluginOperator.getPluginFilePaths();
    }

    @Override
    public List<PluginWrapper> getPluginWrapper() {
        if (this.isDisable()) {
            return Collections.emptyList();
        }
        return this.pluginOperator.getPluginWrapper();
    }

    @Override
    public PluginWrapper getPluginWrapper(String pluginId) {
        if (this.isDisable()) {
            return null;
        }
        return this.pluginOperator.getPluginWrapper(pluginId);
    }

    private boolean isDisable() {
        if (this.integrationConfiguration.enable()) {
            return false;
        }
        this.log.info("The Plugin module is disabled!");
        return true;
    }

    private void checkIsUnRegistry(String pluginId) throws Exception {
        GenericApplicationContext pluginApplicationContext = PluginInfoContainers.getPluginApplicationContext(pluginId);
        if (pluginApplicationContext == null) {
            this.log.error("Plugin '{}' Not found ApplicationContext. So cannot found and execute unRegistryValidator", (Object)pluginId);
            return;
        }
        List<UnRegistryValidator> unRegistryValidators = SpringBeanUtils.getBeans((ApplicationContext)pluginApplicationContext, UnRegistryValidator.class);
        Iterator<UnRegistryValidator> iterator = unRegistryValidators.iterator();
        if (iterator.hasNext()) {
            UnRegistryValidator unRegistryValidator = iterator.next();
            UnRegistryValidator.Result result = unRegistryValidator.verify();
            if (result.isVerify()) {
                return;
            }
            String message = result.getMessage();
            if (StringUtils.isNullOrEmpty((String)message)) {
                message = "Plugin [" + pluginId + "] Stop or Uninstall be banned";
            }
            throw new Exception(message);
        }
    }
}

