/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.listener;

import com.gitee.starblues.utils.SpringBeanUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.pf4j.PluginStateListener;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class PluginStateListenerFactory {
    private final List<PluginStateListener> listeners = new ArrayList<PluginStateListener>();
    private final List<Class> listenerClasses = new ArrayList<Class>();

    public void addStateListener(PluginStateListener pluginStateListener) {
        if (pluginStateListener == null) {
            return;
        }
        this.listeners.add(pluginStateListener);
    }

    public <T extends PluginStateListener> void addStateListener(Class<T> pluginStateListenerClass) {
        if (pluginStateListenerClass == null) {
            return;
        }
        this.listenerClasses.add(pluginStateListenerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PluginStateListener> List<PluginStateListener> buildListenerClass(GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return this.listeners;
        }
        List<Class> list = this.listenerClasses;
        synchronized (list) {
            if (this.listenerClasses.isEmpty()) {
                return this.listeners;
            }
            List<PluginStateListener> pluginListeners = SpringBeanUtils.getBeans((ApplicationContext)applicationContext, PluginStateListener.class);
            if (pluginListeners.isEmpty()) {
                pluginListeners = new ArrayList<PluginStateListener>();
            }
            for (Class listenerClass : this.listenerClasses) {
                applicationContext.registerBeanDefinition(listenerClass.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((Class)listenerClass).getBeanDefinition());
                PluginStateListener bean = (PluginStateListener)applicationContext.getBean(listenerClass);
                pluginListeners.add(bean);
            }
            for (PluginStateListener pluginListener : pluginListeners) {
                boolean find = false;
                for (PluginStateListener listener : this.listeners) {
                    if (!Objects.equals(listener, pluginListener)) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                this.listeners.add(pluginListener);
            }
            this.listenerClasses.clear();
        }
        return this.listeners;
    }
}

