/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.integration.application;

import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.integration.application.AbstractPluginApplication;
import com.gitee.starblues.integration.listener.PluginInitializerListener;
import com.gitee.starblues.integration.operator.DefaultPluginOperator;
import com.gitee.starblues.integration.operator.PluginOperator;
import com.gitee.starblues.integration.operator.PluginOperatorWrapper;
import com.gitee.starblues.integration.pf4j.DefaultPf4jFactory;
import com.gitee.starblues.integration.pf4j.Pf4jFactory;
import com.gitee.starblues.integration.user.DefaultPluginUser;
import com.gitee.starblues.integration.user.PluginUser;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pf4j.PluginManager;
import org.pf4j.PluginStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ObjectUtils;

public class DefaultPluginApplication
extends AbstractPluginApplication {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Pf4jFactory integrationFactory;
    private PluginUser pluginUser;
    private PluginOperator pluginOperator;
    private final AtomicBoolean beInitialized = new AtomicBoolean(false);

    public DefaultPluginApplication() {
    }

    public DefaultPluginApplication(Pf4jFactory integrationFactory) {
        this.integrationFactory = integrationFactory;
    }

    @Override
    public synchronized void initialize(ApplicationContext applicationContext, PluginInitializerListener listener) {
        Objects.requireNonNull(applicationContext, "ApplicationContext can't be null");
        if (this.beInitialized.get()) {
            throw new RuntimeException("Plugin has been initialized");
        }
        IntegrationConfiguration configuration = this.getConfiguration(applicationContext);
        if (this.integrationFactory == null) {
            this.integrationFactory = new DefaultPf4jFactory(configuration);
        }
        PluginManager pluginManager = this.integrationFactory.getPluginManager();
        this.addPf4jStateListener(pluginManager, applicationContext);
        this.pluginUser = this.createPluginUser(applicationContext, pluginManager);
        this.pluginOperator = this.createPluginOperator(applicationContext, pluginManager, configuration);
        try {
            this.setBeanFactory(applicationContext);
            this.pluginOperator.initPlugins(listener);
            this.beInitialized.set(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PluginUser createPluginUser(ApplicationContext applicationContext, PluginManager pluginManager) {
        return new DefaultPluginUser(applicationContext, pluginManager);
    }

    protected PluginOperator createPluginOperator(ApplicationContext applicationContext, PluginManager pluginManager, IntegrationConfiguration configuration) {
        DefaultPluginOperator pluginOperator = new DefaultPluginOperator(applicationContext, configuration, pluginManager, this.listenerFactory);
        return new PluginOperatorWrapper(pluginOperator, configuration);
    }

    @Override
    public PluginOperator getPluginOperator() {
        this.assertInjected();
        return this.pluginOperator;
    }

    @Override
    public PluginUser getPluginUser() {
        this.assertInjected();
        return this.pluginUser;
    }

    private void addPf4jStateListener(PluginManager pluginManager, ApplicationContext applicationContext) {
        List<PluginStateListener> pluginStateListeners = this.pluginStateListenerFactory.buildListenerClass((GenericApplicationContext)applicationContext);
        if (ObjectUtils.isEmpty(pluginStateListeners)) {
            return;
        }
        for (PluginStateListener pluginStateListener : pluginStateListeners) {
            pluginManager.addPluginStateListener(pluginStateListener);
        }
    }

    private void setBeanFactory(ApplicationContext applicationContext) {
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)applicationContext;
        DefaultListableBeanFactory defaultListableBeanFactory = genericApplicationContext.getDefaultListableBeanFactory();
        defaultListableBeanFactory.registerSingleton(this.pluginOperator.getClass().getName(), (Object)this.pluginOperator);
        defaultListableBeanFactory.registerSingleton(this.pluginUser.getClass().getName(), (Object)this.pluginUser);
    }

    private void assertInjected() {
        if (this.pluginUser == null) {
            throw new RuntimeException("PluginUser is null, Please check whether the DefaultPluginApplication is injected");
        }
        if (this.pluginOperator == null) {
            throw new RuntimeException("PluginOperator is null, Please check whether the DefaultPluginApplication is injected");
        }
    }
}

