/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post.bean;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.utils.ClassUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

public class PluginWebSocketProcessor
implements PluginPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(PluginWebSocketProcessor.class);
    public static final String KEY = "PluginWsConfigProcessor";
    private static final String WEB_SOCKET_PATH = "WEB_SOCKET_PATH";
    private final ApplicationContext applicationContext;

    public PluginWebSocketProcessor(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        ServerContainer serverContainer = this.getServerContainer();
        if (serverContainer == null) {
            return;
        }
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            HashMap webSocketPathMap = new HashMap();
            List<Class<?>> websocketClasses = pluginRegistryInfo.getGroupClasses("websocket");
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            websocketClasses.forEach(websocketClass -> {
                UriTemplate uriTemplate;
                ServerEndpoint serverEndpoint = websocketClass.getDeclaredAnnotation(ServerEndpoint.class);
                if (serverEndpoint == null) {
                    log.warn("WebSocket class {} doesn't has annotation {}", (Object)websocketClass.getName(), (Object)ServerEndpoint.class.getName());
                    return;
                }
                String sourcePath = serverEndpoint.value();
                if (StringUtils.isNullOrEmpty((String)sourcePath)) {
                    return;
                }
                String processPath = sourcePath;
                if (!processPath.startsWith("/")) {
                    processPath = "/".concat(processPath);
                }
                try {
                    uriTemplate = new UriTemplate(processPath);
                }
                catch (DeploymentException e) {
                    log.error("Websocket path validate failed.", (Throwable)e);
                    return;
                }
                String newWebsocketPath = "/".concat(pluginId).concat(processPath);
                String newWebsocketTemplatePath = "/".concat(pluginId).concat(uriTemplate.getPath());
                Map<String, Object> annotationsUpdater = null;
                try {
                    annotationsUpdater = ClassUtils.getAnnotationsUpdater(serverEndpoint);
                }
                catch (Exception e) {
                    log.error("Process and update websocket path '{}' annotation exception.", (Object)sourcePath, (Object)e);
                    return;
                }
                try {
                    annotationsUpdater.put("value", newWebsocketPath);
                    serverContainer.addEndpoint(websocketClass);
                    webSocketPathMap.put(newWebsocketPath, newWebsocketTemplatePath);
                    log.info("Succeed to create websocket service for path {}", (Object)newWebsocketPath);
                }
                catch (Exception e) {
                    log.error("Create websocket service for websocket class " + websocketClass.getName() + " failed.", (Throwable)e);
                }
                finally {
                    annotationsUpdater.put("value", sourcePath);
                }
            });
            pluginRegistryInfo.addExtension(WEB_SOCKET_PATH, webSocketPathMap);
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        ServerContainer serverContainer = this.getServerContainer();
        if (serverContainer == null) {
            log.warn("Not found ServerContainer, So websocket can't used!");
            return;
        }
        Map configExactMatchMap = (Map)ClassUtils.getReflectionField(serverContainer, "configExactMatchMap");
        Map configTemplateMatchMap = (Map)ClassUtils.getReflectionField(serverContainer, "configTemplateMatchMap");
        Map endpointSessionMap = (Map)ClassUtils.getReflectionField(serverContainer, "endpointSessionMap");
        Map sessions = (Map)ClassUtils.getReflectionField(serverContainer, "sessions");
        pluginRegistryInfos.forEach(pluginRegistryInfo -> {
            Map webSocketPathMap = (Map)pluginRegistryInfo.getExtension(WEB_SOCKET_PATH);
            webSocketPathMap.forEach((webSocketPath, newWebsocketTemplatePath) -> {
                configExactMatchMap.remove(webSocketPath);
                log.debug("Removed websocket config for path {}", webSocketPath);
                configTemplateMatchMap.forEach((key, value) -> value.remove(newWebsocketTemplatePath));
                endpointSessionMap.remove(webSocketPath);
                log.debug("Removed websocket session for path {}", webSocketPath);
                for (Map.Entry entry : sessions.entrySet()) {
                    Session session = (Session)entry.getKey();
                    try {
                        if (!this.closeSession(session, (String)webSocketPath)) continue;
                        sessions.remove(session);
                        log.debug("Removed websocket session {} for path {}", (Object)session.getId(), webSocketPath);
                    }
                    catch (Exception e) {
                        log.debug("Close websocket session {} for path {} failure", new Object[]{session.getId(), webSocketPath, e});
                    }
                }
                log.info("Remove websocket for path {} success.", webSocketPath);
            });
        });
    }

    private ServerContainer getServerContainer() {
        try {
            this.applicationContext.getBean(ServerEndpointExporter.class);
        }
        catch (BeansException e) {
            log.debug("The required bean of {} not found, if you want to use plugin websocket, please create it.", (Object)ServerEndpointExporter.class.getName());
            return null;
        }
        if (!(this.applicationContext instanceof WebApplicationContext)) {
            return null;
        }
        WebApplicationContext webApplicationContext = (WebApplicationContext)this.applicationContext;
        ServletContext servletContext = webApplicationContext.getServletContext();
        if (servletContext == null) {
            log.warn("Servlet context is null.");
            return null;
        }
        Object obj = servletContext.getAttribute("javax.websocket.server.ServerContainer");
        if (!(obj instanceof ServerContainer)) {
            return null;
        }
        return (ServerContainer)obj;
    }

    private boolean closeSession(Session session, String websocketPath) throws Exception {
        EndpointConfig endpointConfig = (EndpointConfig)ClassUtils.getReflectionField(session, "endpointConfig");
        ServerEndpointConfig perEndpointConfig = (ServerEndpointConfig)ClassUtils.getReflectionField(endpointConfig, "perEndpointConfig");
        String path = (String)ClassUtils.getReflectionField(perEndpointConfig, "path");
        if (path.equals(websocketPath)) {
            session.close();
            log.info("Closed websocket session {} for path {}", (Object)session.getId(), (Object)websocketPath);
            return true;
        }
        return false;
    }

    private static class UriTemplate {
        private final Map<String, Integer> paramMap = new ConcurrentHashMap<String, Integer>();
        private final String path;

        private UriTemplate(String path) throws DeploymentException {
            if (path == null || path.length() == 0 || !path.startsWith("/") || path.contains("/../") || path.contains("/./") || path.contains("//")) {
                throw new DeploymentException(String.format("The path [%s] is not valid.", path));
            }
            StringBuilder normalized = new StringBuilder(path.length());
            HashSet<String> paramNames = new HashSet<String>();
            String[] segments = path.split("/", -1);
            int paramCount = 0;
            for (int i = 0; i < segments.length; ++i) {
                String segment = segments[i];
                if (segment.length() == 0) {
                    if (i == 0 || i == segments.length - 1 && paramCount == 0) continue;
                    throw new DeploymentException(String.format("The path [%s] contains one or more empty segments which is not permitted", path));
                }
                normalized.append('/');
                if (segment.startsWith("{") && segment.endsWith("}")) {
                    segment = segment.substring(1, segment.length() - 1);
                    normalized.append('{');
                    normalized.append(paramCount++);
                    normalized.append('}');
                    if (!paramNames.add(segment)) {
                        throw new DeploymentException(String.format("The parameter [%s] appears more than once in the path which is not permitted", segment));
                    }
                    this.paramMap.put(segment, paramCount - 1);
                    continue;
                }
                if (segment.contains("{") || segment.contains("}")) {
                    throw new DeploymentException(String.format("The segment [%s] is not valid in the provided path [%s]", segment, path));
                }
                normalized.append(segment);
            }
            this.path = normalized.toString();
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, Integer> getParamMap() {
            return this.paramMap;
        }
    }
}

