/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post.bean;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.pipe.bean.InvokeBeanRegistrar;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class PluginInvokePostProcessor
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public PluginInvokePostProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
    }

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            try {
                Set supperBeanNames = (Set)pluginRegistryInfo.getExtension("Invoke_Supplier");
                if (supperBeanNames == null || supperBeanNames.isEmpty()) continue;
                GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
                for (String supperBeanName : supperBeanNames) {
                    if (!pluginApplicationContext.containsBean(supperBeanName)) continue;
                    Object bean = pluginApplicationContext.getBean(supperBeanName);
                    InvokeBeanRegistrar.addSupper(pluginId, supperBeanName, this.getTarget(bean));
                }
            }
            catch (Exception e) {
                this.log.error("Process plugin '{}' supper bean exception.", (Object)pluginId, (Object)e);
            }
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
    }

    public Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return this.getJdkDynamicProxyTargetObject(proxy);
        }
        return this.getCglibProxyTargetObject(proxy);
    }

    private Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
    }

    private Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        return ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
    }
}

