/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.post.bean;

import com.gitee.starblues.extension.ExtensionFactory;
import com.gitee.starblues.extension.PluginControllerProcessorExtend;
import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.process.post.PluginPostProcessor;
import com.gitee.starblues.factory.process.post.bean.model.ControllerWrapper;
import com.gitee.starblues.integration.IntegrationConfiguration;
import com.gitee.starblues.utils.ClassUtils;
import com.gitee.starblues.utils.CommonUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class PluginControllerPostProcessor
implements PluginPostProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String KEY = "PluginControllerPostProcessor";
    private final RequestMappingHandlerMapping requestMappingHandlerMapping;
    private final IntegrationConfiguration configuration;
    private final List<PluginControllerProcessorExtend> pluginControllerProcessors;

    public PluginControllerPostProcessor(ApplicationContext mainApplicationContext) {
        Objects.requireNonNull(mainApplicationContext);
        this.requestMappingHandlerMapping = (RequestMappingHandlerMapping)mainApplicationContext.getBean(RequestMappingHandlerMapping.class);
        this.configuration = (IntegrationConfiguration)mainApplicationContext.getBean(IntegrationConfiguration.class);
        this.pluginControllerProcessors = ExtensionFactory.getPluginControllerProcessorExtend(mainApplicationContext);
    }

    @Override
    public void initialize() throws Exception {
        this.resolveProcessExtend(extend -> {
            try {
                extend.initialize();
            }
            catch (Exception e) {
                this.log.error("'{}' initialize error", (Object)extend.getClass().getName(), (Object)e);
            }
        });
    }

    @Override
    public void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            List<Class<?>> groupClasses = pluginRegistryInfo.getGroupClasses("spring_controller");
            if (groupClasses == null || groupClasses.isEmpty()) continue;
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            ArrayList<ControllerWrapper> controllerBeanWrappers = new ArrayList<ControllerWrapper>();
            for (Class<?> groupClass : groupClasses) {
                if (groupClass == null) continue;
                try {
                    ControllerWrapper controllerBeanWrapper = this.registry(pluginRegistryInfo, groupClass);
                    controllerBeanWrappers.add(controllerBeanWrapper);
                }
                catch (Exception e) {
                    pluginRegistryInfo.addProcessorInfo(this.getKey(pluginRegistryInfo), controllerBeanWrappers);
                    throw e;
                }
            }
            this.resolveProcessExtend(extend -> {
                try {
                    extend.registry(pluginId, controllerBeanWrappers);
                }
                catch (Exception e) {
                    this.log.error("'{}' process plugin[{}] error in registry", new Object[]{extend.getClass().getName(), pluginId, e});
                }
            });
            pluginRegistryInfo.addProcessorInfo(this.getKey(pluginRegistryInfo), controllerBeanWrappers);
        }
    }

    @Override
    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            List controllerBeanWrappers = (List)pluginRegistryInfo.getProcessorInfo(this.getKey(pluginRegistryInfo));
            if (controllerBeanWrappers == null || controllerBeanWrappers.isEmpty()) continue;
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            for (ControllerWrapper controllerBeanWrapper : controllerBeanWrappers) {
                if (controllerBeanWrapper == null) continue;
                this.unregister(controllerBeanWrapper);
            }
            this.resolveProcessExtend(extend -> {
                try {
                    extend.unRegistry(pluginId, controllerBeanWrappers);
                }
                catch (Exception e) {
                    this.log.error("'{}' process plugin[{}] error in unRegistry", new Object[]{extend.getClass().getName(), pluginId, e});
                }
            });
        }
    }

    private ControllerWrapper registry(PluginRegistryInfo pluginRegistryInfo, Class<?> aClass) throws Exception {
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        Object object = pluginApplicationContext.getBean(aClass);
        ControllerWrapper controllerBeanWrapper = new ControllerWrapper();
        this.setPathPrefix(pluginId, aClass);
        Method getMappingForMethod = ReflectionUtils.findMethod(RequestMappingHandlerMapping.class, (String)"getMappingForMethod", (Class[])new Class[]{Method.class, Class.class});
        getMappingForMethod.setAccessible(true);
        Method[] methods = aClass.getMethods();
        HashSet<RequestMappingInfo> requestMappingInfos = new HashSet<RequestMappingInfo>();
        for (Method method : methods) {
            if (!this.isHaveRequestMapping(method)) continue;
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)getMappingForMethod.invoke((Object)this.requestMappingHandlerMapping, method, aClass);
            this.requestMappingHandlerMapping.registerMapping((Object)requestMappingInfo, object, method);
            requestMappingInfos.add(requestMappingInfo);
        }
        controllerBeanWrapper.setRequestMappingInfos(requestMappingInfos);
        controllerBeanWrapper.setBeanClass(aClass);
        return controllerBeanWrapper;
    }

    private void unregister(ControllerWrapper controllerBeanWrapper) {
        Set<RequestMappingInfo> requestMappingInfos = controllerBeanWrapper.getRequestMappingInfos();
        if (requestMappingInfos != null && !requestMappingInfos.isEmpty()) {
            for (RequestMappingInfo requestMappingInfo : requestMappingInfos) {
                this.requestMappingHandlerMapping.unregisterMapping((Object)requestMappingInfo);
            }
        }
    }

    private void resolveProcessExtend(Consumer<PluginControllerProcessorExtend> extendConsumer) {
        if (this.pluginControllerProcessors == null || this.pluginControllerProcessors.isEmpty()) {
            return;
        }
        for (PluginControllerProcessorExtend pluginControllerProcessor : this.pluginControllerProcessors) {
            extendConsumer.accept(pluginControllerProcessor);
        }
    }

    private String getKey(PluginRegistryInfo registerPluginInfo) {
        return "PluginControllerPostProcessor_" + registerPluginInfo.getPluginWrapper().getPluginId();
    }

    private void setPathPrefix(String pluginId, Class<?> aClass) {
        RequestMapping requestMapping = aClass.getAnnotation(RequestMapping.class);
        if (requestMapping == null) {
            return;
        }
        String pathPrefix = CommonUtils.getPluginRestPrefix(this.configuration, pluginId);
        if (StringUtils.isNullOrEmpty((String)pathPrefix)) {
            return;
        }
        HashSet<String> definePaths = new HashSet<String>();
        definePaths.addAll(Arrays.asList(requestMapping.path()));
        definePaths.addAll(Arrays.asList(requestMapping.value()));
        try {
            Map<String, Object> memberValues = ClassUtils.getAnnotationsUpdater(requestMapping);
            String[] newPath = new String[definePaths.size()];
            int i = 0;
            for (String definePath : definePaths) {
                if (definePath.contains(pathPrefix)) {
                    newPath[i++] = definePath;
                    continue;
                }
                newPath[i++] = CommonUtils.restJoiningPath(pathPrefix, definePath);
            }
            if (newPath.length == 0) {
                newPath = new String[]{pathPrefix};
            }
            memberValues.put("path", newPath);
            memberValues.put("value", new String[0]);
        }
        catch (Exception e) {
            this.log.error("Define Plugin RestController pathPrefix error : {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private boolean isHaveRequestMapping(Method method) {
        return AnnotationUtils.findAnnotation((Method)method, RequestMapping.class) != null;
    }
}

