/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.interceptor;

import com.gitee.starblues.factory.process.pipe.interceptor.PluginInterceptorRegistry;
import com.gitee.starblues.utils.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pf4j.util.StringUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class PluginInterceptorRegistration {
    private final HandlerInterceptor interceptor;
    private final PluginInterceptorRegistry.Type type;
    private final String pluginRestApiPrefix;
    private final List<String> includePatterns = new ArrayList<String>();
    private final List<String> excludePatterns = new ArrayList<String>();
    @Nullable
    private PathMatcher pathMatcher;
    private int order = 0;

    public PluginInterceptorRegistration(HandlerInterceptor interceptor, PluginInterceptorRegistry.Type type, String pluginRestApiPrefix) {
        this.interceptor = interceptor;
        this.type = type;
        String apiPrefix = null;
        apiPrefix = pluginRestApiPrefix.startsWith("/") ? pluginRestApiPrefix : "/" + pluginRestApiPrefix;
        if (apiPrefix.endsWith("/")) {
            apiPrefix = apiPrefix.substring(0, apiPrefix.lastIndexOf("/"));
        }
        this.pluginRestApiPrefix = apiPrefix;
    }

    public PluginInterceptorRegistration addPathPatterns(String ... patterns) {
        if (this.type == PluginInterceptorRegistry.Type.GLOBAL) {
            this.includePatterns.addAll(Arrays.asList(patterns));
        }
        for (String pattern : patterns) {
            if (StringUtils.isNullOrEmpty((String)pattern)) continue;
            this.includePatterns.add(CommonUtils.joiningPath(this.pluginRestApiPrefix, pattern));
        }
        return this;
    }

    public PluginInterceptorRegistration excludePathPatterns(String ... patterns) {
        if (this.type == PluginInterceptorRegistry.Type.GLOBAL) {
            this.excludePatterns.addAll(Arrays.asList(patterns));
        }
        for (String pattern : patterns) {
            if (StringUtils.isNullOrEmpty((String)pattern)) continue;
            this.excludePatterns.add(CommonUtils.joiningPath(this.pluginRestApiPrefix, pattern));
        }
        return this;
    }

    public PluginInterceptorRegistration pathMatcher(PathMatcher pathMatcher) {
        this.pathMatcher = pathMatcher;
        return this;
    }

    public PluginInterceptorRegistration order(int order) {
        this.order = order;
        return this;
    }

    protected int getOrder() {
        return this.order;
    }

    protected Object getInterceptor() {
        if (this.type == PluginInterceptorRegistry.Type.PLUGIN && this.includePatterns.isEmpty()) {
            this.includePatterns.add(CommonUtils.joiningPath(this.pluginRestApiPrefix, "/**"));
        }
        if (this.includePatterns.isEmpty() && this.excludePatterns.isEmpty()) {
            return this.interceptor;
        }
        String[] include = this.includePatterns.toArray(new String[0]);
        String[] exclude = this.excludePatterns.toArray(new String[0]);
        MappedInterceptor mappedInterceptor = new MappedInterceptor(include, exclude, this.interceptor);
        if (this.pathMatcher != null) {
            mappedInterceptor.setPathMatcher(this.pathMatcher);
        }
        return mappedInterceptor;
    }
}

