/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.extract;

import com.gitee.starblues.annotation.Extract;
import com.gitee.starblues.factory.process.pipe.extract.ExtractCoordinate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.ClassUtils;

public class ExtractFactory {
    public static final String MAIN_EXTRACT_KEY = ExtractFactory.class.getName() + UUID.randomUUID().toString();
    private final Map<String, Map<ExtractCoordinate, ExtractWrapper>> extractMap = new ConcurrentHashMap<String, Map<ExtractCoordinate, ExtractWrapper>>();
    private static final ExtractFactory EXTRACT_FACTORY = new ExtractFactory();

    private ExtractFactory() {
    }

    public static ExtractFactory getInstant() {
        return EXTRACT_FACTORY;
    }

    void addOfMain(Object extractObject) {
        this.add(MAIN_EXTRACT_KEY, extractObject);
    }

    void add(String pluginId, Object extractObject) {
        if (extractObject == null) {
            return;
        }
        Extract extract = this.getExtract(extractObject);
        if (extract == null) {
            return;
        }
        Map extractObjects = this.extractMap.computeIfAbsent(pluginId, k -> new ConcurrentHashMap());
        ExtractWrapper extractWrapper = new ExtractWrapper(extractObject, extract.order());
        extractObjects.put(new ExtractCoordinate(extract, extractObject.getClass()), extractWrapper);
    }

    void remove(String pluginId) {
        this.extractMap.remove(pluginId);
    }

    public <T> T getExtractByCoordinate(ExtractCoordinate coordinate) {
        Objects.requireNonNull(coordinate, "ExtractCoordinate can't be null");
        int currentOrder = Integer.MIN_VALUE;
        Object currentObject = null;
        for (Map<ExtractCoordinate, ExtractWrapper> value : this.extractMap.values()) {
            int order;
            ExtractWrapper extractWrapper = value.get(coordinate);
            if (extractWrapper == null || (order = extractWrapper.getOrder()) <= currentOrder) continue;
            currentObject = extractWrapper.getObject();
            currentOrder = order;
        }
        if (currentObject != null) {
            return (T)currentObject;
        }
        throw new RuntimeException("Not found " + coordinate);
    }

    public <T> T getExtractByCoordinate(String pluginId, ExtractCoordinate coordinate) {
        Objects.requireNonNull(coordinate, "ExtractCoordinate can't be null");
        Map<ExtractCoordinate, ExtractWrapper> extractCoordinates = this.extractMap.get(pluginId);
        if (extractCoordinates == null) {
            throw new RuntimeException("Not found " + coordinate + " from plugin '" + pluginId + "'");
        }
        ExtractWrapper extracts = extractCoordinates.get(coordinate);
        if (extracts == null) {
            throw new RuntimeException("Not found " + coordinate + " from plugin '" + pluginId + "'");
        }
        return (T)extracts;
    }

    public <T> T getExtractByCoordinateOfMain(ExtractCoordinate coordinate) {
        Objects.requireNonNull(coordinate, "ExtractCoordinate can't be null");
        Map<ExtractCoordinate, ExtractWrapper> extractCoordinates = this.extractMap.get(MAIN_EXTRACT_KEY);
        if (extractCoordinates == null) {
            throw new RuntimeException("Not found " + coordinate + " from main");
        }
        ExtractWrapper extractWrapper = extractCoordinates.get(coordinate);
        if (extractWrapper == null) {
            throw new RuntimeException("Not found " + coordinate + " from main");
        }
        return (T)extractWrapper.getObject();
    }

    public <T> List<T> getExtractByInterClass(Class<T> interfaceClass) {
        if (interfaceClass == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> extracts = new ArrayList<Object>();
        for (Map<ExtractCoordinate, ExtractWrapper> value : this.extractMap.values()) {
            for (ExtractWrapper extractWrapper : value.values()) {
                Set allInterfacesForClassAsSet = ClassUtils.getAllInterfacesForClassAsSet(extractWrapper.getObject().getClass());
                if (!allInterfacesForClassAsSet.contains(interfaceClass)) continue;
                extracts.add(extractWrapper.getObject());
            }
        }
        return extracts;
    }

    public <T> List<T> getExtractByInterClass(String pluginId, Class<T> interfaceClass) {
        if (interfaceClass == null) {
            return Collections.emptyList();
        }
        ArrayList<ExtractWrapper> extracts = new ArrayList<ExtractWrapper>();
        Map<ExtractCoordinate, ExtractWrapper> extractCoordinateObjectMap = this.extractMap.get(pluginId);
        if (extractCoordinateObjectMap == null || extractCoordinateObjectMap.isEmpty()) {
            return Collections.emptyList();
        }
        for (ExtractWrapper o : extractCoordinateObjectMap.values()) {
            Set allInterfacesForClassAsSet = ClassUtils.getAllInterfacesForClassAsSet(o.getClass());
            if (!allInterfacesForClassAsSet.contains(interfaceClass)) continue;
            extracts.add(o);
        }
        return extracts;
    }

    public <T> List<T> getExtractByInterClassOfMain(Class<T> interfaceClass) {
        return this.getExtractByInterClass(MAIN_EXTRACT_KEY, interfaceClass);
    }

    public Map<String, Set<ExtractCoordinate>> getExtractCoordinates() {
        HashMap<String, Set<ExtractCoordinate>> extractCoordinateMap = new HashMap<String, Set<ExtractCoordinate>>(this.extractMap.size());
        this.extractMap.forEach((k, v) -> {
            HashSet extractCoordinates = new HashSet(v.size());
            extractCoordinates.addAll(v.keySet());
            extractCoordinateMap.put((String)k, extractCoordinates);
        });
        return extractCoordinateMap;
    }

    private Extract getExtract(Object extractObject) {
        Extract annotation = extractObject.getClass().getAnnotation(Extract.class);
        if (annotation == null) {
            return null;
        }
        return annotation;
    }

    private class ExtractWrapper {
        private final Object object;
        private final int order;

        public ExtractWrapper(Object object, int order) {
            this.object = object;
            this.order = order;
        }

        public Object getObject() {
            return this.object;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

