/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.extract;

import com.gitee.starblues.annotation.Extract;
import java.util.Objects;
import org.pf4j.util.StringUtils;

public class ExtractCoordinate {
    private final String bus;
    private final String scene;
    private final String useCase;
    private final Class<?> extractClass;

    ExtractCoordinate(String bus, String scene, String useCase, Class<?> extractClass) {
        this.bus = bus;
        this.scene = scene;
        this.useCase = useCase;
        this.extractClass = extractClass;
    }

    ExtractCoordinate(Extract extract, Class<?> extractClass) {
        this.bus = extract.bus();
        this.scene = extract.scene();
        this.useCase = extract.useCase();
        this.extractClass = extractClass;
    }

    public static ExtractCoordinate build(String bus) {
        return new ExtractCoordinate(bus, null, null, null);
    }

    public static ExtractCoordinate build(String bus, String scene) {
        return new ExtractCoordinate(bus, scene, null, null);
    }

    public static ExtractCoordinate build(String bus, String scene, String useCase) {
        return new ExtractCoordinate(bus, scene, useCase, null);
    }

    public String getBus() {
        return this.bus;
    }

    public String getScene() {
        return this.scene;
    }

    public String getUseCase() {
        return this.useCase;
    }

    public Class<?> getExtractClass() {
        return this.extractClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtractCoordinate)) {
            return false;
        }
        ExtractCoordinate that = (ExtractCoordinate)o;
        if (StringUtils.isNotNullOrEmpty((String)this.bus) && StringUtils.isNotNullOrEmpty((String)this.scene) && StringUtils.isNotNullOrEmpty((String)this.useCase)) {
            return Objects.equals(this.getBus(), that.getBus()) && Objects.equals(this.getScene(), that.getScene()) && Objects.equals(this.getUseCase(), that.getUseCase());
        }
        if (StringUtils.isNotNullOrEmpty((String)this.bus) && StringUtils.isNotNullOrEmpty((String)this.scene)) {
            return Objects.equals(this.getBus(), that.getBus()) && Objects.equals(this.getScene(), that.getScene());
        }
        if (StringUtils.isNotNullOrEmpty((String)this.bus)) {
            return Objects.equals(this.getBus(), that.getBus());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getBus(), this.getScene(), this.getUseCase());
    }

    public String toString() {
        return "ExtractCoordinate{bus='" + this.bus + '\'' + ", scene='" + this.scene + '\'' + ", useCase='" + this.useCase + '\'' + '}';
    }
}

