/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean.configuration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.gitee.starblues.factory.process.pipe.bean.configuration.AbstractConfigurationParser;
import com.gitee.starblues.integration.IntegrationConfiguration;
import java.io.InputStream;
import org.springframework.core.io.Resource;

public class YamlConfigurationParser
extends AbstractConfigurationParser {
    private final YAMLFactory yamlFactory = new YAMLFactory();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public YamlConfigurationParser(IntegrationConfiguration configuration) {
        super(configuration);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object parse(Resource resource, Class<?> pluginConfigClass) throws Exception {
        InputStream inputStream = null;
        YAMLParser yamlParser = null;
        TreeTraversingParser treeTraversingParser = null;
        try {
            inputStream = resource.getInputStream();
            yamlParser = this.yamlFactory.createParser(inputStream);
            JsonNode node = (JsonNode)this.objectMapper.readTree((JsonParser)yamlParser);
            if (node == null) {
                Object obj = pluginConfigClass.newInstance();
                return obj;
            }
            treeTraversingParser = new TreeTraversingParser(node);
            Object object = this.objectMapper.readValue((JsonParser)treeTraversingParser, pluginConfigClass);
            return object;
        }
        finally {
            if (treeTraversingParser != null) {
                treeTraversingParser.close();
            }
            if (yamlParser != null) {
                yamlParser.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

