/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.factory.process.pipe.bean;

import com.gitee.starblues.factory.PluginRegistryInfo;
import com.gitee.starblues.factory.SpringBeanRegister;
import com.gitee.starblues.factory.process.pipe.bean.PluginBeanRegistrar;
import java.util.List;

public class BasicBeanRegistrar
implements PluginBeanRegistrar {
    @Override
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List<Class<?>> springComponents = pluginRegistryInfo.getGroupClasses("spring_component");
        List<Class<?>> springRepository = pluginRegistryInfo.getGroupClasses("spring_repository");
        List<Class<?>> oneselfListener = pluginRegistryInfo.getGroupClasses("oneself_listener");
        this.register(pluginRegistryInfo, springComponents);
        this.register(pluginRegistryInfo, springRepository);
        this.register(pluginRegistryInfo, oneselfListener);
    }

    private void register(PluginRegistryInfo pluginRegistryInfo, List<Class<?>> classes) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        for (Class<?> aClass : classes) {
            if (aClass == null) continue;
            springBeanRegister.register(aClass);
        }
    }
}

