/*
 * Decompiled with CFR 0.152.
 */
package io.zq.utils;

import com.sun.jna.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.util.FileItemHeadersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToPDFUtils {
    private static Logger logger = LoggerFactory.getLogger(HtmlToPDFUtils.class);
    private static File wkHomeDir = Platform.isLinux() ? new File("/wkHome") : new File("C:\\wkHome");
    private static File wkTmpDir = Platform.isLinux() ? new File("/wkTemp") : new File("C:\\wkTemp");
    private static File simsunFontDir = Platform.isLinux() ? new File("/usr/share/fonts/chinese/TrueType") : new File("C:\\Windows\\Fonts");
    private static File wktool;
    private static File simsunFont;
    private static boolean canUse;
    private static boolean able;

    public static boolean forceInit() {
        Long initc = 0L;
        if (!wkHomeDir.exists()) {
            able = wkHomeDir.mkdirs();
        }
        initc = initc + 1L;
        logger.info("{},check wkHomeDir ,result:{}", (Object)initc, (Object)able);
        if (!wkTmpDir.exists()) {
            able = wkTmpDir.mkdirs();
        }
        initc = initc + 1L;
        logger.info("{},check wkTmpDir ,result:{}", (Object)initc, (Object)able);
        if (!simsunFontDir.exists()) {
            able = simsunFontDir.mkdirs();
        }
        initc = initc + 1L;
        logger.info("{},check simsunFontDir ,result:{}", (Object)initc, (Object)able);
        InputStream wkhtmltoxAsStream = null;
        InputStream simsunAsStream = null;
        if (able) {
            wkhtmltoxAsStream = Platform.isLinux() ? HtmlToPDFUtils.class.getResourceAsStream("/wkhtmltox") : HtmlToPDFUtils.class.getResourceAsStream("/wkhtmltopdf.exe");
            simsunAsStream = HtmlToPDFUtils.class.getResourceAsStream("/simsun.ttc");
        }
        if (null == wkhtmltoxAsStream || simsunAsStream == null) {
            Object[] objectArray = new Object[3];
            initc = initc + 1L;
            objectArray[0] = initc;
            objectArray[1] = null == wkhtmltoxAsStream;
            objectArray[2] = simsunAsStream == null;
            logger.error("{},load wkhtmltoxAsStream :{},load simsunAsStream:{}", objectArray);
            able = false;
        }
        initc = initc + 1L;
        logger.info("{},load wktool and font source ,result:{}", (Object)initc, (Object)able);
        if (able) {
            File font = new File(simsunFontDir, "simsun.ttc");
            File wk = new File(wkHomeDir, Platform.isLinux() ? "wkhtmltox" : "wkhtmltopdf.exe");
            try {
                if (!font.exists()) {
                    able = 1L < Files.copy(simsunAsStream, font.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                Object[] objectArray = new Object[3];
                initc = initc + 1L;
                objectArray[0] = initc;
                objectArray[1] = font.toPath();
                objectArray[2] = able;
                logger.info("{},copy font source to {},result:{}", objectArray);
                if (!wk.exists()) {
                    able = 1L < Files.copy(wkhtmltoxAsStream, wk.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                Object[] objectArray2 = new Object[3];
                initc = initc + 1L;
                objectArray2[0] = initc;
                objectArray2[1] = font.toPath();
                objectArray2[2] = able;
                logger.info("{},copy wktools source to {},result:{}", objectArray2);
                if (able) {
                    wktool = wk;
                    simsunFont = font;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                able = false;
                initc = initc + 1L;
                logger.error("{}, error when copy source : {} ", (Object)initc, (Object)e.getMessage());
            }
        }
        if (able && Platform.isLinux()) {
            boolean canExe = HtmlToPDFUtils.exePermissionCheck();
            initc = initc + 1L;
            logger.info("{},check run permission,result: {}  ", (Object)initc, (Object)(canExe ? "has permission" : "no permission"));
            if (!canExe) {
                HtmlToPDFUtils.simpleExecComand("chmod +x " + wktool.getPath());
                if (!HtmlToPDFUtils.exePermissionCheck()) {
                    initc = initc + 1L;
                    logger.error("{},add permission failed", (Object)initc);
                    able = false;
                }
            }
        }
        if (able) {
            able = HtmlToPDFUtils.cleanTempDir();
        }
        if (able) {
            initc = initc + 1L;
            logger.info("{},init success!", (Object)initc);
        } else {
            initc = initc + 1L;
            logger.info("{},init failed!", (Object)initc);
            canUse = false;
        }
        return able;
    }

    public String getSimsunPath() {
        logger.info("world path:" + simsunFont.getPath());
        return simsunFont.getPath();
    }

    public static HtmlToPDFUtils build() {
        return new HtmlToPDFUtils();
    }

    private static boolean exePermissionCheck() {
        String permissionLog = HtmlToPDFUtils.simpleExecComand("ls -l " + wktool.getPath());
        return null != permissionLog && permissionLog.length() >= 10 && 'x' == permissionLog.charAt(9);
    }

    private static boolean cleanTempDir() {
        if (wkTmpDir.exists()) {
            canUse = HtmlToPDFUtils.deleteFiles(wkTmpDir) ? wkTmpDir.mkdirs() : canUse;
            logger.info("cleanTempDir,result:{} ", (Object)canUse);
        } else {
            canUse = wkTmpDir.mkdirs();
        }
        return canUse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized FileItem convertPDFFromText(String text, String name) {
        Throwable throwable;
        HtmlToPDFUtils.cleanTempDir();
        if (!canUse) {
            logger.info("tools crash,can invoke forceInit() method see reason !!!");
            return null;
        }
        File html = new File(wkTmpDir, name + ".html");
        File pdf = new File(wkTmpDir, name + ".pdf");
        try {
            throwable = null;
            try (FileWriter fileWriter = new FileWriter(html);){
                fileWriter.write(text);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            logger.error("create html file failed");
            e.printStackTrace();
            return null;
        }
        if (html.exists() && html.isFile()) {
            logger.info("exec html to  pdf \uff0cwktoolPath=>{}", (Object)wktool.getPath());
            HtmlToPDFUtils.simpleExecComand(wktool.getPath() + " " + html.getPath() + " " + pdf.getPath());
        }
        if (pdf.exists() && pdf.isFile()) {
            try {
                throwable = null;
                try (FileInputStream fileInputStream = new FileInputStream(pdf);
                     ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                    byte[] buffer = new byte[2014];
                    while (fileInputStream.read(buffer) != -1) {
                        byteArrayOutputStream.write(buffer);
                    }
                    byteArrayOutputStream.flush();
                    byte[] data = byteArrayOutputStream.toByteArray();
                    if (data.length > 0) {
                        logger.info("html to  pdf  success ");
                        SimplePDFFileItem file = new SimplePDFFileItem(pdf, data, Files.probeContentType(pdf.toPath()), "file");
                        logger.info("pdf size :{}", (Object)file.getSize());
                        SimplePDFFileItem simplePDFFileItem = file;
                        return simplePDFFileItem;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                logger.error("html to  pdf  failed");
                e.printStackTrace();
                return null;
            }
        }
        logger.info("html to  pdf  failed,no data");
        return null;
    }

    private static boolean deleteFiles(File file) {
        if (!file.exists()) {
            logger.info("del the file:{},is not exists", (Object)file.getPath());
            return false;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] subFiles = file.listFiles();
        if (null != subFiles && subFiles.length > 0) {
            Arrays.asList(subFiles).forEach(HtmlToPDFUtils::deleteFiles);
        }
        return file.delete();
    }

    private static String simpleExecComand(String cmd) {
        try {
            String line;
            String[] linux = new String[]{"/bin/sh", "-c", cmd};
            String[] windows = new String[]{"cmd", "/c", cmd};
            String[] cmdA = Platform.isLinux() ? linux : windows;
            Process process = Runtime.getRuntime().exec(cmdA);
            LineNumberReader br = new LineNumberReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                logger.info(line);
                sb.append(line).append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        canUse = true;
        able = true;
        logger.info("Tools are only  available for Windows 64 and Linux 64 platforms !!!");
        HtmlToPDFUtils.forceInit();
    }

    static class SimplePDFFileItem
    implements FileItem {
        private static final long serialVersionUID = 2237570099615271025L;
        public static final String DEFAULT_CHARSET = "ISO-8859-1";
        private String fieldName;
        private String fileName;
        private boolean isFormField;
        private byte[] cachedContent;
        private String contentType;
        private File dfosFile;
        private FileItemHeaders headers;

        public SimplePDFFileItem(File dfosFile, byte[] cachedContent, String contentType, String fieldName) {
            this.fieldName = fieldName;
            this.fileName = dfosFile.getName();
            this.isFormField = false;
            this.cachedContent = null == cachedContent || cachedContent.length < 1 ? new byte[]{} : cachedContent;
            this.contentType = contentType;
            this.dfosFile = dfosFile;
            this.headers = new FileItemHeadersImpl();
        }

        public SimplePDFFileItem(String fieldName, String fileName, boolean isFormField, byte[] cachedContent, String contentType, File dfosFile, FileItemHeaders headers) {
            this.fieldName = fieldName;
            this.fileName = fileName;
            this.isFormField = isFormField;
            this.cachedContent = cachedContent;
            this.contentType = contentType;
            this.dfosFile = dfosFile;
            this.headers = headers;
        }

        public InputStream getInputStream() throws IOException {
            if (null == this.dfosFile) {
                return new ByteArrayInputStream(this.cachedContent);
            }
            return new FileInputStream(this.dfosFile);
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            return this.fileName;
        }

        public boolean isInMemory() {
            return this.cachedContent.length > 0;
        }

        public long getSize() {
            return this.cachedContent.length;
        }

        public byte[] get() {
            return this.cachedContent;
        }

        public String getString(String s) throws UnsupportedEncodingException {
            return this.getString();
        }

        public String getString() {
            return new String(this.cachedContent, StandardCharsets.UTF_8);
        }

        public void write(File file) throws Exception {
            Files.write(file.toPath(), this.cachedContent, StandardOpenOption.CREATE);
        }

        public void delete() {
            boolean delete = this.dfosFile.delete();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String s) {
            this.fieldName = s;
        }

        public boolean isFormField() {
            return this.isFormField;
        }

        public void setFormField(boolean b) {
            this.isFormField = b;
        }

        public OutputStream getOutputStream() throws IOException {
            if (null == this.dfosFile) {
                return new ByteArrayOutputStream(1024);
            }
            return new FileOutputStream(this.dfosFile);
        }

        public FileItemHeaders getHeaders() {
            return this.headers;
        }

        public void setHeaders(FileItemHeaders fileItemHeaders) {
            this.headers = fileItemHeaders;
        }

        public String toString() {
            return "SimplePDFFileItem{fieldName='" + this.fieldName + '\'' + ", fileName='" + this.fileName + '\'' + ", isFormField=" + this.isFormField + ", cachedContent=[size]" + this.cachedContent.length + ", contentType='" + this.contentType + '\'' + ", dfosFile=" + this.dfosFile + '}';
        }
    }
}

