/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager.preferencesmanager;

import android.content.Context;
import android.content.SharedPreferences;
import com.tm.datamanager.preferencesmanager.PreferencesConfigurations;

public class PreferencesManager {
    private Context context;
    private final SharedPreferences sharedPreferences;
    private PreferencesConfigurations configuration;

    public PreferencesManager(Context context, PreferencesConfigurations configuration) {
        this.context = context;
        this.configuration = configuration;
        this.sharedPreferences = context.getSharedPreferences(configuration.getPreferencesFileName(), 0);
    }

    public boolean setValue(int value, String preference) {
        return this.sharedPreferences.edit().putInt(preference, value).commit();
    }

    public int getIntValue(String preference) {
        return this.sharedPreferences.getInt(preference, this.configuration.getIntPreferenceDefaultValue());
    }

    public int getIntValue(String preference, int defaultValue) {
        return this.sharedPreferences.getInt(preference, defaultValue);
    }

    public boolean setValue(boolean value, String preference) {
        return this.sharedPreferences.edit().putBoolean(preference, value).commit();
    }

    public boolean getBooleanValue(String preference) {
        return this.sharedPreferences.getBoolean(preference, this.configuration.getBooleanPreferenceDefaultValue());
    }

    public boolean getBooleanValue(String preference, boolean defaultValue) {
        return this.sharedPreferences.getBoolean(preference, defaultValue);
    }

    public boolean setValue(String value, String preference) {
        return this.sharedPreferences.edit().putString(preference, value).commit();
    }

    public String getStringValue(String preference) {
        return this.sharedPreferences.getString(preference, this.configuration.getStringPreferenceDefaultValue());
    }

    public String getStringValue(String preference, String defaultValue) {
        return this.sharedPreferences.getString(preference, defaultValue);
    }

    public boolean removePreference(String preference) {
        return this.sharedPreferences.edit().remove(preference).commit();
    }

    public boolean clearPreferences() {
        return this.sharedPreferences.edit().clear().commit();
    }
}

