/*
 * Decompiled with CFR 0.152.
 */
package com.tm.datamanager;

import android.content.Context;
import com.tm.datamanager.exceptions.DataManagerNotInstancedException;
import com.tm.datamanager.preferencesmanager.PreferencesConfigurations;
import com.tm.datamanager.preferencesmanager.PreferencesManager;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;
import java.util.HashMap;

public class DataManager {
    private static DataManager instance;
    private static PreferencesManager preferencesManagerInstance;
    private static WebServicesManager webServicesManagerInstance;
    private Context context;

    public DataManager(Context context) {
        this.context = context;
    }

    public static void init(Context context, WebServicesConfiguration webServicesConfiguration, HashMap<String, String> dummyResponses, PreferencesConfigurations preferencesConfigurations) {
        instance = new DataManager(context);
        preferencesManagerInstance = new PreferencesManager(context, preferencesConfigurations);
        webServicesManagerInstance = new WebServicesManager(context, webServicesConfiguration, dummyResponses);
    }

    public static DataManager getInstance(Context context) {
        if (instance == null) {
            throw new DataManagerNotInstancedException();
        }
        return instance;
    }

    public static PreferencesManager getPreferencesManagerInstance() {
        if (instance == null) {
            throw new DataManagerNotInstancedException();
        }
        return preferencesManagerInstance;
    }

    public static WebServicesManager getWebServicesManagerInstance() {
        if (instance == null) {
            throw new DataManagerNotInstancedException();
        }
        return webServicesManagerInstance;
    }
}

