package com.tm.datamanager.webservicesmanager.soap;

import android.util.Xml;

import org.xmlpull.v1.XmlPullParser;

import java.io.ByteArrayInputStream;

/**
 * Created by Navas on 1/2/16.
 */
public abstract class SoapResponse {

    protected SoapObject response;

    public void setResponse(String response){
        try {
            this.response = stringToSoapObject(response);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if(this.response != null) parse(this.response);
    }

    public abstract void parse(SoapObject response);

    protected SoapObject stringToSoapObject(String response) throws Exception {

        SoapSerializationEnvelope envelope=new SoapSerializationEnvelope(SoapEnvelope.VER11);
        SoapObject soap=null;
        try {
            ByteArrayInputStream inputStream=new ByteArrayInputStream(response.getBytes());
            XmlPullParser p= Xml.newPullParser();
            p.setInput(inputStream, "UTF-8");
            envelope.parse(p);
            soap=(SoapObject)envelope.bodyIn;
        } catch (Exception e) {
            e.printStackTrace();
        }



        return soap;
    }

}
