package com.tm.datamanager;


import android.content.Context;

import com.tm.datamanager.exceptions.DataManagerNotInstancedException;
import com.tm.datamanager.preferencesmanager.PreferencesConfigurations;
import com.tm.datamanager.preferencesmanager.PreferencesManager;
import com.tm.datamanager.webservicesmanager.WebServicesManager;
import com.tm.datamanager.webservicesmanager.configurations.DummyResponses;
import com.tm.datamanager.webservicesmanager.configurations.WebServicesConfiguration;

import java.util.HashMap;

/**
 * Created by Navas on 19/06/15
 * This class controls all data of the application:
 *  - The information that is saved in the preferences files
 *  - The information that is saved in data base
 *  - Access to the information on the web services
 */
public class DataManager {

    // Singleton instances
    private static DataManager instance;
    private static PreferencesManager preferencesManagerInstance;
    private static WebServicesManager webServicesManagerInstance;

    private Context context;

    public DataManager(Context context){
        this.context = context;
    }

    public static void init(Context context,
                            // Classes that implements the web services configuration
                            WebServicesConfiguration webServicesConfiguration,
                            HashMap<String, String> dummyResponses,
                            // Class that implements the preferences configuration
                            PreferencesConfigurations preferencesConfigurations){
        instance = new DataManager(context);
        preferencesManagerInstance = new PreferencesManager(context, preferencesConfigurations);
        webServicesManagerInstance = new WebServicesManager(context, webServicesConfiguration,dummyResponses);
    }

    public static DataManager getInstance(Context context) {
            if(instance == null)
                throw new DataManagerNotInstancedException();
        return instance;
    }

    public static PreferencesManager getPreferencesManagerInstance(){
            if(instance == null)
                throw new DataManagerNotInstancedException();
        return preferencesManagerInstance;
    }

    public static WebServicesManager getWebServicesManagerInstance(){
            if(instance == null)
                throw new DataManagerNotInstancedException();
        return webServicesManagerInstance;
    }





}
