/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.utils.AvatarUtils;
import com.giphy.sdk.ui.views.GifView;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0017H\u0007J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/giphy/sdk/ui/views/UserProfileInfoLoader;", "", "context", "Landroid/content/Context;", "user", "Lcom/giphy/sdk/core/models/User;", "(Landroid/content/Context;Lcom/giphy/sdk/core/models/User;)V", "getContext", "()Landroid/content/Context;", "shouldDisplayUserSocial", "", "getShouldDisplayUserSocial", "()Z", "getUser", "()Lcom/giphy/sdk/core/models/User;", "addSocialContainerItem", "Landroid/view/View;", "imageId", "", "socialContainer", "Landroid/widget/LinearLayout;", "displayName", "", "Landroid/widget/TextView;", "displayUserAvatar", "userChannelGifAvatar", "Lcom/giphy/sdk/ui/views/GifView;", "displayUserInfo", "channelName", "verifiedBadge", "Landroid/widget/ImageView;", "displayUserSocial", "channelDescription", "websiteUrl", "displayUsername", "displayVerifiedBadge", "openUrl", "url", "", "verifiedBadgeVisible", "giphy-ui-2.3.17_release"})
public final class UserProfileInfoLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final User user;
    private final boolean shouldDisplayUserSocial;

    public UserProfileInfoLoader(@NotNull Context context, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.context = context;
        this.user = user;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final User getUser() {
        return this.user;
    }

    public final boolean getShouldDisplayUserSocial() {
        return this.shouldDisplayUserSocial;
    }

    public final void displayUserInfo(@NotNull TextView displayName, @NotNull TextView channelName, @NotNull ImageView verifiedBadge, @NotNull GifView userChannelGifAvatar) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        Intrinsics.checkNotNullParameter((Object)verifiedBadge, (String)"verifiedBadge");
        Intrinsics.checkNotNullParameter((Object)((Object)userChannelGifAvatar), (String)"userChannelGifAvatar");
        this.displayUsername(channelName);
        this.displayVerifiedBadge(verifiedBadge);
        this.displayUserAvatar(userChannelGifAvatar);
        this.displayName(displayName);
    }

    @SuppressLint(value={"SetTextI18n"})
    public final void displayUsername(@NotNull TextView channelName) {
        Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
        CharSequence charSequence = this.user.getDisplayName();
        channelName.setVisibility(charSequence == null || charSequence.length() == 0 ? 4 : 0);
        channelName.setText((CharSequence)('@' + this.user.getUsername()));
    }

    private final void displayVerifiedBadge(ImageView verifiedBadge) {
        verifiedBadge.setVisibility(this.verifiedBadgeVisible() ? 0 : 4);
    }

    public final void displayName(@NotNull TextView displayName) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        CharSequence charSequence = this.user.getDisplayName();
        if (!(charSequence == null || charSequence.length() == 0)) {
            displayName.setText((CharSequence)this.user.getDisplayName());
        } else {
            displayName.setText((CharSequence)this.user.getUsername());
        }
    }

    public final boolean verifiedBadgeVisible() {
        CharSequence charSequence;
        return this.user.getVerified() && !((charSequence = (CharSequence)this.user.getDisplayName()) == null || charSequence.length() == 0);
    }

    public final void displayUserSocial(@NotNull TextView channelDescription, @NotNull TextView websiteUrl, @NotNull LinearLayout socialContainer) {
        Intrinsics.checkNotNullParameter((Object)channelDescription, (String)"channelDescription");
        Intrinsics.checkNotNullParameter((Object)websiteUrl, (String)"websiteUrl");
        Intrinsics.checkNotNullParameter((Object)socialContainer, (String)"socialContainer");
        CharSequence charSequence = this.user.getDescription();
        if (!(charSequence == null || charSequence.length() == 0)) {
            channelDescription.setVisibility(0);
            channelDescription.setText((CharSequence)this.user.getDescription());
        }
        if (this.shouldDisplayUserSocial) {
            charSequence = this.user.getWebsiteUrl();
            if (!(charSequence == null || charSequence.length() == 0)) {
                websiteUrl.setText((CharSequence)new URL(this.user.getWebsiteUrl()).getHost());
                websiteUrl.setVisibility(0);
                websiteUrl.setOnClickListener(arg_0 -> UserProfileInfoLoader.displayUserSocial$lambda$0(this, arg_0));
            }
            if (!((charSequence = (CharSequence)this.user.getFacebookUrl()) == null || charSequence.length() == 0)) {
                this.addSocialContainerItem(R.drawable.ic_channel_facebook, socialContainer).setOnClickListener(arg_0 -> UserProfileInfoLoader.displayUserSocial$lambda$1(this, arg_0));
            }
            if (!((charSequence = (CharSequence)this.user.getTwitterUrl()) == null || charSequence.length() == 0)) {
                this.addSocialContainerItem(R.drawable.ic_channel_twitter, socialContainer).setOnClickListener(arg_0 -> UserProfileInfoLoader.displayUserSocial$lambda$2(this, arg_0));
            }
            if (!((charSequence = (CharSequence)this.user.getInstagramUrl()) == null || charSequence.length() == 0)) {
                this.addSocialContainerItem(R.drawable.ic_channel_insta, socialContainer).setOnClickListener(arg_0 -> UserProfileInfoLoader.displayUserSocial$lambda$3(this, arg_0));
            }
            if (!((charSequence = (CharSequence)this.user.getTumblrUrl()) == null || charSequence.length() == 0)) {
                this.addSocialContainerItem(R.drawable.ic_channel_tumblr, socialContainer).setOnClickListener(arg_0 -> UserProfileInfoLoader.displayUserSocial$lambda$4(this, arg_0));
            }
        }
        if (socialContainer.getChildCount() > 0) {
            socialContainer.setVisibility(0);
        } else {
            socialContainer.setVisibility(8);
        }
    }

    public final void displayUserAvatar(@NotNull GifView userChannelGifAvatar) {
        Intrinsics.checkNotNullParameter((Object)((Object)userChannelGifAvatar), (String)"userChannelGifAvatar");
        CharSequence charSequence = this.user.getAvatarUrl();
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        userChannelGifAvatar.loadAsset(AvatarUtils.INSTANCE.getDownsizedUrl(this.user.getAvatarUrl(), AvatarUtils.Dimension.Big));
    }

    private final void openUrl(String url) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        intent.setFlags(0x10000000);
        this.context.startActivity(intent);
    }

    private final View addSocialContainerItem(int imageId, LinearLayout socialContainer) {
        ImageView socialItem = new ImageView(this.context);
        socialItem.setImageResource(imageId);
        int size = this.context.getResources().getDimensionPixelSize(R.dimen.user_info_dialog_social_item_size);
        int margin = this.context.getResources().getDimensionPixelSize(R.dimen.user_info_dialog_social_item_margin);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(size, size);
        layoutParams.leftMargin = margin;
        layoutParams.rightMargin = margin;
        socialContainer.addView((View)socialItem, (ViewGroup.LayoutParams)layoutParams);
        return (View)socialItem;
    }

    private static final void displayUserSocial$lambda$0(UserProfileInfoLoader this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openUrl(this$0.user.getWebsiteUrl());
    }

    private static final void displayUserSocial$lambda$1(UserProfileInfoLoader this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openUrl(this$0.user.getFacebookUrl());
    }

    private static final void displayUserSocial$lambda$2(UserProfileInfoLoader this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openUrl(this$0.user.getTwitterUrl());
    }

    private static final void displayUserSocial$lambda$3(UserProfileInfoLoader this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openUrl(this$0.user.getInstagramUrl());
    }

    private static final void displayUserSocial$lambda$4(UserProfileInfoLoader this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.openUrl(this$0.user.getTumblrUrl());
    }
}

