/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import com.giphy.sdk.core.models.User;
import com.giphy.sdk.ui.Giphy;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.databinding.GphUserProfileInfoDialogBinding;
import com.giphy.sdk.ui.views.GifView;
import com.giphy.sdk.ui.views.UserProfileInfoDialog;
import com.giphy.sdk.ui.views.UserProfileInfoLoader;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lcom/giphy/sdk/ui/views/UserProfileInfoDialog;", "Landroid/widget/PopupWindow;", "context", "Landroid/content/Context;", "user", "Lcom/giphy/sdk/core/models/User;", "(Landroid/content/Context;Lcom/giphy/sdk/core/models/User;)V", "_binding", "Lcom/giphy/sdk/ui/databinding/GphUserProfileInfoDialogBinding;", "binding", "getBinding", "()Lcom/giphy/sdk/ui/databinding/GphUserProfileInfoDialogBinding;", "getContext", "()Landroid/content/Context;", "onDismissed", "Lkotlin/Function0;", "", "getOnDismissed", "()Lkotlin/jvm/functions/Function0;", "setOnDismissed", "(Lkotlin/jvm/functions/Function0;)V", "profileLoader", "Lcom/giphy/sdk/ui/views/UserProfileInfoLoader;", "getUser", "()Lcom/giphy/sdk/core/models/User;", "setUser", "(Lcom/giphy/sdk/core/models/User;)V", "initBottomSheet", "initUI", "onDismiss", "giphy-ui-2.3.17_release"})
public final class UserProfileInfoDialog
extends PopupWindow {
    @NotNull
    private final Context context;
    @NotNull
    private User user;
    @Nullable
    private GphUserProfileInfoDialogBinding _binding;
    private UserProfileInfoLoader profileLoader;
    @NotNull
    private Function0<Unit> onDismissed;

    public UserProfileInfoDialog(@NotNull Context context, @NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        this.context = context;
        this.user = user;
        this.onDismissed = onDismissed.1.INSTANCE;
        this.setContentView(View.inflate((Context)this.context, (int)R.layout.gph_user_profile_info_dialog, null));
        this._binding = GphUserProfileInfoDialogBinding.bind(this.getContentView());
        this.setWidth(-1);
        this.setHeight(-1);
        if (Build.VERSION.SDK_INT >= 23) {
            this.setOverlapAnchor(true);
        }
        this.setOutsideTouchable(true);
        this.initUI();
        this.setOnDismissListener(() -> UserProfileInfoDialog._init_$lambda$0(this));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final User getUser() {
        return this.user;
    }

    public final void setUser(@NotNull User user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"<set-?>");
        this.user = user;
    }

    private final GphUserProfileInfoDialogBinding getBinding() {
        GphUserProfileInfoDialogBinding gphUserProfileInfoDialogBinding = this._binding;
        Intrinsics.checkNotNull((Object)gphUserProfileInfoDialogBinding);
        return gphUserProfileInfoDialogBinding;
    }

    @NotNull
    public final Function0<Unit> getOnDismissed() {
        return this.onDismissed;
    }

    public final void setOnDismissed(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.onDismissed = function0;
    }

    private final void onDismiss() {
        this._binding = null;
        this.onDismissed.invoke();
    }

    private final void initUI() {
        GphUserProfileInfoDialogBinding gphUserProfileInfoDialogBinding;
        this.getContentView().setBackgroundColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release().getDialogOverlayBackgroundColor());
        this.profileLoader = new UserProfileInfoLoader(this.context, this.user);
        GphUserProfileInfoDialogBinding $this$initUI_u24lambda_u242 = gphUserProfileInfoDialogBinding = this.getBinding();
        boolean bl = false;
        $this$initUI_u24lambda_u242.body.getBackground().setColorFilter(BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release().getBackgroundColor(), (BlendModeCompat)BlendModeCompat.SRC_ATOP));
        $this$initUI_u24lambda_u242.userName.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release().getUsernameColor());
        $this$initUI_u24lambda_u242.channelName.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release().getUsernameColor());
        $this$initUI_u24lambda_u242.channelDescription.setTextColor(Giphy.INSTANCE.getThemeUsed$giphy_ui_2_3_17_release().getDefaultTextColor());
        UserProfileInfoLoader userProfileInfoLoader = this.profileLoader;
        if (userProfileInfoLoader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileLoader");
            userProfileInfoLoader = null;
        }
        TextView textView = $this$initUI_u24lambda_u242.userName;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"userName");
        TextView textView2 = $this$initUI_u24lambda_u242.channelName;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"channelName");
        ImageView imageView = $this$initUI_u24lambda_u242.verifiedBadge;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"verifiedBadge");
        GifView gifView = $this$initUI_u24lambda_u242.userChannelGifAvatar;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifView), (String)"userChannelGifAvatar");
        userProfileInfoLoader.displayUserInfo(textView, textView2, imageView, gifView);
        UserProfileInfoLoader userProfileInfoLoader2 = this.profileLoader;
        if (userProfileInfoLoader2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"profileLoader");
            userProfileInfoLoader2 = null;
        }
        TextView textView3 = $this$initUI_u24lambda_u242.channelDescription;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"channelDescription");
        TextView textView4 = $this$initUI_u24lambda_u242.websiteUrl;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"websiteUrl");
        LinearLayout linearLayout = $this$initUI_u24lambda_u242.socialContainer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"socialContainer");
        userProfileInfoLoader2.displayUserSocial(textView3, textView4, linearLayout);
        $this$initUI_u24lambda_u242.dialogContainer.setOnClickListener(arg_0 -> UserProfileInfoDialog.initUI$lambda$2$lambda$1(this, arg_0));
        this.initBottomSheet();
    }

    private final void initBottomSheet() {
        BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)((View)this.getBinding().body));
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetBehavior, (String)"from(binding.body)");
        BottomSheetBehavior bottomSheetBehavior2 = bottomSheetBehavior;
        bottomSheetBehavior2.addBottomSheetCallback(new BottomSheetBehavior.BottomSheetCallback(this){
            final /* synthetic */ UserProfileInfoDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull View bottomSheet, int newState) {
                Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
                if (newState == 5) {
                    this.this$0.dismiss();
                }
            }

            public void onSlide(@NotNull View bottomSheet, float slideOffset) {
                Intrinsics.checkNotNullParameter((Object)bottomSheet, (String)"bottomSheet");
            }
        });
        this.getContentView().postDelayed(() -> UserProfileInfoDialog.initBottomSheet$lambda$4(this), 100L);
    }

    private static final void _init_$lambda$0(UserProfileInfoDialog this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onDismiss();
    }

    private static final void initUI$lambda$2$lambda$1(UserProfileInfoDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void initBottomSheet$lambda$4(UserProfileInfoDialog this$0) {
        GphUserProfileInfoDialogBinding gphUserProfileInfoDialogBinding;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        GphUserProfileInfoDialogBinding $this$initBottomSheet_u24lambda_u244_u24lambda_u243 = gphUserProfileInfoDialogBinding = this$0.getBinding();
        boolean bl = false;
        $this$initBottomSheet_u24lambda_u244_u24lambda_u243.channelDescription.setMaxLines(Integer.MAX_VALUE);
        BottomSheetBehavior.from((View)((View)$this$initBottomSheet_u24lambda_u244_u24lambda_u243.body)).setPeekHeight($this$initBottomSheet_u24lambda_u244_u24lambda_u243.body.getHeight());
        BottomSheetBehavior.from((View)((View)$this$initBottomSheet_u24lambda_u244_u24lambda_u243.body)).setState(3);
    }
}

