/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import androidx.core.graphics.ColorUtils;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import com.giphy.sdk.ui.views.GPHEmojiDrawer;
import com.giphy.sdk.ui.views.GifView;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0010\u0018\u0000 =2\u00020\u0001:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0003JM\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010/JL\u00100\u001a\u00020+2\u0006\u00101\u001a\u00020.2\u0006\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020.2\u0006\u0010\b\u001a\u00020.2\u0006\u0010\u0003\u001a\u00020.2\u0006\u00104\u001a\u00020.2\b\b\u0002\u00105\u001a\u00020.2\b\b\u0002\u00106\u001a\u00020.H\u0002J\u0012\u00107\u001a\u00020\u000e2\b\u00108\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u00109\u001a\u00020\u001cJ\u009c\u0001\u0010:\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0014\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001c0\u001e2\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001c0\u001eJ\u0006\u0010;\u001a\u00020\u001cJ\u0016\u0010<\u001a\u00020\u001c2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u001c0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/giphy/sdk/ui/views/GPHEmojiDrawer;", "", "()V", "anchorHeight", "", "anchorPlaceHolderView", "Landroid/view/View;", "anchorView", "anchorWidth", "backgroundColorGradientBottom", "backgroundColorGradientTop", "context", "Landroid/content/Context;", "displaySize", "Landroid/graphics/Rect;", "getDisplaySize", "()Landroid/graphics/Rect;", "dividerColor", "emojiDrawerViewHeight", "emojiList", "", "Lcom/giphy/sdk/core/models/Media;", "emojiListViewWidth", "emojiViewList", "", "Lcom/giphy/sdk/ui/views/GifView;", "onClosed", "Lkotlin/Function0;", "", "onEmojiPressed", "Lkotlin/Function1;", "onEmojiSelected", "onShown", "popupWindow", "Landroid/widget/PopupWindow;", "createPopupWindowIfNeeded", "touchX", "displayWidth", "getDrawable", "Landroid/graphics/drawable/Drawable;", "width", "height", "path", "Landroid/graphics/Path;", "shadowPath", "regularShadowRadius", "", "(IILandroid/graphics/Path;Landroid/graphics/Path;Ljava/lang/Float;II)Landroid/graphics/drawable/Drawable;", "getDrawerPath", "emojisWidth", "emojisHeight", "anchorTranslationX", "cornerRadius", "marginTop", "marginHorizontal", "getViewSize", "view", "hide", "setup", "show", "update", "Styles", "giphy-ui-2.3.17_release"})
@SourceDebugExtension(value={"SMAP\nGPHEmojiDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GPHEmojiDrawer.kt\ncom/giphy/sdk/ui/views/GPHEmojiDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,654:1\n1872#2,3:655\n*S KotlinDebug\n*F\n+ 1 GPHEmojiDrawer.kt\ncom/giphy/sdk/ui/views/GPHEmojiDrawer\n*L\n126#1:655,3\n*E\n"})
public final class GPHEmojiDrawer {
    @NotNull
    public static final Styles Styles = new Styles(null);
    private Context context;
    @Nullable
    private PopupWindow popupWindow;
    private int anchorWidth;
    private int anchorHeight;
    private View anchorView;
    private View anchorPlaceHolderView;
    private List<Media> emojiList;
    private List<GifView> emojiViewList;
    private int dividerColor = -5855578;
    private int backgroundColorGradientTop = -11645362;
    private int backgroundColorGradientBottom = -11645362;
    private int emojiListViewWidth;
    private int emojiDrawerViewHeight;
    @NotNull
    private Function1<? super Media, Unit> onEmojiSelected = onEmojiSelected.1.INSTANCE;
    @NotNull
    private Function1<? super Media, Unit> onEmojiPressed = onEmojiPressed.1.INSTANCE;
    @NotNull
    private Function0<Unit> onShown = onShown.1.INSTANCE;
    @NotNull
    private Function0<Unit> onClosed = onClosed.1.INSTANCE;
    private static final int EMOJI_VIEW_CELL_PADDING_HORIZONTAL = 5;
    private static final int EMOJI_VIEW_MARGIN_HORIZONTAL = 5;
    private static final int EMOJI_VIEW_MARGIN_VERTICAL = 8;
    private static final int EMOJI_DIVIDER_MARGIN_HORIZONTAL = 4;
    private static final int DIVIDER_WIDTH = 2;

    private final Rect getDisplaySize() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = wm.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"wm.currentWindowMetrics");
            WindowMetrics windowMetrics2 = windowMetrics;
            Insets insets = windowMetrics2.getWindowInsets().getInsetsIgnoringVisibility(WindowInsets.Type.systemBars());
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"windowMetrics.windowInse\u2026Insets.Type.systemBars())");
            Insets insets2 = insets;
            int widthPixels = windowMetrics2.getBounds().width() - insets2.left - insets2.right;
            return new Rect(0, 0, widthPixels, windowMetrics2.getBounds().height());
        }
        DisplayMetrics outMetrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(outMetrics);
        return new Rect(0, 0, outMetrics.widthPixels, outMetrics.heightPixels);
    }

    public final void setup(@NotNull Context context, @NotNull View anchorView, int anchorWidth, int anchorHeight, int dividerColor, int backgroundColorGradientTop, int backgroundColorGradientBottom, @NotNull List<Media> emojiList, @NotNull Function0<Unit> onShown2, @NotNull Function0<Unit> onClosed2, @NotNull Function1<? super Media, Unit> onEmojiSelected2, @NotNull Function1<? super Media, Unit> onEmojiPressed2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)anchorView, (String)"anchorView");
        Intrinsics.checkNotNullParameter(emojiList, (String)"emojiList");
        Intrinsics.checkNotNullParameter(onShown2, (String)"onShown");
        Intrinsics.checkNotNullParameter(onClosed2, (String)"onClosed");
        Intrinsics.checkNotNullParameter(onEmojiSelected2, (String)"onEmojiSelected");
        Intrinsics.checkNotNullParameter(onEmojiPressed2, (String)"onEmojiPressed");
        this.context = context;
        this.anchorView = anchorView;
        this.anchorWidth = anchorWidth;
        this.anchorHeight = anchorHeight;
        this.backgroundColorGradientTop = backgroundColorGradientTop;
        this.backgroundColorGradientBottom = backgroundColorGradientBottom;
        this.dividerColor = dividerColor;
        this.onShown = onShown2;
        this.onClosed = onClosed2;
        this.onEmojiSelected = onEmojiSelected2;
        this.onEmojiPressed = onEmojiPressed2;
        this.emojiList = emojiList;
    }

    public static /* synthetic */ void setup$default(GPHEmojiDrawer gPHEmojiDrawer, Context context, View view, int n, int n2, int n3, int n4, int n5, List list, Function0 function0, Function0 function02, Function1 function1, Function1 function12, int n6, Object object) {
        if ((n6 & 0x100) != 0) {
            function0 = setup.1.INSTANCE;
        }
        if ((n6 & 0x200) != 0) {
            function02 = setup.2.INSTANCE;
        }
        if ((n6 & 0x800) != 0) {
            function12 = setup.3.INSTANCE;
        }
        gPHEmojiDrawer.setup(context, view, n, n2, n3, n4, n5, list, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function1<? super Media, Unit>)function1, (Function1<? super Media, Unit>)function12);
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull List<Media> emojiList) {
        Intrinsics.checkNotNullParameter(emojiList, (String)"emojiList");
        List<Media> list = this.emojiList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
            list = null;
        }
        if (list.size() != emojiList.size()) {
            return;
        }
        this.emojiList = emojiList;
        List<GifView> list2 = this.emojiViewList;
        if (list2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiViewList");
            list2 = null;
        }
        Iterable $this$forEachIndexed$iv = list2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void view;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GifView gifView = (GifView)((Object)item$iv);
            int index = n;
            boolean bl = false;
            if (index <= 0 || index >= emojiList.size()) continue;
            GifView.setMedia$default((GifView)view, emojiList.get(index), RenditionType.fixedWidth, null, 4, null);
        }
    }

    public final void hide() {
        this.onClosed.invoke();
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
        this.popupWindow = null;
    }

    public final void show() {
        int[] point = new int[2];
        View view = this.anchorView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anchorView");
            view = null;
        }
        view.getLocationInWindow(point);
        int x = point[0];
        int y = point[1];
        int left = (int)((float)x + (float)(this.anchorWidth / 2));
        int top = (int)((float)y + (float)this.anchorHeight);
        int displayWidth = this.getDisplaySize().width();
        this.createPopupWindowIfNeeded(left, displayWidth);
        PopupWindow popupWindow = this.popupWindow;
        Intrinsics.checkNotNull((Object)popupWindow);
        View view2 = this.anchorView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anchorView");
            view2 = null;
        }
        popupWindow.showAtLocation(view2, 17, left - this.getDisplaySize().width() / 2, top - this.getDisplaySize().height() / 2 - this.emojiDrawerViewHeight + (int)(1.75f * (float)this.anchorHeight));
        this.onShown.invoke();
    }

    private final Rect getViewSize(View view) {
        View view2 = view;
        if (view2 == null) {
            return new Rect(0, 0, 0, 0);
        }
        View v = view2;
        v.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        return new Rect(0, 0, v.getMeasuredWidth(), v.getMeasuredHeight());
    }

    private final Path getDrawerPath(float emojisWidth, float emojisHeight, float anchorTranslationX, float anchorWidth, float anchorHeight, float cornerRadius, float marginTop, float marginHorizontal) {
        Path path = new Path();
        path.moveTo(cornerRadius + marginHorizontal, marginTop);
        path.lineTo(emojisWidth - cornerRadius - marginHorizontal, marginTop);
        path.quadTo(emojisWidth - marginHorizontal, marginTop, emojisWidth - marginHorizontal, cornerRadius + marginTop);
        path.lineTo(emojisWidth - marginHorizontal, emojisHeight - cornerRadius + marginTop);
        if (anchorHeight == 0.0f) {
            path.quadTo(emojisWidth - marginHorizontal, emojisHeight + marginTop, emojisWidth - cornerRadius - marginHorizontal, emojisHeight + marginTop);
            path.lineTo(anchorTranslationX, emojisHeight + marginTop);
            path.lineTo(cornerRadius + marginHorizontal, emojisHeight + marginTop);
            path.quadTo(0.0f + marginHorizontal, emojisHeight + marginTop, 0.0f + marginHorizontal, emojisHeight - cornerRadius + marginTop);
            path.lineTo(0.0f + marginHorizontal, cornerRadius + marginTop);
            path.quadTo(0.0f + marginHorizontal, marginTop, cornerRadius + marginHorizontal, marginTop);
            path.close();
            return path;
        }
        if (emojisWidth - anchorTranslationX + cornerRadius - marginHorizontal > cornerRadius) {
            path.quadTo(emojisWidth - marginHorizontal, emojisHeight + marginTop, emojisWidth - cornerRadius - marginHorizontal, emojisHeight + marginTop);
            path.lineTo(anchorTranslationX, emojisHeight + marginTop);
            path.quadTo(anchorTranslationX - cornerRadius, emojisHeight + marginTop, anchorTranslationX - cornerRadius, emojisHeight + cornerRadius + marginTop);
        } else if (emojisWidth - anchorTranslationX + cornerRadius - marginHorizontal <= cornerRadius * 1.1f) {
            path.cubicTo(emojisWidth - marginHorizontal, emojisHeight + marginTop, anchorTranslationX - cornerRadius, emojisHeight + marginTop, anchorTranslationX - cornerRadius, emojisHeight + cornerRadius + marginTop);
        } else {
            path.quadTo(emojisWidth - marginHorizontal, emojisHeight + marginTop, anchorTranslationX - cornerRadius / (float)2, emojisHeight + marginTop);
            path.quadTo(anchorTranslationX - cornerRadius, emojisHeight + marginTop, anchorTranslationX - cornerRadius, emojisHeight + cornerRadius + marginTop);
        }
        path.lineTo(anchorTranslationX - cornerRadius, emojisHeight + anchorHeight - cornerRadius + marginTop);
        path.quadTo(anchorTranslationX - cornerRadius, emojisHeight + anchorHeight + marginTop, anchorTranslationX - cornerRadius - cornerRadius, emojisHeight + anchorHeight + marginTop);
        path.lineTo(anchorTranslationX + cornerRadius - anchorWidth, emojisHeight + anchorHeight + marginTop);
        path.quadTo(anchorTranslationX - anchorWidth, emojisHeight + anchorHeight + marginTop, anchorTranslationX - anchorWidth, emojisHeight + anchorHeight - cornerRadius + marginTop);
        path.lineTo(anchorTranslationX - anchorWidth, emojisHeight + cornerRadius + marginTop);
        if (anchorTranslationX - anchorWidth - cornerRadius / (float)2 >= cornerRadius) {
            path.quadTo(anchorTranslationX - anchorWidth, emojisHeight + marginTop, anchorTranslationX - anchorWidth - cornerRadius, emojisHeight + marginTop);
            path.lineTo(cornerRadius + marginHorizontal, emojisHeight + marginTop);
            path.quadTo(0.0f + marginHorizontal, emojisHeight + marginTop, 0.0f + marginHorizontal, emojisHeight - cornerRadius + marginTop);
        } else if (anchorTranslationX - anchorWidth - cornerRadius / (float)2 <= cornerRadius * 1.1f) {
            path.cubicTo(anchorTranslationX - anchorWidth, emojisHeight + marginTop, 0.0f + marginHorizontal, emojisHeight + marginTop, 0.0f + marginHorizontal, emojisHeight - cornerRadius + marginTop);
        } else {
            path.quadTo(anchorTranslationX - anchorWidth, emojisHeight + marginTop, (anchorTranslationX - anchorWidth) / (float)2, emojisHeight + marginTop);
            path.quadTo(0.0f + marginHorizontal, emojisHeight + marginTop, 0.0f + marginHorizontal, emojisHeight - cornerRadius + marginTop);
        }
        path.lineTo(0.0f + marginHorizontal, cornerRadius + marginTop);
        path.quadTo(0.0f + marginHorizontal, marginTop, cornerRadius + marginHorizontal, marginTop);
        path.close();
        return path;
    }

    static /* synthetic */ Path getDrawerPath$default(GPHEmojiDrawer gPHEmojiDrawer, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, Object object) {
        if ((n & 0x40) != 0) {
            f7 = 0.0f;
        }
        if ((n & 0x80) != 0) {
            f8 = 0.0f;
        }
        return gPHEmojiDrawer.getDrawerPath(f, f2, f3, f4, f5, f6, f7, f8);
    }

    private final Drawable getDrawable(int width, int height, Path path, Path shadowPath, Float regularShadowRadius, int backgroundColorGradientTop, int backgroundColorGradientBottom) {
        Paint paint = new Paint();
        Paint paintShadow = new Paint();
        Drawable drawable2 = new Drawable(shadowPath, paint, height, backgroundColorGradientTop, backgroundColorGradientBottom, regularShadowRadius, path, paintShadow, width){
            final /* synthetic */ Path $shadowPath;
            final /* synthetic */ Paint $paint;
            final /* synthetic */ int $height;
            final /* synthetic */ int $backgroundColorGradientTop;
            final /* synthetic */ int $backgroundColorGradientBottom;
            final /* synthetic */ Float $regularShadowRadius;
            final /* synthetic */ Path $path;
            final /* synthetic */ Paint $paintShadow;
            final /* synthetic */ int $width;
            {
                this.$shadowPath = $shadowPath;
                this.$paint = $paint;
                this.$height = $height;
                this.$backgroundColorGradientTop = $backgroundColorGradientTop;
                this.$backgroundColorGradientBottom = $backgroundColorGradientBottom;
                this.$regularShadowRadius = $regularShadowRadius;
                this.$path = $path;
                this.$paintShadow = $paintShadow;
                this.$width = $width;
            }

            public void draw(@NotNull Canvas canvas) {
                Paint paint;
                Object object;
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                Path path = this.$shadowPath;
                if (path != null) {
                    object = path;
                    paint = this.$paintShadow;
                    int n = this.$height;
                    int n2 = this.$backgroundColorGradientBottom;
                    Path it = object;
                    boolean bl = false;
                    paint.setStyle(Paint.Style.FILL_AND_STROKE);
                    paint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)n, ColorUtils.setAlphaComponent((int)n2, (int)255), ColorUtils.setAlphaComponent((int)n2, (int)34), Shader.TileMode.MIRROR));
                    paint.setMaskFilter((MaskFilter)new BlurMaskFilter(5.0f, BlurMaskFilter.Blur.NORMAL));
                    canvas.drawPath(it, paint);
                }
                this.$paint.setStyle(Paint.Style.FILL_AND_STROKE);
                this.$paint.setStrokeWidth(1.0f);
                this.$paint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.$height, this.$backgroundColorGradientTop, this.$backgroundColorGradientBottom, Shader.TileMode.CLAMP));
                Float f = this.$regularShadowRadius;
                if (f != null) {
                    object = f;
                    paint = this.$paint;
                    float it = ((Number)object).floatValue();
                    boolean bl = false;
                    paint.setShadowLayer(it, 0.0f, 0.0f, -7829368);
                }
                canvas.drawPath(this.$path, this.$paint);
            }

            public void setColorFilter(@Nullable ColorFilter colorFilter) {
            }

            public void setAlpha(int alpha) {
            }

            @Deprecated(message="Deprecated in Java", replaceWith=@ReplaceWith(expression="PixelFormat.TRANSLUCENT", imports={"android.graphics.PixelFormat"}))
            public int getOpacity() {
                return -3;
            }

            public int getIntrinsicWidth() {
                return this.$width;
            }

            public int getIntrinsicHeight() {
                return this.$height;
            }
        };
        return drawable2;
    }

    static /* synthetic */ Drawable getDrawable$default(GPHEmojiDrawer gPHEmojiDrawer, int n, int n2, Path path, Path path2, Float f, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            path2 = null;
        }
        if ((n5 & 0x10) != 0) {
            f = null;
        }
        return gPHEmojiDrawer.getDrawable(n, n2, path, path2, f, n3, n4);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private final void createPopupWindowIfNeeded(int touchX, int displayWidth) {
        Context context;
        if (this.popupWindow != null) {
            return;
        }
        this.emojiViewList = new ArrayList();
        Context context2 = this.context;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context2 = null;
        }
        LinearLayout contentView = new LinearLayout(context2);
        contentView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        contentView.setOrientation(1);
        Context context3 = this.context;
        if (context3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context3 = null;
        }
        LinearLayout emojiListView = new LinearLayout(context3);
        contentView.setOnTouchListener((arg_0, arg_1) -> GPHEmojiDrawer.createPopupWindowIfNeeded$lambda$1(this, arg_0, arg_1));
        int i = 0;
        List<Media> list = this.emojiList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
            list = null;
        }
        int n = list.size();
        while (i < n) {
            Context context4 = this.context;
            if (context4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context4 = null;
            }
            GifView emojiView = new GifView(context4, null, 0, 6, null);
            List<GifView> list2 = this.emojiViewList;
            if (list2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emojiViewList");
                list2 = null;
            }
            list2.add(emojiView);
            emojiView.setOnClickListener(arg_0 -> GPHEmojiDrawer.createPopupWindowIfNeeded$lambda$2(this, i, arg_0));
            emojiView.setOnLongClickListener(arg_0 -> GPHEmojiDrawer.createPopupWindowIfNeeded$lambda$3(this, i, arg_0));
            List<Media> list3 = this.emojiList;
            if (list3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
                list3 = null;
            }
            GifView.setMedia$default(emojiView, list3.get(i), RenditionType.fixedWidth, null, 4, null);
            LinearLayout.LayoutParams layoutParamsEmojiView = new LinearLayout.LayoutParams(this.anchorWidth, this.anchorHeight);
            List<Media> list4 = this.emojiList;
            if (list4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
                list4 = null;
            }
            int marginFactor = list4.size() == 1 ? 2 : 1;
            int n2 = i;
            if (n2 == 0) {
                int n3 = IntExtensionsKt.getPx(5) * marginFactor + IntExtensionsKt.getPx(5);
                int n4 = IntExtensionsKt.getPx(8);
                int n5 = IntExtensionsKt.getPx(5) * marginFactor;
                List<Media> list5 = this.emojiList;
                if (list5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
                    list5 = null;
                }
                layoutParamsEmojiView.setMargins(n3, n4, n5 + (list5.size() == 1 ? IntExtensionsKt.getPx(5) : 0), this.anchorHeight / 2);
            } else {
                List<Media> list6 = this.emojiList;
                if (list6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
                    list6 = null;
                }
                if (n2 == list6.size() - 1) {
                    layoutParamsEmojiView.setMargins(IntExtensionsKt.getPx(5) * marginFactor, IntExtensionsKt.getPx(8), IntExtensionsKt.getPx(5) * marginFactor + IntExtensionsKt.getPx(5), this.anchorHeight / 2);
                } else {
                    layoutParamsEmojiView.setMargins(IntExtensionsKt.getPx(5) * marginFactor, IntExtensionsKt.getPx(8), IntExtensionsKt.getPx(5) * marginFactor, this.anchorHeight / 2);
                }
            }
            emojiView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsEmojiView);
            emojiListView.addView((View)emojiView);
            List<Media> list7 = this.emojiList;
            if (list7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
                list7 = null;
            }
            if (list7.size() > 1 && i == 0) {
                Context context5 = this.context;
                if (context5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    context5 = null;
                }
                View divider = new View(context5);
                LinearLayout.LayoutParams lParams = new LinearLayout.LayoutParams(IntExtensionsKt.getPx(2), this.anchorHeight);
                lParams.gravity = 17;
                lParams.setMargins(IntExtensionsKt.getPx(4), -(this.anchorHeight / 2 - IntExtensionsKt.getPx(8)) / 2, IntExtensionsKt.getPx(4), IntExtensionsKt.getPx(0));
                divider.setLayoutParams((ViewGroup.LayoutParams)lParams);
                divider.setBackgroundColor(this.dividerColor);
                emojiListView.addView(divider);
            }
            ++i;
        }
        Rect emojiListViewSize = this.getViewSize((View)emojiListView);
        this.emojiListViewWidth = emojiListViewSize.width();
        if (this.emojiListViewWidth > this.getDisplaySize().width()) {
            this.emojiListViewWidth = this.getDisplaySize().width() - IntExtensionsKt.getPx(10);
        }
        if ((context = this.context) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        HorizontalScrollView scroll = new HorizontalScrollView(context);
        scroll.setHorizontalScrollBarEnabled(false);
        float cornerRadius = 0.4f * (float)this.anchorWidth;
        LinearLayout.LayoutParams scrollLayoutParams = new LinearLayout.LayoutParams(this.emojiListViewWidth, -1);
        scrollLayoutParams.setMargins(-((int)cornerRadius) / 4, 0, -((int)cornerRadius) / 4, 0);
        scroll.setLayoutParams((ViewGroup.LayoutParams)scrollLayoutParams);
        scroll.addView((View)emojiListView);
        scroll.setBackgroundColor(0);
        Context context6 = this.context;
        if (context6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context6 = null;
        }
        LinearLayout scrollContentView = new LinearLayout(context6);
        LinearLayout.LayoutParams scrollContentViewLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        scrollContentViewLayoutParams.setMargins((int)cornerRadius / 4, 0, (int)cornerRadius / 4, 0);
        scrollContentView.setLayoutParams((ViewGroup.LayoutParams)scrollContentViewLayoutParams);
        contentView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        scrollContentView.addView((View)scroll);
        contentView.addView((View)scrollContentView);
        Context context7 = this.context;
        if (context7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context7 = null;
        }
        this.anchorPlaceHolderView = new View(context7);
        LinearLayout.LayoutParams anchorPlaceHolderViewLayoutParams = new LinearLayout.LayoutParams(this.anchorWidth, this.anchorHeight);
        anchorPlaceHolderViewLayoutParams.gravity = 17;
        View view = this.anchorPlaceHolderView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anchorPlaceHolderView");
            view = null;
        }
        view.setLayoutParams((ViewGroup.LayoutParams)anchorPlaceHolderViewLayoutParams);
        View view2 = this.anchorPlaceHolderView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anchorPlaceHolderView");
            view2 = null;
        }
        contentView.addView(view2);
        this.emojiDrawerViewHeight = emojiListViewSize.height() + this.anchorHeight;
        float translationX = 0.0f;
        if ((float)touchX < (float)this.emojiListViewWidth / 2.0f) {
            translationX = (float)touchX - (float)this.emojiListViewWidth / 2.0f;
        } else if ((float)(displayWidth - touchX) < (float)this.emojiListViewWidth / 2.0f) {
            translationX = (float)this.emojiListViewWidth / 2.0f - (float)displayWidth + (float)touchX;
            if (this.emojiListViewWidth > displayWidth) {
                translationX -= (float)(this.emojiListViewWidth - displayWidth);
            }
        }
        float widerAnchorWidth = (float)this.anchorWidth * 1.35f;
        Context context8 = this.context;
        if (context8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context8 = null;
        }
        int orientation = context8.getResources().getConfiguration().orientation;
        float factualAnchorHeight = this.anchorHeight;
        if (orientation == 2) {
            factualAnchorHeight = 0.0f;
        }
        Path contentViewPath = this.getDrawerPath(this.emojiListViewWidth, (float)emojiListViewSize.height() - (float)(this.anchorHeight / 2) + (float)IntExtensionsKt.getPx(8), translationX + ((float)this.emojiListViewWidth + widerAnchorWidth + cornerRadius) / (float)2, widerAnchorWidth, factualAnchorHeight, cornerRadius, 0.0f, IntExtensionsKt.getPx(4));
        Drawable contentViewDrawable = this.getDrawable(emojiListViewSize.width(), emojiListViewSize.height(), contentViewPath, null, Float.valueOf(cornerRadius / (float)2), this.backgroundColorGradientTop, this.backgroundColorGradientBottom);
        contentView.setBackground(contentViewDrawable);
        contentView.setClipChildren(true);
        PopupWindow popupWindow = this.popupWindow = new PopupWindow((View)contentView, this.emojiListViewWidth, this.emojiDrawerViewHeight, true);
        Intrinsics.checkNotNull((Object)popupWindow);
        popupWindow.setOnDismissListener(() -> GPHEmojiDrawer.createPopupWindowIfNeeded$lambda$4(this));
    }

    private static final boolean createPopupWindowIfNeeded$lambda$1(GPHEmojiDrawer this$0, View view, MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hide();
        return false;
    }

    private static final void createPopupWindowIfNeeded$lambda$2(GPHEmojiDrawer this$0, int $i, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Function1<? super Media, Unit> function1 = this$0.onEmojiSelected;
        List<Media> list = this$0.emojiList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
            list = null;
        }
        function1.invoke((Object)list.get($i));
        this$0.hide();
    }

    private static final boolean createPopupWindowIfNeeded$lambda$3(GPHEmojiDrawer this$0, int $i, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Function1<? super Media, Unit> function1 = this$0.onEmojiPressed;
        List<Media> list = this$0.emojiList;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emojiList");
            list = null;
        }
        function1.invoke((Object)list.get($i));
        return true;
    }

    private static final void createPopupWindowIfNeeded$lambda$4(GPHEmojiDrawer this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.hide();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/giphy/sdk/ui/views/GPHEmojiDrawer$Styles;", "", "()V", "DIVIDER_WIDTH", "", "EMOJI_DIVIDER_MARGIN_HORIZONTAL", "EMOJI_VIEW_CELL_PADDING_HORIZONTAL", "EMOJI_VIEW_MARGIN_HORIZONTAL", "EMOJI_VIEW_MARGIN_VERTICAL", "giphy-ui-2.3.17_release"})
    public static final class Styles {
        private Styles() {
        }

        public /* synthetic */ Styles(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

