/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.utils;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.giphy.sdk.core.models.Image;
import com.giphy.sdk.core.models.Media;
import com.giphy.sdk.core.models.enums.RenditionType;
import com.giphy.sdk.ui.drawables.ImageFormat;
import com.giphy.sdk.ui.drawables.ImageUriInfo;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lcom/giphy/sdk/ui/utils/GifUtils;", "", "()V", "getImageDataForType", "Lcom/giphy/sdk/core/models/Image;", "gif", "Lcom/giphy/sdk/core/models/Media;", "imageType", "Lcom/giphy/sdk/core/models/enums/RenditionType;", "getImageToLoad", "Lcom/giphy/sdk/ui/drawables/ImageUriInfo;", "imageData", "imageFormat", "Lcom/giphy/sdk/ui/drawables/ImageFormat;", "getViewGifIntent", "Landroid/content/Intent;", "media", "imageToImageUriInfo", "image", "giphy-ui-2.3.17_release"})
public final class GifUtils {
    @NotNull
    public static final GifUtils INSTANCE = new GifUtils();

    private GifUtils() {
    }

    @Nullable
    public final Image getImageDataForType(@Nullable Media gif, @NotNull RenditionType imageType) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        switch (WhenMappings.$EnumSwitchMapping$0[imageType.ordinal()]) {
            case 1: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getOriginal();
                    break;
                }
                image = null;
                break;
            }
            case 2: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getDownsized();
                    break;
                }
                image = null;
                break;
            }
            case 3: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getDownsizedMedium();
                    break;
                }
                image = null;
                break;
            }
            case 4: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getDownsizedLarge();
                    break;
                }
                image = null;
                break;
            }
            case 5: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getFixedWidth();
                    break;
                }
                image = null;
                break;
            }
            case 6: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getFixedWidthDownsampled();
                    break;
                }
                image = null;
                break;
            }
            case 7: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getFixedWidthStill();
                    break;
                }
                image = null;
                break;
            }
            case 8: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getLooping();
                    break;
                }
                image = null;
                break;
            }
            case 9: {
                Parcelable parcelable = gif;
                if (parcelable != null && (parcelable = parcelable.getImages()) != null) {
                    image = parcelable.getFixedHeight();
                    break;
                }
                image = null;
                break;
            }
            default: {
                image = null;
            }
        }
        return image;
    }

    @Nullable
    public final ImageUriInfo imageToImageUriInfo(@Nullable Image image, @NotNull ImageFormat imageFormat) {
        ImageUriInfo imageUriInfo;
        Intrinsics.checkNotNullParameter((Object)((Object)imageFormat), (String)"imageFormat");
        switch (WhenMappings.$EnumSwitchMapping$1[imageFormat.ordinal()]) {
            case 1: {
                Image image2 = image;
                Intrinsics.checkNotNull((Object)image2);
                if (image2.getWebPUrl() != null) {
                    Uri uri = Uri.parse((String)image.getWebPUrl());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.webPUrl)");
                    imageUriInfo = new ImageUriInfo(uri, image.getWebPSize(), imageFormat);
                    break;
                }
                imageUriInfo = null;
                break;
            }
            case 2: {
                Image image3 = image;
                Intrinsics.checkNotNull((Object)image3);
                if (image3.getMp4Url() != null) {
                    Uri uri = Uri.parse((String)image.getMp4Url());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.mp4Url)");
                    imageUriInfo = new ImageUriInfo(uri, image.getMp4Size(), imageFormat);
                    break;
                }
                imageUriInfo = null;
                break;
            }
            case 3: {
                Image image4 = image;
                Intrinsics.checkNotNull((Object)image4);
                if (image4.getGifUrl() != null) {
                    Uri uri = Uri.parse((String)image.getGifUrl());
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(image.gifUrl)");
                    imageUriInfo = new ImageUriInfo(uri, image.getGifSize(), imageFormat);
                    break;
                }
                imageUriInfo = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ImageUriInfo imageUriInfo2 = imageUriInfo;
        return imageUriInfo2;
    }

    @Nullable
    public final ImageUriInfo getImageToLoad(@NotNull Image imageData, @Nullable ImageFormat imageFormat) {
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        if (imageFormat != null) {
            return this.imageToImageUriInfo(imageData, imageFormat);
        }
        return TextUtils.isEmpty((CharSequence)imageData.getWebPUrl()) ? this.imageToImageUriInfo(imageData, ImageFormat.GIF) : this.imageToImageUriInfo(imageData, ImageFormat.WEBP);
    }

    @NotNull
    public final Intent getViewGifIntent(@Nullable Media media) {
        Intent intent = new Intent("android.intent.action.VIEW");
        Media media2 = media;
        intent.setData(Uri.parse((String)(media2 != null ? media2.getUrl() : null)));
        intent.setFlags(0x10000000);
        return intent;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RenditionType.values().length];
            try {
                nArray[RenditionType.original.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.downsized.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.downsizedMedium.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.downsizedLarge.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.fixedWidth.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.fixedWidthDownsampled.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.fixedWidthStill.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.looping.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenditionType.fixedHeight.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ImageFormat.values().length];
            try {
                nArray[ImageFormat.WEBP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFormat.MP4.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageFormat.GIF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

