/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"tintedWithColor", "Landroid/graphics/Bitmap;", "color", "", "tintedWithLinearGradientColors", "colors", "", "giphy-ui-2.3.17_release"})
public final class BitmapExtensionsKt {
    @NotNull
    public static final Bitmap tintedWithLinearGradientColors(@NotNull Bitmap $this$tintedWithLinearGradientColors, @NotNull int[] colors) {
        Intrinsics.checkNotNullParameter((Object)$this$tintedWithLinearGradientColors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        int width = $this$tintedWithLinearGradientColors.getWidth();
        int height = $this$tintedWithLinearGradientColors.getHeight();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        updatedBitmap.setDensity($this$tintedWithLinearGradientColors.getDensity());
        Canvas canvas = new Canvas(updatedBitmap);
        canvas.drawBitmap($this$tintedWithLinearGradientColors, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        LinearGradient shader = new LinearGradient(0.0f, 100.0f, 100.0f, 0.0f, colors[0], colors[1], Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, paint);
        Intrinsics.checkNotNullExpressionValue((Object)updatedBitmap, (String)"updatedBitmap");
        return updatedBitmap;
    }

    @NotNull
    public static final Bitmap tintedWithColor(@NotNull Bitmap $this$tintedWithColor, int color2) {
        Intrinsics.checkNotNullParameter((Object)$this$tintedWithColor, (String)"<this>");
        int width = $this$tintedWithColor.getWidth();
        int height = $this$tintedWithColor.getHeight();
        Bitmap updatedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        updatedBitmap.setDensity($this$tintedWithColor.getDensity());
        Canvas canvas = new Canvas(updatedBitmap);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap($this$tintedWithColor, 0.0f, 0.0f, paint);
        Intrinsics.checkNotNullExpressionValue((Object)updatedBitmap, (String)"updatedBitmap");
        return updatedBitmap;
    }
}

