/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.ui.drawables;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.core.content.ContextCompat;
import com.giphy.sdk.ui.R;
import com.giphy.sdk.ui.utils.IntExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/giphy/sdk/ui/drawables/GPHBrandingDrawer;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "alphaAnimator", "Landroid/animation/ValueAnimator;", "kotlin.jvm.PlatformType", "bounds", "Landroid/graphics/Rect;", "brandingHeight", "", "getContext", "()Landroid/content/Context;", "drawable", "Landroid/graphics/drawable/Drawable;", "offset", "draw", "", "canvas", "Landroid/graphics/Canvas;", "startAnimation", "giphy-ui-2.3.17_release"})
public final class GPHBrandingDrawer {
    @NotNull
    private final Context context;
    @NotNull
    private final Drawable drawable;
    private ValueAnimator alphaAnimator;
    private final int offset;
    private final int brandingHeight;
    @NotNull
    private Rect bounds;

    public GPHBrandingDrawer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.gph_gif_branding);
        Intrinsics.checkNotNull((Object)drawable2);
        Drawable drawable3 = drawable2.mutate();
        Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"getDrawable(context, R.d\u2026_gif_branding)!!.mutate()");
        this.drawable = drawable3;
        int[] nArray = new int[]{255, 0};
        this.alphaAnimator = ValueAnimator.ofInt((int[])nArray);
        this.offset = IntExtensionsKt.getPx(10);
        this.brandingHeight = IntExtensionsKt.getPx(12);
        this.bounds = new Rect();
        this.drawable.setAlpha(0);
        this.alphaAnimator.setDuration(800L);
        this.alphaAnimator.setStartDelay(1000L);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void startAnimation() {
        Timber.d((String)"startAnimation", (Object[])new Object[0]);
        this.drawable.setAlpha(255);
        ValueAnimator valueAnimator = this.alphaAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.alphaAnimator.addUpdateListener(arg_0 -> GPHBrandingDrawer.startAnimation$lambda$0(this, arg_0));
        this.alphaAnimator.start();
    }

    public final void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.bounds.left = canvas.getClipBounds().right - this.offset - this.drawable.getIntrinsicWidth() / this.drawable.getIntrinsicHeight() * this.brandingHeight;
        this.bounds.top = canvas.getClipBounds().bottom - this.brandingHeight - this.offset;
        this.bounds.right = canvas.getClipBounds().right - this.offset;
        this.bounds.bottom = canvas.getClipBounds().bottom - this.offset;
        this.drawable.setBounds(this.bounds);
        this.drawable.draw(canvas);
    }

    private static final void startAnimation$lambda$0(GPHBrandingDrawer this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Drawable drawable2 = this$0.drawable;
        Object object = it.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        drawable2.setAlpha(((Integer)object).intValue());
    }
}

