/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.tracking;

import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import com.giphy.sdk.tracking.GifTrackingManager;
import com.giphy.sdk.tracking.GifTrackingManager_PixelsKt;
import com.giphy.sdk.tracking.PixelMacro;
import com.giphy.sdk.tracking.ViewDimensions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\"\b\u0002\u0010\u000f\u001a\u001c\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\t0\u0010\u001a,\u0010\u0012\u001a\u00020\t2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0003\u001a\u001c\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a$\u0010\u0012\u001a\u00020\t*\u00020\u001d2\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006 "}, d2={"formatter", "Ljava/text/SimpleDateFormat;", "timeZoneValue", "", "getTimeZoneValue", "()Ljava/lang/String;", "timestampFormatted", "getTimestampFormatted", "firePixel", "", "urlString", "retries", "", "delayMillis", "", "callback", "Lkotlin/Function3;", "", "fireTags", "tags", "", "viewDimensions", "Lcom/giphy/sdk/tracking/ViewDimensions;", "userId", "insertMacrosFor", "url", "value", "macro", "Lcom/giphy/sdk/tracking/PixelMacro;", "Lcom/giphy/sdk/tracking/GifTrackingManager;", "view", "Landroid/view/View;", "giphy-ui-2.3.17_release"})
public final class GifTrackingManager_PixelsKt {
    @NotNull
    private static final SimpleDateFormat formatter;

    private static final String getTimeZoneValue() {
        TimeZone tz = TimeZone.getDefault();
        boolean isDaylight = tz.inDaylightTime(new Date());
        String string = tz.getDisplayName(isDaylight, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tz.getDisplayName(isDaylight, TimeZone.SHORT)");
        return string;
    }

    private static final String getTimestampFormatted() {
        Date now = new Date();
        String timestamp = Build.VERSION.SDK_INT >= 26 ? now.toInstant().atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) : formatter.format(now);
        return URLEncoder.encode(timestamp, "UTF-8");
    }

    private static final String insertMacrosFor(String url, ViewDimensions viewDimensions) {
        String updatedUrl = url;
        for (PixelMacro pixelMacro : PixelMacro.values()) {
            String key = pixelMacro.name();
            String string = GifTrackingManager_PixelsKt.value(viewDimensions, pixelMacro);
            if (string == null) {
                string = "unknown";
            }
            String value = string;
            updatedUrl = StringsKt.replace$default((String)StringsKt.replace$default((String)updatedUrl, (String)"%25", (String)"%", (boolean)false, (int)4, null), (String)("%%" + key + "%%"), (String)value, (boolean)false, (int)4, null);
        }
        return updatedUrl;
    }

    static /* synthetic */ String insertMacrosFor$default(String string, ViewDimensions viewDimensions, int n, Object object) {
        if ((n & 2) != 0) {
            viewDimensions = null;
        }
        return GifTrackingManager_PixelsKt.insertMacrosFor(string, viewDimensions);
    }

    private static final String value(ViewDimensions viewDimensions, PixelMacro macro) {
        String string;
        if (viewDimensions == null) {
            return macro.value();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[macro.ordinal()]) {
            case 1: {
                string = "" + viewDimensions.getWidth() + ',' + viewDimensions.getHeight();
                break;
            }
            case 2: {
                string = "" + viewDimensions.getLocationInWindowX() + ',' + viewDimensions.getLocationInWindowY();
                break;
            }
            case 3: {
                string = "" + viewDimensions.getWindowSizeWidth() + ',' + viewDimensions.getWindowSizeHeight();
                break;
            }
            default: {
                string = macro.value();
            }
        }
        return string;
    }

    public static final void fireTags(@NotNull GifTrackingManager $this$fireTags, @Nullable List<String> tags, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)$this$fireTags, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (tags == null) {
            return;
        }
        int[] locationInWindow = new int[2];
        view.getLocationInWindow(locationInWindow);
        DisplayMetrics windowSize = view.getContext().getResources().getDisplayMetrics();
        GifTrackingManager_PixelsKt.fireTags(tags, new ViewDimensions(view.getWidth(), view.getHeight(), locationInWindow[0], locationInWindow[1], windowSize.widthPixels, windowSize.heightPixels), $this$fireTags.getUserId());
    }

    public static final void fireTags(@Nullable List<String> tags, @Nullable ViewDimensions viewDimensions, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (tags == null) {
            return;
        }
        for (String tag : tags) {
            String url = GifTrackingManager_PixelsKt.insertMacrosFor(tag, viewDimensions);
            if (((CharSequence)userId).length() > 0) {
                url = StringsKt.replace$default((String)url, (String)"%%GIPHY_USER_ID%%", (String)userId, (boolean)false, (int)4, null);
            }
            GifTrackingManager_PixelsKt.firePixel$default(url, 0, 0L, null, 14, null);
        }
    }

    public static /* synthetic */ void fireTags$default(List list, ViewDimensions viewDimensions, String string, int n, Object object) {
        if ((n & 2) != 0) {
            viewDimensions = null;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        GifTrackingManager_PixelsKt.fireTags(list, viewDimensions, string);
    }

    public static final void firePixel(@NotNull String urlString, int retries, long delayMillis, @NotNull Function3<? super Boolean, ? super String, ? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(retries, urlString, callback, delayMillis, null){
            int I$0;
            int label;
            final /* synthetic */ int $retries;
            final /* synthetic */ String $urlString;
            final /* synthetic */ Function3<Boolean, String, String, Unit> $callback;
            final /* synthetic */ long $delayMillis;
            {
                this.$retries = $retries;
                this.$urlString = $urlString;
                this.$callback = $callback;
                this.$delayMillis = $delayMillis;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block5 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        attempts = 0;
lbl6:
                        // 2 sources

                        while (attempts < this.$retries) {
                            try {
                                url = new URL(this.$urlString);
                                var5_7 = url.openConnection();
                                Intrinsics.checkNotNull((Object)var5_7, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                                connection = (HttpURLConnection)var5_7;
                                connection.setRequestMethod("GET");
                                connection.setConnectTimeout(5000);
                                connection.setReadTimeout(5000);
                                if (connection.getResponseCode() != 200) ** GOTO lbl40
                                var6_17 /* !! */  = connection.getInputStream();
                                Intrinsics.checkNotNullExpressionValue((Object)var6_17 /* !! */ , (String)"connection.inputStream");
                                var7_18 = Charsets.UTF_8;
                                var8_8 = new InputStreamReader(var6_17 /* !! */ , (Charset)var7_18);
                                var9_12 = 8192;
                                var6_17 /* !! */  = var8_8 instanceof BufferedReader != false ? (BufferedReader)var8_8 : new BufferedReader((Reader)var8_8, var9_12);
                                var7_18 = null;
                                try {
                                    it = (BufferedReader)var6_17 /* !! */ ;
                                    $i$a$-use-GifTrackingManager_PixelsKt$firePixel$2$response$1 = false;
                                    var8_8 = TextStreamsKt.readText((Reader)it);
                                }
                                catch (Throwable var8_9) {
                                    var7_18 = var8_9;
                                    throw var8_9;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)var6_17 /* !! */ , (Throwable)var7_18);
                                }
                                response = var8_8;
                                this.$callback.invoke((Object)Boxing.boxBoolean((boolean)true), (Object)("Request successful: " + this.$urlString), response);
                                break block5;
lbl40:
                                // 1 sources

                                v0 = connection.getErrorStream();
                                if (v0 != null) {
                                    var8_8 = v0;
                                    var9_11 = Charsets.UTF_8;
                                    var10_13 = new InputStreamReader((InputStream)var8_8, (Charset)var9_11);
                                    var11_16 = 8192;
                                    var8_8 = var10_13 instanceof BufferedReader != false ? (BufferedReader)var10_13 : new BufferedReader((Reader)var10_13, var11_16);
                                    var9_11 = null;
                                    try {
                                        it = (BufferedReader)var8_8;
                                        $i$a$-use-GifTrackingManager_PixelsKt$firePixel$2$errorResponse$1 = false;
                                        var10_13 = TextStreamsKt.readText((Reader)it);
                                        v1 = var10_13;
                                    }
                                    catch (Throwable var10_14) {
                                        var9_11 = var10_14;
                                        throw var10_14;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)var8_8, (Throwable)var9_11);
                                    }
                                } else {
                                    v1 = null;
                                }
                                errorResponse = v1;
                                this.$callback.invoke((Object)Boxing.boxBoolean((boolean)false), (Object)("Failed with HTTP code: " + connection.getResponseCode()), errorResponse);
                                ** GOTO lbl82
                            }
                            catch (IOException e) {
                                if (attempts >= this.$retries - 1) {
                                    this.$callback.invoke((Object)Boxing.boxBoolean((boolean)false), (Object)("Failed after " + this.$retries + " attempts: " + this.$urlString + ", Error: " + e.getMessage()), null);
                                    break block5;
                                }
                                this.I$0 = attempts;
                                this.label = 1;
                                v2 = DelayKt.delay((long)this.$delayMillis, (Continuation)((Continuation)this));
                                if (v2 == var12_2) {
                                    return var12_2;
                                }
                                ** GOTO lbl82
                            }
                        }
                        break;
                    }
                    case 1: {
                        attempts = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl82:
                        // 3 sources

                        ++attempts;
                        ** GOTO lbl6
                    }
                }
                this.$callback.invoke((Object)Boxing.boxBoolean((boolean)false), (Object)("Request failed: " + this.$urlString), null);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void firePixel$default(String string, int n, long l, Function3 function3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        if ((n2 & 4) != 0) {
            l = 1000L;
        }
        if ((n2 & 8) != 0) {
            function3 = firePixel.1.INSTANCE;
        }
        GifTrackingManager_PixelsKt.firePixel(string, n, l, (Function3<? super Boolean, ? super String, ? super String, Unit>)function3);
    }

    public static final /* synthetic */ String access$getTimestampFormatted() {
        return GifTrackingManager_PixelsKt.getTimestampFormatted();
    }

    public static final /* synthetic */ String access$getTimeZoneValue() {
        return GifTrackingManager_PixelsKt.getTimeZoneValue();
    }

    static {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $this$formatter_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        boolean bl = false;
        $this$formatter_u24lambda_u240.setTimeZone(TimeZone.getTimeZone("UTC"));
        formatter = simpleDateFormat;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PixelMacro.values().length];
            try {
                nArray[PixelMacro.AD_DISPLAY_SIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelMacro.AD_DISPLAY_POSITION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PixelMacro.APP_WINDOW_SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

