/*
 * Decompiled with CFR 0.152.
 */
package com.giphy.sdk.core.network.engine;

import android.net.Uri;
import android.util.Log;
import com.giphy.sdk.core.models.Meta;
import com.giphy.sdk.core.models.json.BooleanDeserializer;
import com.giphy.sdk.core.models.json.DateDeserializer;
import com.giphy.sdk.core.models.json.DateSerializer;
import com.giphy.sdk.core.models.json.IntDeserializer;
import com.giphy.sdk.core.models.json.MainAdapterFactory;
import com.giphy.sdk.core.network.api.GPHApiClient;
import com.giphy.sdk.core.network.engine.ApiException;
import com.giphy.sdk.core.network.engine.NetworkSession;
import com.giphy.sdk.core.network.response.ErrorResponse;
import com.giphy.sdk.core.threading.ApiTask;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.brotli.dec.BrotliInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007Jr\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016Jh\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001a2\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001aH\u0016J3\u0010\u001f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0002\u00a2\u0006\u0002\u0010$R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/giphy/sdk/core/network/engine/DefaultNetworkSession;", "Lcom/giphy/sdk/core/network/engine/NetworkSession;", "()V", "networkRequestExecutor", "Ljava/util/concurrent/ExecutorService;", "completionExecutor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/Executor;)V", "getCompletionExecutor", "()Ljava/util/concurrent/Executor;", "completionExecutor1", "getNetworkRequestExecutor", "()Ljava/util/concurrent/ExecutorService;", "networkRequestExecutor1", "postStringConnection", "Lcom/giphy/sdk/core/threading/ApiTask;", "T", "serverUrl", "Landroid/net/Uri;", "path", "", "method", "Lcom/giphy/sdk/core/network/api/GPHApiClient$HTTPMethod;", "responseClass", "Ljava/lang/Class;", "queryStrings", "", "headers", "requestBody", "", "queryStringConnection", "readJsonResponse", "url", "Ljava/net/URL;", "connection", "Ljava/net/HttpURLConnection;", "(Ljava/net/URL;Ljava/net/HttpURLConnection;Ljava/lang/Class;)Ljava/lang/Object;", "Companion", "giphy-ui-2.3.17_release"})
@SourceDebugExtension(value={"SMAP\nDefaultNetworkSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNetworkSession.kt\ncom/giphy/sdk/core/network/engine/DefaultNetworkSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
public final class DefaultNetworkSession
implements NetworkSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService networkRequestExecutor1;
    @NotNull
    private final Executor completionExecutor1;
    @NotNull
    private static final Gson GSON_INSTANCE;

    public DefaultNetworkSession() {
        this.networkRequestExecutor1 = ApiTask.Companion.getNetworkRequestExecutor();
        this.completionExecutor1 = ApiTask.Companion.getCompletionExecutor();
    }

    public DefaultNetworkSession(@NotNull ExecutorService networkRequestExecutor, @NotNull Executor completionExecutor) {
        Intrinsics.checkNotNullParameter((Object)networkRequestExecutor, (String)"networkRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)completionExecutor, (String)"completionExecutor");
        this.networkRequestExecutor1 = networkRequestExecutor;
        this.completionExecutor1 = completionExecutor;
    }

    @Override
    @NotNull
    public ExecutorService getNetworkRequestExecutor() {
        return this.networkRequestExecutor1;
    }

    @Override
    @NotNull
    public Executor getCompletionExecutor() {
        return this.completionExecutor1;
    }

    @Override
    @NotNull
    public <T> ApiTask<T> queryStringConnection(@NotNull Uri serverUrl, @Nullable String path, @NotNull GPHApiClient.HTTPMethod method, @NotNull Class<T> responseClass, @Nullable Map<String, String> queryStrings, @Nullable Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        return this.postStringConnection(serverUrl, path, method, responseClass, queryStrings, headers, null);
    }

    @Override
    @NotNull
    public <T> ApiTask<T> postStringConnection(@NotNull Uri serverUrl, @Nullable String path, @NotNull GPHApiClient.HTTPMethod method, @NotNull Class<T> responseClass, @Nullable Map<String, String> queryStrings, @Nullable Map<String, String> headers, @Nullable Object requestBody) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter(responseClass, (String)"responseClass");
        return new ApiTask<Object>(() -> DefaultNetworkSession.postStringConnection$lambda$1(serverUrl, path, queryStrings, method, headers, requestBody, this, responseClass), this.getNetworkRequestExecutor(), this.getCompletionExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T readJsonResponse(URL url, HttpURLConnection connection, Class<T> responseClass) throws IOException, ApiException {
        Object encoding;
        InputStream inputStream;
        int responseCode = connection.getResponseCode();
        boolean succeeded = responseCode == 200 || responseCode == 201 || responseCode == 202 || responseCode == 204;
        String contents = null;
        Map<String, List<String>> responseHeaders = connection.getHeaderFields();
        if (succeeded) {
            InputStream inputStream2 = connection.getInputStream();
            inputStream = inputStream2;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"connection.inputStream");
        } else {
            InputStream inputStream3 = connection.getErrorStream();
            inputStream = inputStream3;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"connection.errorStream");
        }
        InputStream stream = inputStream;
        if (responseHeaders.containsKey("Content-Encoding")) {
            List<String> list = responseHeaders.get("Content-Encoding");
            Intrinsics.checkNotNull(list);
            encoding = list;
            if (!Thread.currentThread().isInterrupted()) {
            } else {
                throw new InterruptedIOException();
            }
            stream = encoding.contains("gzip") ? (InputStream)new GZIPInputStream(stream) : (encoding.contains("br") ? (InputStream)new BrotliInputStream(stream) : stream);
        }
        encoding = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)encoding;
            boolean bl = false;
            InputStream inputStream4 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n = 8192;
            contents = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)encoding, (Throwable)throwable);
        }
        if (succeeded) {
            if (!Intrinsics.areEqual(responseClass, String.class)) {
                try {
                    if (!StringsKt.startsWith$default((String)contents, (String)"{", (boolean)false, (int)2, null)) {
                        contents = "{}";
                    }
                    return (T)GSON_INSTANCE.fromJson(contents, responseClass);
                }
                catch (JsonParseException e) {
                    return responseClass.newInstance();
                }
            }
        } else {
            try {
                ErrorResponse errorResponse;
                if (!StringsKt.startsWith$default((String)contents, (String)"{", (boolean)false, (int)2, null)) {
                    contents = "{\"error\": \"" + contents + "\"}";
                }
                if ((errorResponse = (ErrorResponse)GSON_INSTANCE.fromJson(contents, ErrorResponse.class)).getMeta() == null) {
                    errorResponse.setMeta(new Meta(responseCode, errorResponse.getMessage(), null, 4, null));
                }
                Intrinsics.checkNotNullExpressionValue((Object)errorResponse, (String)"errorResponse");
                throw new ApiException(errorResponse);
            }
            catch (JsonParseException e) {
                throw new ApiException("Unable to parse server error response : " + url + " : " + contents + " : " + e.getMessage(), new ErrorResponse(responseCode, contents));
            }
        }
        return (T)contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object postStringConnection$lambda$1(Uri $serverUrl, String $path, Map $queryStrings, GPHApiClient.HTTPMethod $method, Map $headers, Object $requestBody, DefaultNetworkSession this$0, Class $responseClass) {
        Intrinsics.checkNotNullParameter((Object)$serverUrl, (String)"$serverUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)$method), (String)"$method");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$responseClass, (String)"$responseClass");
        HttpURLConnection connection = null;
        URL url = null;
        try {
            Object postDataBytes;
            String value;
            Uri.Builder uriBuilder = $serverUrl.buildUpon();
            String string = $path;
            if (string != null) {
                String object = string;
                boolean bl = false;
                uriBuilder.appendEncodedPath($path);
            }
            if ($queryStrings != null) {
                for (Map.Entry entry : $queryStrings.entrySet()) {
                    String key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    uriBuilder.appendQueryParameter(key, value);
                }
            }
            url = new URL(uriBuilder.build().toString());
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod($method.name());
            if ($headers != null) {
                for (Map.Entry entry : $headers.entrySet()) {
                    String key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    connection.setRequestProperty(key, value);
                }
            }
            if ($method == GPHApiClient.HTTPMethod.POST) {
                connection.setDoOutput(true);
                connection.connect();
                if ($requestBody != null) {
                    String string2 = GSON_INSTANCE.toJson($requestBody);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GSON_INSTANCE.toJson(requestBody)");
                    String string3 = string2;
                    Charset charset = Charset.forName("UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                    Charset charset2 = charset;
                    byte[] byArray = string3.getBytes(charset2);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    postDataBytes = byArray;
                    connection.getOutputStream().write((byte[])postDataBytes);
                }
            } else {
                connection.connect();
            }
            postDataBytes = this$0.readJsonResponse(url, connection, $responseClass);
            connection.disconnect();
            return postDataBytes;
        }
        catch (Throwable t) {
            try {
                if (!(t instanceof InterruptedIOException) && !(t instanceof InterruptedException)) {
                    String string = NetworkSession.class.getName();
                    StringBuilder stringBuilder = new StringBuilder().append("Unable to perform network request for url=");
                    URL uRL = url;
                    Intrinsics.checkNotNull((Object)uRL);
                    Log.e((String)string, (String)stringBuilder.append(uRL).toString(), (Throwable)t);
                }
                throw t;
            }
            catch (Throwable throwable) {
                block13: {
                    HttpURLConnection httpURLConnection = connection;
                    if (httpURLConnection == null) break block13;
                    httpURLConnection.disconnect();
                }
                throw throwable;
            }
        }
    }

    static {
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new DateDeserializer()).registerTypeHierarchyAdapter(Date.class, (Object)new DateSerializer()).registerTypeHierarchyAdapter(Boolean.TYPE, (Object)new BooleanDeserializer()).registerTypeHierarchyAdapter(Integer.TYPE, (Object)new IntDeserializer()).registerTypeAdapterFactory((TypeAdapterFactory)new MainAdapterFactory()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026                .create()");
        GSON_INSTANCE = gson;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/giphy/sdk/core/network/engine/DefaultNetworkSession$Companion;", "", "()V", "GSON_INSTANCE", "Lcom/google/gson/Gson;", "getGSON_INSTANCE", "()Lcom/google/gson/Gson;", "giphy-ui-2.3.17_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGSON_INSTANCE() {
            return GSON_INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

