/*
 * Decompiled with CFR 0.152.
 */
package com.ginsberg.junit.exit.agent;

import com.ginsberg.junit.exit.agent.AgentSystemExitHandlerStrategy;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Set;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class Junit5SystemExitAgent {
    private static final Logger log = Logger.getLogger(Junit5SystemExitAgent.class.getName());
    private static final Set<String> disallowedClassPrefixes = Set.of("com/sun/", "java/", "jdk/", "worker/org/gradle/", "sun/");
    private static final String SKIP_ANNOTATION = "/DoNotRewriteExitCalls;";

    private Junit5SystemExitAgent() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        AgentSystemExitHandlerStrategy.agentInit();
        inst.addTransformer(new SystemExitClassTransformer());
    }

    static class SystemExitClassTransformer
    implements ClassFileTransformer {
        SystemExitClassTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
            if (disallowedClassPrefixes.stream().anyMatch(className::startsWith)) {
                return null;
            }
            ClassReader classReader = new ClassReader(classFileBuffer);
            ClassWriter classWriter = new ClassWriter(classReader, 0);
            classReader.accept((ClassVisitor)new SystemExitClassVisitor(className, (ClassVisitor)classWriter), 0);
            return classWriter.toByteArray();
        }
    }

    static class SystemExitMethodVisitor
    extends MethodVisitor {
        private boolean hasSkipAnnotation = false;
        private final String className;
        private final String methodName;

        public SystemExitMethodVisitor(String className, String methodName, MethodVisitor mv) {
            super(589824, mv);
            this.className = className;
            this.methodName = methodName;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.endsWith(Junit5SystemExitAgent.SKIP_ANNOTATION)) {
                this.hasSkipAnnotation = true;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (!this.hasSkipAnnotation && owner.equals("java/lang/System") && name.equals("exit")) {
                log.fine("Replacing System.exit() call in: " + this.className + "." + this.methodName);
                super.visitMethodInsn(184, "com/ginsberg/junit/exit/agent/AgentSystemExitHandlerStrategy", "handleExit", descriptor, false);
            } else {
                if (this.hasSkipAnnotation) {
                    log.fine("Not replacing System.exit() call in: " + this.className + "." + this.methodName + " due to presence of 'skip this' annotation");
                }
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        }
    }

    static class SystemExitClassVisitor
    extends ClassVisitor {
        private final String className;
        private boolean hasSkipAnnotation = false;

        public SystemExitClassVisitor(String className, ClassVisitor cv) {
            super(589824, cv);
            this.className = className;
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            if (descriptor.endsWith(Junit5SystemExitAgent.SKIP_ANNOTATION)) {
                this.hasSkipAnnotation = true;
            }
            return super.visitAnnotation(descriptor, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.hasSkipAnnotation) {
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
            return new SystemExitMethodVisitor(this.className, name, super.visitMethod(access, name, descriptor, signature, exceptions));
        }
    }
}

