/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.web.servlet.websocket;

import com.giffing.wicket.spring.boot.starter.web.servlet.websocket.WebSocketMessageBroadcaster;
import java.util.Collection;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketMessageSenderDefault
implements WebSocketMessageBroadcaster {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void send(IWebSocketPushMessage event) {
        Application application = Application.get();
        WebSocketSettings webSocketSettings = WebSocketSettings.Holder.get((Application)application);
        IWebSocketConnectionRegistry connectionRegistry = webSocketSettings.getConnectionRegistry();
        Collection connections = connectionRegistry.getConnections(application);
        this.log.trace("sending event to {} connections", (Object)connections.size());
        for (IWebSocketConnection connection : connections) {
            connection.sendMessage(event);
        }
    }
}

