/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.external.spring.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.request.Request;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecureWebSession
extends AuthenticatedWebSession {
    private static final long serialVersionUID = 1L;
    private static final String SPRING_SECURITY_CONTEXT_KEY = "SPRING_SECURITY_CONTEXT";
    @SpringBean(name="authenticationManager")
    private AuthenticationManager authenticationManager;
    private final HttpSession httpSession;

    public SecureWebSession(Request request) {
        super(request);
        this.httpSession = ((HttpServletRequest)request.getContainerRequest()).getSession(false);
        Injector.get().inject((Object)this);
    }

    public boolean authenticate(String username, String password) {
        try {
            Authentication auth = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
            if (auth.isAuthenticated()) {
                SecurityContextHolder.getContext().setAuthentication(auth);
                if (this.httpSession != null) {
                    this.httpSession.setAttribute(SPRING_SECURITY_CONTEXT_KEY, (Object)SecurityContextHolder.getContext());
                }
                return true;
            }
            return false;
        }
        catch (AuthenticationException e) {
            return false;
        }
    }

    public Roles getRoles() {
        Roles roles = new Roles();
        if (this.isSignedIn()) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                roles.add((Object)authority.getAuthority());
            }
        }
        return roles;
    }
}

