/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app.classscanner;

import com.giffing.wicket.spring.boot.context.scan.WicketAccessDeniedPage;
import com.giffing.wicket.spring.boot.context.scan.WicketExpiredPage;
import com.giffing.wicket.spring.boot.context.scan.WicketHomePage;
import com.giffing.wicket.spring.boot.context.scan.WicketInternalErrorPage;
import com.giffing.wicket.spring.boot.context.scan.WicketSignInPage;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidate;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class ClassCandidateScanner
implements BeanClassLoaderAware {
    @Autowired
    private Environment environment;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private BeanFactory beanFactory;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Bean
    public WicketClassCandidatesHolder pageCandidates() {
        return new WicketClassCandidatesHolder();
    }

    @PostConstruct
    public void postConstruct() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.setEnvironment(this.environment);
        scanner.setResourceLoader(this.resourceLoader);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(SpringBootApplication.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketHomePage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketSignInPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketAccessDeniedPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketExpiredPage.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(WicketInternalErrorPage.class));
        for (String basePackage : ClassCandidateScanner.getMappingBasePackages(this.beanFactory)) {
            if (!StringUtils.hasText((String)basePackage)) continue;
            this.pageCandidates().getBasePackages().add(basePackage);
            Set beanDefinitions = scanner.findCandidateComponents(basePackage);
            for (BeanDefinition beanDefinition : beanDefinitions) {
                Class beanClass;
                try {
                    beanClass = ClassUtils.forName((String)beanDefinition.getBeanClassName(), (ClassLoader)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                if (beanClass.isAnnotationPresent(WicketHomePage.class)) {
                    this.pageCandidates().getHomePageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketSignInPage.class)) {
                    this.pageCandidates().getSignInPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketAccessDeniedPage.class)) {
                    this.pageCandidates().getAccessDeniedPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketExpiredPage.class)) {
                    this.pageCandidates().getExpiredPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (beanClass.isAnnotationPresent(WicketInternalErrorPage.class)) {
                    this.pageCandidates().getInternalErrorPageCandidates().add(new WicketClassCandidate(beanClass));
                }
                if (!beanClass.isAnnotationPresent(SpringBootApplication.class)) continue;
                this.pageCandidates().setSpringBootMainClass(beanClass);
            }
        }
    }

    private static Collection<String> getMappingBasePackages(BeanFactory beanFactory) {
        try {
            return AutoConfigurationPackages.get((BeanFactory)beanFactory);
        }
        catch (IllegalStateException ex) {
            return Collections.emptyList();
        }
    }
}

