/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.log4j;

import com.getsentry.raven.Raven;
import com.getsentry.raven.RavenFactory;
import com.getsentry.raven.config.Lookup;
import com.getsentry.raven.dsn.Dsn;
import com.getsentry.raven.dsn.InvalidDsnException;
import com.getsentry.raven.environment.RavenEnvironment;
import com.getsentry.raven.event.Event;
import com.getsentry.raven.event.EventBuilder;
import com.getsentry.raven.event.interfaces.ExceptionInterface;
import com.getsentry.raven.event.interfaces.SentryInterface;
import com.getsentry.raven.event.interfaces.StackTraceInterface;
import com.getsentry.raven.util.Util;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class SentryAppender
extends AppenderSkeleton {
    public static final String LOG4J_NDC = "log4J-NDC";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected volatile Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected String release;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();
    private volatile boolean initialized = false;

    public SentryAppender() {
        this.addFilter(new DropRavenFilter());
    }

    public SentryAppender(Raven raven) {
        this();
        this.raven = raven;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit() {
        if (!this.initialized) {
            SentryAppender sentryAppender = this;
            synchronized (sentryAppender) {
                if (!this.initialized) {
                    try {
                        String extraTags;
                        String tags;
                        String serverName;
                        String environment;
                        String release;
                        String ravenFactory = Lookup.lookup((String)"ravenFactory");
                        if (ravenFactory != null) {
                            this.setRavenFactory(ravenFactory);
                        }
                        if ((release = Lookup.lookup((String)"release")) != null) {
                            this.setRelease(release);
                        }
                        if ((environment = Lookup.lookup((String)"environment")) != null) {
                            this.setEnvironment(environment);
                        }
                        if ((serverName = Lookup.lookup((String)"serverName")) != null) {
                            this.setServerName(serverName);
                        }
                        if ((tags = Lookup.lookup((String)"tags")) != null) {
                            this.setTags(tags);
                        }
                        if ((extraTags = Lookup.lookup((String)"extraTags")) != null) {
                            this.setExtraTags(extraTags);
                        }
                    }
                    finally {
                        this.initialized = true;
                    }
                }
            }
        }
        if (this.raven == null) {
            this.initRaven();
        }
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual((Priority)Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isGreaterOrEqual((Priority)Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual((Priority)Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual((Priority)Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual((Priority)Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    protected static StackTraceElement asStackTraceElement(LocationInfo location) {
        String fileName = "?".equals(location.getFileName()) ? null : location.getFileName();
        int line = "?".equals(location.getLineNumber()) ? -1 : Integer.parseInt(location.getLineNumber());
        return new StackTraceElement(location.getClassName(), location.getMethodName(), fileName, line);
    }

    public void activateOptions() {
        super.activateOptions();
        this.lazyInit();
    }

    protected synchronized void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance((Dsn)new Dsn(this.dsn), (String)this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.getErrorHandler().error("An exception occurred during the retrieval of the DSN for Raven", (Exception)((Object)e), 6);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred during the creation of a Raven instance", e, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(LoggingEvent loggingEvent) {
        if (RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            this.lazyInit();
            Event event = this.buildEvent(loggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred while creating a new event in Raven", e, 1);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected Event buildEvent(LoggingEvent loggingEvent) {
        LocationInfo location;
        EventBuilder eventBuilder = new EventBuilder().withSdkName("raven-java:log4j").withTimestamp(new Date(loggingEvent.getTimeStamp())).withMessage(loggingEvent.getRenderedMessage()).withLogger(loggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(loggingEvent.getLevel())).withExtra(THREAD_NAME, (Object)loggingEvent.getThreadName());
        if (!Util.isNullOrEmpty((String)this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        if (!Util.isNullOrEmpty((String)this.release)) {
            eventBuilder.withRelease(this.release.trim());
        }
        if (!Util.isNullOrEmpty((String)this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        ThrowableInformation throwableInformation = null;
        try {
            throwableInformation = loggingEvent.getThrowableInformation();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (throwableInformation != null) {
            Throwable throwable = throwableInformation.getThrowable();
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (loggingEvent.getLocationInformation().fullInfo != null && !"?".equals((location = loggingEvent.getLocationInformation()).getFileName()) && !"?".equals(location.getLineNumber())) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{SentryAppender.asStackTraceElement(location)};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (loggingEvent.getLocationInformation().fullInfo != null) {
            eventBuilder.withCulprit(SentryAppender.asStackTraceElement(loggingEvent.getLocationInformation()));
        } else {
            eventBuilder.withCulprit(loggingEvent.getLoggerName());
        }
        if (loggingEvent.getNDC() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)loggingEvent.getNDC());
        }
        Map properties = loggingEvent.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            if (this.extraTags.contains(entry.getKey())) {
                eventBuilder.withTag((String)entry.getKey(), entry.getValue().toString());
                continue;
            }
            eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.tags.entrySet()) {
            eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags((String)tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags((String)extraTags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RavenEnvironment.startManagingThread();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.getErrorHandler().error("An exception occurred while closing the Raven connection", e, 3);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    private class DropRavenFilter
    extends Filter {
        private DropRavenFilter() {
        }

        public int decide(LoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("com.getsentry.raven")) {
                return -1;
            }
            return 0;
        }
    }
}

