/*
 * Decompiled with CFR 0.152.
 */
package com.getperka.flatpack.doclets;

import com.google.gson.stream.JsonWriter;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.tools.javadoc.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DocStringsDoclet {
    private static final String EXAMPLE_TYPE_NAME = "com.getperka.flatpack.Example";
    private static final Charset UTF8 = Charset.forName("UTF8");
    private File outputDir;
    private Map<PackageDoc, JsonWriter> writersByPackage = new HashMap<PackageDoc, JsonWriter>();

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static void main(String[] args) {
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("-doclet");
        args2.add(DocStringsDoclet.class.getName());
        args2.addAll(Arrays.asList(args));
        Main.execute((String[])args2.toArray(new String[args2.size()]));
    }

    public static int optionLength(String option) {
        if ("-d".equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean start(RootDoc root) {
        try {
            new DocStringsDoclet().exec(root);
        }
        catch (Throwable e) {
            root.printError(e.getClass().getName() + " : " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private int braceCount(CharSequence chars, int count) {
        int j = chars.length();
        block4: for (int i = 0; i < j; ++i) {
            switch (chars.charAt(i)) {
                case '{': {
                    ++count;
                    continue block4;
                }
                case '}': {
                    --count;
                }
            }
        }
        return count;
    }

    private int countInitialWhitespace(CharSequence chars) {
        int j = chars.length();
        for (int i = 0; i < j; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private String docString(Doc doc) {
        return this.docString(doc.inlineTags());
    }

    private String docString(ParamTag tag) {
        return this.docString(tag.inlineTags());
    }

    private String docString(Tag[] inlineTags) {
        StringBuilder text = new StringBuilder();
        for (Tag tag : inlineTags) {
            if ("Text".equals(tag.kind())) {
                text.append(tag.text());
                continue;
            }
            if ("@see".equals(tag.kind())) {
                SeeTag see = (SeeTag)tag;
                text.append("{").append(tag.name()).append(" ");
                if (see.referencedMember() != null) {
                    text.append(this.key((Doc)see.referencedMember()));
                } else if (see.referencedClass() != null) {
                    text.append(this.key(see.referencedClass()));
                }
                String tagText = tag.text();
                int idx = tagText.indexOf(32);
                if (idx != -1) {
                    tagText = tagText.substring(idx + 1);
                }
                text.append(" ").append(tagText).append("}");
                continue;
            }
            String tagName = tag.name().substring(1);
            text.append("<" + tagName + ">" + tag.text() + "</" + tagName + ">");
        }
        return text.toString();
    }

    private void examineClass(ClassDoc clazz) throws IOException {
        String doc;
        JsonWriter writer = this.getJsonWriter(clazz);
        String classKey = this.key(clazz);
        if (this.hasAnnotation((ProgramElementDoc)clazz, EXAMPLE_TYPE_NAME)) {
            String contents = this.extractContents((Doc)clazz);
            writer.name(classKey + ":contents");
            writer.value(contents);
        }
        if (!(doc = this.docString((Doc)clazz)).isEmpty()) {
            writer.name(classKey);
            writer.value(doc);
        }
        for (FieldDoc fieldDoc : clazz.fields(true)) {
            doc = this.docString((Doc)fieldDoc);
            if (doc.isEmpty()) continue;
            writer.name(this.key(fieldDoc));
            writer.value(doc);
        }
        for (FieldDoc fieldDoc : clazz.methods(true)) {
            String methodKey = this.key((MethodDoc)fieldDoc);
            if (this.hasAnnotation((ProgramElementDoc)fieldDoc, EXAMPLE_TYPE_NAME)) {
                String contents = this.extractContents((Doc)fieldDoc);
                writer.name(methodKey + ":contents");
                writer.value(contents);
            }
            if ((doc = this.docString((Doc)fieldDoc)).isEmpty()) continue;
            writer.name(methodKey);
            writer.value(doc);
            HashMap<String, Integer> namesToPositions = new HashMap<String, Integer>();
            for (Parameter parameter : fieldDoc.parameters()) {
                namesToPositions.put(parameter.name(), namesToPositions.size());
            }
            for (Parameter parameter : fieldDoc.paramTags()) {
                Integer position = (Integer)namesToPositions.get(parameter.parameterName());
                if (position == null) continue;
                writer.name(methodKey + "[" + position + "]");
                writer.value(this.docString((ParamTag)parameter));
            }
        }
    }

    private void exec(RootDoc root) throws IOException {
        this.extractOptions(root);
        for (ClassDoc clazz : root.classes()) {
            this.examineClass(clazz);
        }
        for (JsonWriter writer : this.writersByPackage.values()) {
            writer.endObject();
            writer.close();
        }
    }

    private String extractContents(Doc doc) throws IOException {
        SourcePosition position = doc.position();
        File f = position.file();
        if (f == null) {
            return null;
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        int j = position.line() - 1;
        for (int i = 0; i < j; ++i) {
            r.readLine();
        }
        ArrayList<String> strings = new ArrayList<String>();
        int padCount = Integer.MAX_VALUE;
        int braceCount = 0;
        do {
            String line;
            if ((braceCount = this.braceCount(line = r.readLine(), braceCount)) < 0) continue;
            strings.add(line);
            padCount = Math.min(padCount, this.countInitialWhitespace(line));
        } while (braceCount > 0);
        StringBuilder sb = new StringBuilder();
        boolean needsNewline = false;
        for (String s : strings) {
            if (needsNewline) {
                sb.append("\n");
            } else {
                needsNewline = true;
            }
            String toAppend = s.length() > padCount ? s.substring(padCount) : "";
            sb.append(toAppend);
        }
        return sb.toString();
    }

    private void extractOptions(RootDoc doc) {
        for (String[] option : doc.options()) {
            String name = option[0];
            if (!"-d".equals(name)) continue;
            this.outputDir = new File(option[1]);
            this.outputDir.mkdirs();
        }
    }

    private JsonWriter getJsonWriter(ClassDoc clazz) throws IOException {
        PackageDoc pkg = clazz.containingPackage();
        JsonWriter toReturn = this.writersByPackage.get(pkg);
        if (toReturn == null) {
            toReturn = new JsonWriter(this.openWriter(pkg.name().replace('.', '/') + "/package.json"));
            toReturn.setIndent("  ");
            this.writersByPackage.put(pkg, toReturn);
            toReturn.beginObject();
        }
        return toReturn;
    }

    private boolean hasAnnotation(ProgramElementDoc doc, String typeName) {
        for (AnnotationDesc annotation : doc.annotations()) {
            if (!typeName.equals(annotation.annotationType().qualifiedTypeName())) continue;
            return true;
        }
        return false;
    }

    private String key(ClassDoc clazz) {
        return clazz.qualifiedName();
    }

    private String key(Doc doc) {
        if (doc instanceof ClassDoc) {
            return this.key((ClassDoc)doc);
        }
        if (doc instanceof FieldDoc) {
            return this.key((FieldDoc)doc);
        }
        if (doc instanceof MethodDoc) {
            return this.key((MethodDoc)doc);
        }
        throw new IllegalArgumentException("Unspported type " + doc.getClass().getName());
    }

    private String key(FieldDoc field) {
        return this.key(field.containingClass()) + ":" + field.name();
    }

    private String key(MethodDoc method) {
        return this.key(method.containingClass()) + ":" + method.name() + method.signature();
    }

    private Writer openWriter(String relativePath) throws IOException {
        File outputFile = this.outputFile(relativePath);
        outputFile.getParentFile().mkdirs();
        return new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), UTF8);
    }

    private File outputFile(String relativePath) {
        return new File(this.outputDir, relativePath);
    }
}

