/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Plugin;

import com.geteasyqa.EasyQA.EasyQAPluginProperties;
import com.geteasyqa.EasyQA.Plugin.EasyQABuildFailureMode;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import org.kohsuke.stapler.DataBoundConstructor;

public class EasyQASite {
    private String name;
    private String url;
    private String email;
    private String password;
    private String token;
    private transient boolean pluginEnabled;
    private EasyQABuildFailureMode failureMode;

    @DataBoundConstructor
    public EasyQASite(String name, String email, String password, String url, String token) {
        this.name = name;
        this.email = email;
        this.password = password;
        this.url = url;
        this.token = token;
    }

    public static EasyQASite get(AbstractProject<?, ?> project) {
        EasyQASite site;
        EasyQAPluginProperties ypp = (EasyQAPluginProperties)project.getProperty(EasyQAPluginProperties.class);
        if (ypp != null && (site = ypp.getSite()) != null) {
            return site;
        }
        EasyQASite[] sites = EasyQAPluginProperties.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public void failed(AbstractBuild<?, ?> build) {
        if (this.failureMode != null) {
            switch (this.failureMode) {
                case NONE: {
                    break;
                }
                case UNSTABLE: {
                    build.setResult(Result.UNSTABLE);
                    break;
                }
                case FAILURE: {
                    build.setResult(Result.FAILURE);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
    }

    public void setFailureMode(EasyQABuildFailureMode failureMode) {
        this.failureMode = failureMode;
    }
}

