/*
 * Decompiled with CFR 0.152.
 */
package com.geteasyqa.EasyQA.Issues;

import com.geteasyqa.EasyQA.API.GetNotRequiredParameters;
import com.geteasyqa.EasyQA.API.GetResponse;
import com.geteasyqa.EasyQA.API.Initialization;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Response;

public class UpdateIssue
extends Initialization {
    public UpdateIssue(String url) {
        super(url);
    }

    public Map<String, String> updateIssue(String token, String auth_token, String id, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        Call<ResponseBody> call = this.easyqaUserAPI.updateIssue(id, model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        if (result != null) {
            Map<String, String> issue = new GetResponse().getMapStringFromJSON(result, "id", "summary");
            return issue;
        }
        System.out.println("Something went wrong");
        return null;
    }

    public void updateIssueByIdInProject(String token, String auth_token, String id, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        Call<ResponseBody> call = this.easyqaUserAPI.updateIssueByIdInProject(id, model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        if (result != null) {
            System.out.println(result);
            if (result.startsWith("{")) {
                JSONObject jsonObj = new JSONObject(result);
                Integer id_value = jsonObj.getInt("id");
                System.out.println("Issue is updated! id=" + id_value);
            } else {
                System.out.println(result);
            }
        } else {
            System.out.println("Something went wrong");
        }
    }

    public void updateIssueStatus(String token, String auth_token, String id, String status_id, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("status_id", RequestBody.create((MediaType)this.textType, (String)status_id));
        Call<ResponseBody> call = this.easyqaUserAPI.updateIssue(id, model);
        Response bodyResponse = call.execute();
        String result = ((ResponseBody)bodyResponse.body()).string();
        if (result != null) {
            System.out.println(result);
            if (result.startsWith("{")) {
                JSONObject jsonObj = new JSONObject(result);
                Integer id_value = jsonObj.getInt("id");
                System.out.println("Issue is updated! id=" + id_value);
            } else {
                System.out.println(result);
            }
        } else {
            System.out.println("Something went wrong");
        }
    }

    public void updateIssueStatusByIdInProject(String token, String auth_token, String id, String status_id, String ... data) throws IOException, JSONException {
        Map<String, RequestBody> model = new GetNotRequiredParameters().getIntoMap("text/plain", data);
        model.put("token", RequestBody.create((MediaType)this.textType, (String)token));
        model.put("auth_token", RequestBody.create((MediaType)this.textType, (String)auth_token));
        model.put("status_id", RequestBody.create((MediaType)this.textType, (String)status_id));
        Call<ResponseBody> call = this.easyqaUserAPI.updateIssueByIdInProject(id, model);
        Response bodyResponse = call.execute();
        ((ResponseBody)bodyResponse.body()).string();
    }
}

